/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.RegisterBrokerToControllerRequestHeader;

public interface Controller {
    public void startup();

    public void shutdown();

    public void startScheduling();

    public void stopScheduling();

    public boolean isLeaderState();

    public CompletableFuture<RemotingCommand> alterSyncStateSet(AlterSyncStateSetRequestHeader var1, SyncStateSet var2);

    public CompletableFuture<RemotingCommand> electMaster(ElectMasterRequestHeader var1);

    public CompletableFuture<RemotingCommand> registerBroker(RegisterBrokerToControllerRequestHeader var1);

    public CompletableFuture<RemotingCommand> getReplicaInfo(GetReplicaInfoRequestHeader var1);

    public RemotingCommand getControllerMetadata();

    public CompletableFuture<RemotingCommand> getSyncStateData(List<String> var1);

    public RemotingServer getRemotingServer();

    public CompletableFuture<RemotingCommand> cleanBrokerData(CleanControllerBrokerDataRequestHeader var1);
}

