/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.rpc;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.rpc.RpcRequestHeader;
import org.apache.rocketmq.remoting.rpc.TopicQueueRequestHeader;

public class RequestBuilder {
    private static Map<Integer, Class> requestCodeMap = new HashMap<Integer, Class>();

    public static RpcRequestHeader buildCommonRpcHeader(int requestCode, String destBrokerName) {
        return RequestBuilder.buildCommonRpcHeader(requestCode, null, destBrokerName);
    }

    public static RpcRequestHeader buildCommonRpcHeader(int requestCode, Boolean oneway, String destBrokerName) {
        Class requestHeaderClass = requestCodeMap.get(requestCode);
        if (requestHeaderClass == null) {
            throw new UnsupportedOperationException("unknown " + requestCode);
        }
        try {
            RpcRequestHeader requestHeader = (RpcRequestHeader)requestHeaderClass.newInstance();
            requestHeader.setOway(oneway);
            requestHeader.setBname(destBrokerName);
            return requestHeader;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static TopicQueueRequestHeader buildTopicQueueRequestHeader(int requestCode, MessageQueue mq) {
        return RequestBuilder.buildTopicQueueRequestHeader(requestCode, null, mq.getBrokerName(), mq.getTopic(), mq.getQueueId(), null);
    }

    public static TopicQueueRequestHeader buildTopicQueueRequestHeader(int requestCode, MessageQueue mq, Boolean logic) {
        return RequestBuilder.buildTopicQueueRequestHeader(requestCode, null, mq.getBrokerName(), mq.getTopic(), mq.getQueueId(), logic);
    }

    public static TopicQueueRequestHeader buildTopicQueueRequestHeader(int requestCode, Boolean oneway, MessageQueue mq, Boolean logic) {
        return RequestBuilder.buildTopicQueueRequestHeader(requestCode, oneway, mq.getBrokerName(), mq.getTopic(), mq.getQueueId(), logic);
    }

    public static TopicQueueRequestHeader buildTopicQueueRequestHeader(int requestCode, Boolean oneway, String destBrokerName, String topic, int queueId, Boolean logic) {
        Class requestHeaderClass = requestCodeMap.get(requestCode);
        if (requestHeaderClass == null) {
            throw new UnsupportedOperationException("unknown " + requestCode);
        }
        try {
            TopicQueueRequestHeader requestHeader = (TopicQueueRequestHeader)requestHeaderClass.newInstance();
            requestHeader.setOway(oneway);
            requestHeader.setBname(destBrokerName);
            requestHeader.setTopic(topic);
            requestHeader.setQueueId(queueId);
            requestHeader.setLo(logic);
            return requestHeader;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        requestCodeMap.put(11, PullMessageRequestHeader.class);
    }
}

