/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.file.CompositeFlatFile;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.file.TieredFlatFileManager;
import org.apache.rocketmq.tieredstore.file.TieredIndexFile;
import org.apache.rocketmq.tieredstore.metadata.QueueMetadata;
import org.apache.rocketmq.tieredstore.metadata.TopicMetadata;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class CompositeQueueFlatFile
extends CompositeFlatFile {
    private final MessageQueue messageQueue;
    private long topicSequenceNumber;
    private QueueMetadata queueMetadata;
    private final TieredIndexFile indexFile;

    public CompositeQueueFlatFile(TieredFileAllocator fileQueueFactory, MessageQueue messageQueue) {
        super(fileQueueFactory, TieredStoreUtil.toPath(messageQueue));
        this.messageQueue = messageQueue;
        this.recoverTopicMetadata();
        super.recoverMetadata();
        this.indexFile = TieredFlatFileManager.getIndexFile(this.storeConfig);
    }

    @Override
    public void initOffset(long offset) {
        if (!this.consumeQueue.isInitialized()) {
            this.queueMetadata.setMinOffset(offset);
            this.queueMetadata.setMaxOffset(offset);
        }
        super.initOffset(offset);
    }

    public void recoverTopicMetadata() {
        TopicMetadata topicMetadata = this.metadataStore.getTopic(this.messageQueue.getTopic());
        if (topicMetadata == null) {
            topicMetadata = this.metadataStore.addTopic(this.messageQueue.getTopic(), -1L);
        }
        this.topicSequenceNumber = topicMetadata.getTopicId();
        this.queueMetadata = this.metadataStore.getQueue(this.messageQueue);
        if (this.queueMetadata == null) {
            this.queueMetadata = this.metadataStore.addQueue(this.messageQueue, -1L);
        }
        if (this.queueMetadata.getMaxOffset() < this.queueMetadata.getMinOffset()) {
            this.queueMetadata.setMaxOffset(this.queueMetadata.getMinOffset());
        }
        this.dispatchOffset = this.queueMetadata.getMaxOffset();
    }

    public void persistMetadata() {
        try {
            if (this.consumeQueue.getCommitOffset() < this.queueMetadata.getMinOffset()) {
                return;
            }
            this.queueMetadata.setMaxOffset(this.consumeQueue.getCommitOffset() / 20L);
            this.metadataStore.updateQueue(this.queueMetadata);
        }
        catch (Exception e) {
            LOGGER.error("CompositeFlatFile#flushMetadata: update queue metadata failed: topic: {}, queue: {}", new Object[]{this.messageQueue.getTopic(), this.messageQueue.getQueueId(), e});
        }
    }

    public AppendResult appendIndexFile(DispatchRequest request) {
        AppendResult result;
        if (this.closed) {
            return AppendResult.FILE_CLOSED;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getUniqKey()) && (result = this.indexFile.append(this.messageQueue, (int)this.topicSequenceNumber, request.getUniqKey(), request.getCommitLogOffset(), request.getMsgSize(), request.getStoreTimestamp())) != AppendResult.SUCCESS) {
            return result;
        }
        for (String key : request.getKeys().split(" ")) {
            AppendResult result2;
            if (!StringUtils.isNotBlank((CharSequence)key) || (result2 = this.indexFile.append(this.messageQueue, (int)this.topicSequenceNumber, key, request.getCommitLogOffset(), request.getMsgSize(), request.getStoreTimestamp())) == AppendResult.SUCCESS) continue;
            return result2;
        }
        return AppendResult.SUCCESS;
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.metadataStore.updateQueue(this.queueMetadata);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.metadataStore.deleteQueue(this.messageQueue);
    }
}

