/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.ExpressionForRetryMessageFilter;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.longpolling.PullRequest;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageContext;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.plugin.PullMessageResultHandler;
import org.apache.rocketmq.broker.processor.DefaultPullMessageResultHandler;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RequestSource;
import org.apache.rocketmq.remoting.protocol.filter.FilterAPI;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.rpc.RpcClientUtils;
import org.apache.rocketmq.remoting.rpc.RpcRequest;
import org.apache.rocketmq.remoting.rpc.RpcRequestHeader;
import org.apache.rocketmq.remoting.rpc.RpcResponse;
import org.apache.rocketmq.remoting.rpc.TopicRequestHeader;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class PullMessageProcessor
implements NettyRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private List<ConsumeMessageHook> consumeMessageHookList;
    private PullMessageResultHandler pullMessageResultHandler;
    private final BrokerController brokerController;

    public PullMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.pullMessageResultHandler = new DefaultPullMessageResultHandler(brokerController);
    }

    private RemotingCommand rewriteRequestForStaticTopic(PullMessageRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            String topic = mappingContext.getTopic();
            Integer globalId = mappingContext.getGlobalId();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d cannot find mapping item in request process of current broker %s", topic, globalId, mappingDetail.getBname()));
            }
            Long globalOffset = requestHeader.getQueueOffset();
            LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)globalOffset, (boolean)true);
            mappingContext.setCurrentItem(mappingItem);
            if (globalOffset < mappingItem.getLogicOffset()) {
                // empty if block
            }
            String bname = mappingItem.getBname();
            Integer phyQueueId = mappingItem.getQueueId();
            Long phyQueueOffset = mappingItem.computePhysicalQueueOffset(globalOffset.longValue());
            requestHeader.setQueueId(phyQueueId);
            requestHeader.setQueueOffset(phyQueueOffset);
            if (mappingItem.checkIfEndOffsetDecided() && requestHeader.getMaxMsgNums() != null) {
                requestHeader.setMaxMsgNums(Integer.valueOf((int)Math.min(mappingItem.getEndOffset() - mappingItem.getStartOffset(), (long)requestHeader.getMaxMsgNums().intValue())));
            }
            if (mappingDetail.getBname().equals(bname)) {
                return null;
            }
            int sysFlag = requestHeader.getSysFlag();
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setBname(bname);
            sysFlag = PullSysFlag.clearSuspendFlag((int)sysFlag);
            sysFlag = PullSysFlag.clearCommitOffsetFlag((int)sysFlag);
            requestHeader.setSysFlag(Integer.valueOf(sysFlag));
            RpcRequest rpcRequest = new RpcRequest(11, (RpcRequestHeader)requestHeader, null);
            RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
            if (rpcResponse.getException() != null) {
                throw rpcResponse.getException();
            }
            PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)rpcResponse.getHeader();
            RemotingCommand rewriteResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, rpcResponse.getCode());
            if (rewriteResult != null) {
                return rewriteResult;
            }
            return RpcClientUtils.createCommandForRpcResponse((RpcResponse)rpcResponse);
        }
        catch (Throwable t) {
            LOGGER.warn("", t);
            return RemotingCommand.buildErrorResponse((int)1, (String)t.toString());
        }
    }

    protected RemotingCommand rewriteResponseForStaticTopic(PullMessageRequestHeader requestHeader, PullMessageResponseHeader responseHeader, TopicQueueMappingContext mappingContext, int code) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            LogicQueueMappingItem leaderItem = mappingContext.getLeaderItem();
            LogicQueueMappingItem currentItem = mappingContext.getCurrentItem();
            LogicQueueMappingItem earlistItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)0L, (boolean)true);
            assert (currentItem.getLogicOffset() >= 0L);
            long requestOffset = requestHeader.getQueueOffset();
            long nextBeginOffset = responseHeader.getNextBeginOffset();
            long minOffset = responseHeader.getMinOffset();
            long maxOffset = responseHeader.getMaxOffset();
            int responseCode = code;
            if (code != 0) {
                LogicQueueMappingItem nextItem;
                boolean isRevised = false;
                if (leaderItem.getGen() == currentItem.getGen()) {
                    if (requestOffset > maxOffset) {
                        if (code == 21) {
                            responseCode = 21;
                            nextBeginOffset = maxOffset;
                        } else {
                            responseCode = code;
                        }
                    } else if (requestOffset < minOffset) {
                        nextBeginOffset = minOffset;
                        responseCode = 20;
                    } else {
                        responseCode = code;
                    }
                }
                if (earlistItem.getGen() == currentItem.getGen()) {
                    if (requestOffset < minOffset) {
                        if (code == 21) {
                            responseCode = 21;
                            nextBeginOffset = minOffset;
                        } else {
                            responseCode = 21;
                            nextBeginOffset = minOffset;
                        }
                    } else if (requestOffset >= maxOffset) {
                        nextItem = TopicQueueMappingUtils.findNext((List)mappingContext.getMappingItemList(), (LogicQueueMappingItem)currentItem, (boolean)true);
                        if (nextItem != null) {
                            isRevised = true;
                            currentItem = nextItem;
                            nextBeginOffset = currentItem.getStartOffset();
                            maxOffset = minOffset = currentItem.getStartOffset();
                            responseCode = 20;
                        } else {
                            responseCode = 19;
                        }
                    } else {
                        responseCode = code;
                    }
                }
                if (!isRevised && leaderItem.getGen() != currentItem.getGen() && earlistItem.getGen() != currentItem.getGen()) {
                    if (requestOffset < minOffset) {
                        nextBeginOffset = minOffset;
                        responseCode = 20;
                    } else if (requestOffset >= maxOffset) {
                        nextItem = TopicQueueMappingUtils.findNext((List)mappingContext.getMappingItemList(), (LogicQueueMappingItem)currentItem, (boolean)true);
                        if (nextItem != null) {
                            currentItem = nextItem;
                            nextBeginOffset = currentItem.getStartOffset();
                            maxOffset = minOffset = currentItem.getStartOffset();
                            responseCode = 20;
                        } else {
                            responseCode = 19;
                        }
                    } else {
                        responseCode = code;
                    }
                }
            }
            if (currentItem.checkIfEndOffsetDecided() && nextBeginOffset >= currentItem.getEndOffset()) {
                nextBeginOffset = currentItem.getEndOffset();
            }
            responseHeader.setNextBeginOffset(Long.valueOf(currentItem.computeStaticQueueOffsetStrictly(nextBeginOffset)));
            responseHeader.setMinOffset(Long.valueOf(currentItem.computeStaticQueueOffsetStrictly(Math.max(currentItem.getStartOffset(), minOffset))));
            responseHeader.setMaxOffset(Long.valueOf(Math.max(currentItem.computeStaticQueueOffsetStrictly(maxOffset), TopicQueueMappingDetail.computeMaxOffsetFromMapping((TopicQueueMappingDetail)mappingDetail, (Integer)mappingContext.getGlobalId()))));
            responseHeader.setOffsetDelta(Long.valueOf(currentItem.computeOffsetDelta()));
            if (code != 0) {
                return RemotingCommand.createResponseCommandWithHeader((int)responseCode, (CommandCustomHeader)responseHeader);
            }
            return null;
        }
        catch (Throwable t) {
            LOGGER.warn("", t);
            return RemotingCommand.buildErrorResponse((int)1, (String)t.toString());
        }
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true, true);
    }

    public boolean rejectRequest() {
        return !this.brokerController.getBrokerConfig().isSlaveReadEnable() && this.brokerController.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemotingCommand processRequest(Channel channel, RemotingCommand request, boolean brokerAllowSuspend, boolean brokerAllowFlowCtrSuspend) throws RemotingCommandException {
        void var15_19;
        ConsumerFilterData consumerFilterData;
        SubscriptionData subscriptionData;
        TopicQueueMappingContext mappingContext;
        SubscriptionGroupConfig subscriptionGroupConfig;
        PullMessageRequestHeader requestHeader;
        RemotingCommand response;
        block38: {
            response = RemotingCommand.createResponseCommand(PullMessageResponseHeader.class);
            PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.readCustomHeader();
            requestHeader = (PullMessageRequestHeader)request.decodeCommandCustomHeader(PullMessageRequestHeader.class);
            response.setOpaque(request.getOpaque());
            LOGGER.debug("receive PullMessage request command, {}", (Object)request);
            if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(1));
                response.setRemark(String.format("the broker[%s] pulling message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
                return response;
            }
            if (request.getCode() == 361 && !this.brokerController.getBrokerConfig().isLitePullMessageEnable()) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(1));
                response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] for lite pull consumer is forbidden");
                return response;
            }
            subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
            if (null == subscriptionGroupConfig) {
                response.setCode(26);
                response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
                return response;
            }
            if (!subscriptionGroupConfig.isConsumeEnable()) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(2));
                response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
                return response;
            }
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
            if (null == topicConfig) {
                LOGGER.error("the topic {} not exist, consumer: {}", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                response.setCode(17);
                response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
                return response;
            }
            if (!PermName.isReadable((int)topicConfig.getPerm())) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(3));
                response.setRemark("the topic[" + requestHeader.getTopic() + "] pulling message is forbidden");
                return response;
            }
            mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader, false);
            RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext);
            if (rewriteResult != null) {
                return rewriteResult;
            }
            if (requestHeader.getQueueId() < 0 || requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
                String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
                LOGGER.warn(errorInfo);
                response.setCode(1);
                response.setRemark(errorInfo);
                return response;
            }
            ConsumerManager consumerManager = this.brokerController.getConsumerManager();
            switch (RequestSource.parseInteger((Integer)requestHeader.getRequestSource())) {
                case PROXY_FOR_BROADCAST: {
                    consumerManager.compensateBasicConsumerInfo(requestHeader.getConsumerGroup(), ConsumeType.CONSUME_PASSIVELY, MessageModel.BROADCASTING);
                    break;
                }
                case PROXY_FOR_STREAM: {
                    consumerManager.compensateBasicConsumerInfo(requestHeader.getConsumerGroup(), ConsumeType.CONSUME_ACTIVELY, MessageModel.CLUSTERING);
                    break;
                }
                default: {
                    consumerManager.compensateBasicConsumerInfo(requestHeader.getConsumerGroup(), ConsumeType.CONSUME_PASSIVELY, MessageModel.CLUSTERING);
                }
            }
            subscriptionData = null;
            consumerFilterData = null;
            boolean hasSubscriptionFlag = PullSysFlag.hasSubscriptionFlag((int)requestHeader.getSysFlag());
            if (hasSubscriptionFlag) {
                try {
                    subscriptionData = FilterAPI.build((String)requestHeader.getTopic(), (String)requestHeader.getSubscription(), (String)requestHeader.getExpressionType());
                    consumerManager.compensateSubscribeData(requestHeader.getConsumerGroup(), requestHeader.getTopic(), subscriptionData);
                    if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                        consumerFilterData = ConsumerFilterManager.build(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getSubscription(), requestHeader.getExpressionType(), requestHeader.getSubVersion());
                        assert (consumerFilterData != null);
                    }
                    break block38;
                }
                catch (Exception exception) {
                    LOGGER.warn("Parse the consumer's subscription[{}] failed, group: {}", (Object)requestHeader.getSubscription(), (Object)requestHeader.getConsumerGroup());
                    response.setCode(23);
                    response.setRemark("parse the consumer's subscription failed");
                    return response;
                }
            }
            ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
            if (null == consumerGroupInfo) {
                LOGGER.warn("the consumer's group info not exist, group: {}", (Object)requestHeader.getConsumerGroup());
                response.setCode(24);
                response.setRemark("the consumer's group info not exist" + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
                return response;
            }
            if (!subscriptionGroupConfig.isConsumeBroadcastEnable() && consumerGroupInfo.getMessageModel() == MessageModel.BROADCASTING) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(4));
                response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] can not consume by broadcast way");
                return response;
            }
            boolean readForbidden = this.brokerController.getSubscriptionGroupManager().getForbidden(subscriptionGroupConfig.getGroupName(), requestHeader.getTopic(), 2);
            if (readForbidden) {
                response.setCode(16);
                responseHeader.setForbiddenType(Integer.valueOf(5));
                response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] is forbidden for topic[" + requestHeader.getTopic() + "]");
                return response;
            }
            subscriptionData = consumerGroupInfo.findSubscriptionData(requestHeader.getTopic());
            if (null == subscriptionData) {
                LOGGER.warn("the consumer's subscription not exist, group: {}, topic:{}", (Object)requestHeader.getConsumerGroup(), (Object)requestHeader.getTopic());
                response.setCode(24);
                response.setRemark("the consumer's subscription not exist" + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
                return response;
            }
            if (subscriptionData.getSubVersion() < requestHeader.getSubVersion()) {
                LOGGER.warn("The broker's subscription is not latest, group: {} {}", (Object)requestHeader.getConsumerGroup(), (Object)subscriptionData.getSubString());
                response.setCode(25);
                response.setRemark("the consumer's subscription not latest");
                return response;
            }
            if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType())) {
                consumerFilterData = this.brokerController.getConsumerFilterManager().get(requestHeader.getTopic(), requestHeader.getConsumerGroup());
                if (consumerFilterData == null) {
                    response.setCode(27);
                    response.setRemark("The broker's consumer filter data is not exist!Your expression may be wrong!");
                    return response;
                }
                if (consumerFilterData.getClientVersion() < requestHeader.getSubVersion()) {
                    LOGGER.warn("The broker's consumer filter data is not latest, group: {}, topic: {}, serverV: {}, clientV: {}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), consumerFilterData.getClientVersion(), requestHeader.getSubVersion()});
                    response.setCode(28);
                    response.setRemark("the consumer's consumer filter data not latest");
                    return response;
                }
            }
        }
        if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType()) && !this.brokerController.getBrokerConfig().isEnablePropertyFilter()) {
            response.setCode(1);
            response.setRemark("The broker does not support consumer to filter message by " + subscriptionData.getExpressionType());
            return response;
        }
        if (this.brokerController.getBrokerConfig().isFilterSupportRetry()) {
            ExpressionForRetryMessageFilter expressionForRetryMessageFilter = new ExpressionForRetryMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
        } else {
            ExpressionMessageFilter expressionMessageFilter = new ExpressionMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
        }
        MessageStore messageStore = this.brokerController.getMessageStore();
        if (this.brokerController.getMessageStore() instanceof DefaultMessageStore) {
            boolean isMsgLogicCold;
            DefaultMessageStore defaultMessageStore = (DefaultMessageStore)this.brokerController.getMessageStore();
            boolean cgNeedColdDataFlowCtr = this.brokerController.getColdDataCgCtrService().isCgNeedColdDataFlowCtr(requestHeader.getConsumerGroup());
            if (cgNeedColdDataFlowCtr && (isMsgLogicCold = defaultMessageStore.getCommitLog().getColdDataCheckService().isMsgInColdArea(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), requestHeader.getQueueOffset().longValue()))) {
                ConsumeType consumeType = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup()).getConsumeType();
                if (consumeType == ConsumeType.CONSUME_PASSIVELY) {
                    response.setCode(2);
                    response.setRemark("This consumer group is reading cold data. It has been flow control");
                    return response;
                }
                if (consumeType == ConsumeType.CONSUME_ACTIVELY) {
                    if (brokerAllowFlowCtrSuspend) {
                        PullRequest pullRequest = new PullRequest(request, channel, 1000L, this.brokerController.getMessageStore().now(), requestHeader.getQueueOffset(), subscriptionData, (MessageFilter)var15_19);
                        this.brokerController.getColdDataPullRequestHoldService().suspendColdDataReadRequest(pullRequest);
                        return null;
                    }
                    requestHeader.setMaxMsgNums(Integer.valueOf(1));
                }
            }
        }
        boolean useResetOffsetFeature = this.brokerController.getBrokerConfig().isUseServerSideResetOffset();
        String topic = requestHeader.getTopic();
        String group = requestHeader.getConsumerGroup();
        int queueId = requestHeader.getQueueId();
        Long resetOffset = this.brokerController.getConsumerOffsetManager().queryThenEraseResetOffset(topic, group, queueId);
        GetMessageResult getMessageResult = null;
        if (useResetOffsetFeature && null != resetOffset) {
            getMessageResult = new GetMessageResult();
            getMessageResult.setStatus(GetMessageStatus.OFFSET_RESET);
            getMessageResult.setNextBeginOffset(resetOffset.longValue());
            getMessageResult.setMinOffset(messageStore.getMinOffsetInQueue(topic, queueId));
            getMessageResult.setMaxOffset(messageStore.getMaxOffsetInQueue(topic, queueId));
            getMessageResult.setSuggestPullingFromSlave(false);
        } else {
            long broadcastInitOffset = this.queryBroadcastPullInitOffset(topic, group, queueId, requestHeader, channel);
            if (broadcastInitOffset >= 0L) {
                getMessageResult = new GetMessageResult();
                getMessageResult.setStatus(GetMessageStatus.OFFSET_RESET);
                getMessageResult.setNextBeginOffset(broadcastInitOffset);
            } else {
                SubscriptionData finalSubscriptionData = subscriptionData;
                RemotingCommand finalResponse = response;
                ((CompletableFuture)messageStore.getMessageAsync(group, topic, queueId, requestHeader.getQueueOffset().longValue(), requestHeader.getMaxMsgNums().intValue(), (MessageFilter)var15_19).thenApply(arg_0 -> this.lambda$processRequest$0(finalResponse, requestHeader, request, channel, finalSubscriptionData, subscriptionGroupConfig, brokerAllowSuspend, (MessageFilter)var15_19, mappingContext, arg_0))).thenAccept(result -> NettyRemotingAbstract.writeResponse((Channel)channel, (RemotingCommand)request, (RemotingCommand)result));
            }
        }
        if (getMessageResult != null) {
            return this.pullMessageResultHandler.handle(getMessageResult, request, requestHeader, channel, subscriptionData, subscriptionGroupConfig, brokerAllowSuspend, (MessageFilter)var15_19, response, mappingContext);
        }
        return null;
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    protected void composeResponseHeader(PullMessageRequestHeader requestHeader, GetMessageResult getMessageResult, int topicSysFlag, SubscriptionGroupConfig subscriptionGroupConfig, RemotingCommand response, String clientAddress) {
        PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.readCustomHeader();
        response.setRemark(getMessageResult.getStatus().name());
        responseHeader.setNextBeginOffset(Long.valueOf(getMessageResult.getNextBeginOffset()));
        responseHeader.setMinOffset(Long.valueOf(getMessageResult.getMinOffset()));
        responseHeader.setMaxOffset(Long.valueOf(getMessageResult.getMaxOffset()));
        responseHeader.setTopicSysFlag(Integer.valueOf(topicSysFlag));
        responseHeader.setGroupSysFlag(Integer.valueOf(subscriptionGroupConfig.getGroupSysFlag()));
        switch (getMessageResult.getStatus()) {
            case FOUND: {
                response.setCode(0);
                break;
            }
            case MESSAGE_WAS_REMOVING: 
            case NO_MATCHED_MESSAGE: {
                response.setCode(20);
                break;
            }
            case NO_MATCHED_LOGIC_QUEUE: 
            case NO_MESSAGE_IN_QUEUE: {
                if (0L != requestHeader.getQueueOffset()) {
                    response.setCode(21);
                    LOGGER.info("the broker stores no queue data, fix the request offset {} to {}, Topic: {} QueueId: {} Consumer Group: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getNextBeginOffset(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getConsumerGroup()});
                    break;
                }
                response.setCode(19);
                break;
            }
            case OFFSET_FOUND_NULL: 
            case OFFSET_OVERFLOW_ONE: {
                response.setCode(19);
                break;
            }
            case OFFSET_OVERFLOW_BADLY: {
                response.setCode(21);
                LOGGER.info("the request offset: {} over flow badly, fix to {}, broker max offset: {}, consumer: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getNextBeginOffset(), getMessageResult.getMaxOffset(), clientAddress});
                break;
            }
            case OFFSET_RESET: {
                response.setCode(21);
                LOGGER.info("The queue under pulling was previously reset to start from {}", (Object)getMessageResult.getNextBeginOffset());
                break;
            }
            case OFFSET_TOO_SMALL: {
                response.setCode(21);
                LOGGER.info("the request offset too small. group={}, topic={}, requestOffset={}, brokerMinOffset={}, clientIp={}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueOffset(), getMessageResult.getMinOffset(), clientAddress});
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.brokerController.getBrokerConfig().isSlaveReadEnable() && !this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            if (getMessageResult.isSuggestPullingFromSlave()) {
                responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getWhichBrokerWhenConsumeSlowly()));
            } else {
                responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getBrokerId()));
            }
        } else {
            responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
        }
        if (this.brokerController.getBrokerConfig().getBrokerId() != 0L && !getMessageResult.isSuggestPullingFromSlave() && this.brokerController.getMinBrokerIdInGroup() == 0L) {
            LOGGER.debug("slave redirect pullRequest to master, topic: {}, queueId: {}, consumer group: {}, next: {}, min: {}, max: {}", new Object[]{requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getConsumerGroup(), responseHeader.getNextBeginOffset(), responseHeader.getMinOffset(), responseHeader.getMaxOffset()});
            responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
            if (!getMessageResult.getStatus().equals((Object)GetMessageStatus.FOUND)) {
                response.setCode(20);
            }
        }
    }

    protected void executeConsumeMessageHookBefore(RemotingCommand request, PullMessageRequestHeader requestHeader, GetMessageResult getMessageResult, boolean brokerAllowSuspend, int responseCode) {
        if (this.hasConsumeMessageHook()) {
            String owner = (String)request.getExtFields().get("Owner");
            String authType = (String)request.getExtFields().get("AUTH_TYPE");
            String ownerParent = (String)request.getExtFields().get("OWNER_PARENT");
            String ownerSelf = (String)request.getExtFields().get("OWNER_SELF");
            ConsumeMessageContext context = new ConsumeMessageContext();
            context.setConsumerGroup(requestHeader.getConsumerGroup());
            context.setTopic(requestHeader.getTopic());
            context.setQueueId(requestHeader.getQueueId());
            context.setAccountAuthType(authType);
            context.setAccountOwnerParent(ownerParent);
            context.setAccountOwnerSelf(ownerSelf);
            context.setNamespace(NamespaceUtil.getNamespaceFromResource((String)requestHeader.getTopic()));
            switch (responseCode) {
                case 0: {
                    int commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                    int incValue = getMessageResult.getMsgCount4Commercial() * commercialBaseCount;
                    context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_SUCCESS);
                    context.setCommercialRcvTimes(incValue);
                    context.setCommercialRcvSize(getMessageResult.getBufferTotalSize());
                    context.setCommercialOwner(owner);
                    context.setRcvStat(BrokerStatsManager.StatsType.RCV_SUCCESS);
                    context.setRcvMsgNum(getMessageResult.getMessageCount());
                    context.setRcvMsgSize(getMessageResult.getBufferTotalSize());
                    context.setCommercialRcvMsgNum(getMessageResult.getMsgCount4Commercial());
                    break;
                }
                case 19: {
                    if (brokerAllowSuspend) break;
                    context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                    context.setCommercialRcvTimes(1);
                    context.setCommercialOwner(owner);
                    context.setRcvStat(BrokerStatsManager.StatsType.RCV_EPOLLS);
                    context.setRcvMsgNum(0);
                    context.setRcvMsgSize(0);
                    context.setCommercialRcvMsgNum(0);
                    break;
                }
                case 20: 
                case 21: {
                    context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                    context.setCommercialRcvTimes(1);
                    context.setCommercialOwner(owner);
                    context.setRcvStat(BrokerStatsManager.StatsType.RCV_EPOLLS);
                    context.setRcvMsgNum(0);
                    context.setRcvMsgSize(0);
                    context.setCommercialRcvMsgNum(0);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageBefore(context);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void tryCommitOffset(boolean brokerAllowSuspend, PullMessageRequestHeader requestHeader, long nextOffset, String clientAddress) {
        this.brokerController.getConsumerOffsetManager().commitPullOffset(clientAddress, requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), nextOffset);
        boolean storeOffsetEnable = brokerAllowSuspend;
        boolean hasCommitOffsetFlag = PullSysFlag.hasCommitOffsetFlag((int)requestHeader.getSysFlag());
        boolean bl = storeOffsetEnable = storeOffsetEnable && hasCommitOffsetFlag;
        if (storeOffsetEnable) {
            this.brokerController.getConsumerOffsetManager().commitOffset(clientAddress, requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getCommitOffset());
        }
    }

    public void executeRequestWhenWakeup(Channel channel, RemotingCommand request) {
        Runnable run = () -> {
            try {
                boolean brokerAllowFlowCtrSuspend = request.getExtFields() == null || !request.getExtFields().containsKey("_noSuspend_");
                RemotingCommand response = this.processRequest(channel, request, false, brokerAllowFlowCtrSuspend);
                if (response != null) {
                    response.setOpaque(request.getOpaque());
                    response.markResponseType();
                    try {
                        NettyRemotingAbstract.writeResponse((Channel)channel, (RemotingCommand)request, (RemotingCommand)response, future -> {
                            if (!future.isSuccess()) {
                                LOGGER.error("processRequestWrapper response to {} failed", (Object)channel.remoteAddress(), (Object)future.cause());
                                LOGGER.error(request.toString());
                                LOGGER.error(response.toString());
                            }
                        });
                    }
                    catch (Throwable e) {
                        LOGGER.error("processRequestWrapper process request over, but response failed", e);
                        LOGGER.error(request.toString());
                        LOGGER.error(response.toString());
                    }
                }
            }
            catch (RemotingCommandException e1) {
                LOGGER.error("excuteRequestWhenWakeup run", (Throwable)e1);
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, channel, request));
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> consumeMessageHookList) {
        this.consumeMessageHookList = consumeMessageHookList;
    }

    public void setPullMessageResultHandler(PullMessageResultHandler pullMessageResultHandler) {
        this.pullMessageResultHandler = pullMessageResultHandler;
    }

    private boolean isBroadcast(boolean proxyPullBroadcast, ConsumerGroupInfo consumerGroupInfo) {
        return proxyPullBroadcast || consumerGroupInfo != null && MessageModel.BROADCASTING.equals((Object)consumerGroupInfo.getMessageModel()) && ConsumeType.CONSUME_PASSIVELY.equals((Object)consumerGroupInfo.getConsumeType());
    }

    protected void updateBroadcastPulledOffset(String topic, String group, int queueId, PullMessageRequestHeader requestHeader, Channel channel, RemotingCommand response, long nextBeginOffset) {
        ConsumerGroupInfo consumerGroupInfo;
        if (response == null || !this.brokerController.getBrokerConfig().isEnableBroadcastOffsetStore()) {
            return;
        }
        boolean proxyPullBroadcast = Objects.equals(RequestSource.PROXY_FOR_BROADCAST.getValue(), requestHeader.getRequestSource());
        if (this.isBroadcast(proxyPullBroadcast, consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(group))) {
            String clientId;
            long offset = requestHeader.getQueueOffset();
            if (21 == response.getCode()) {
                offset = nextBeginOffset;
            }
            if (proxyPullBroadcast) {
                clientId = requestHeader.getProxyFrowardClientId();
            } else {
                ClientChannelInfo clientChannelInfo = consumerGroupInfo.findChannel(channel);
                if (clientChannelInfo == null) {
                    return;
                }
                clientId = clientChannelInfo.getClientId();
            }
            this.brokerController.getBroadcastOffsetManager().updateOffset(topic, group, queueId, offset, clientId, proxyPullBroadcast);
        }
    }

    protected long queryBroadcastPullInitOffset(String topic, String group, int queueId, PullMessageRequestHeader requestHeader, Channel channel) {
        if (!this.brokerController.getBrokerConfig().isEnableBroadcastOffsetStore()) {
            return -1L;
        }
        ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(group);
        boolean proxyPullBroadcast = Objects.equals(RequestSource.PROXY_FOR_BROADCAST.getValue(), requestHeader.getRequestSource());
        if (this.isBroadcast(proxyPullBroadcast, consumerGroupInfo)) {
            String clientId;
            if (proxyPullBroadcast) {
                clientId = requestHeader.getProxyFrowardClientId();
            } else {
                ClientChannelInfo clientChannelInfo = consumerGroupInfo.findChannel(channel);
                if (clientChannelInfo == null) {
                    return -1L;
                }
                clientId = clientChannelInfo.getClientId();
            }
            return this.brokerController.getBroadcastOffsetManager().queryInitOffset(topic, group, queueId, clientId, requestHeader.getQueueOffset(), proxyPullBroadcast);
        }
        return -1L;
    }

    private /* synthetic */ RemotingCommand lambda$processRequest$0(RemotingCommand finalResponse, PullMessageRequestHeader requestHeader, RemotingCommand request, Channel channel, SubscriptionData finalSubscriptionData, SubscriptionGroupConfig subscriptionGroupConfig, boolean brokerAllowSuspend, MessageFilter messageFilter, TopicQueueMappingContext mappingContext, GetMessageResult result) {
        if (null == result) {
            finalResponse.setCode(1);
            finalResponse.setRemark("store getMessage return null");
            return finalResponse;
        }
        this.brokerController.getColdDataCgCtrService().coldAcc(requestHeader.getConsumerGroup(), result.getColdDataSum());
        return this.pullMessageResultHandler.handle(result, request, requestHeader, channel, finalSubscriptionData, subscriptionGroupConfig, brokerAllowSuspend, messageFilter, finalResponse, mappingContext);
    }
}

