/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.statistics;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.statistics.Interceptor;
import org.apache.rocketmq.common.statistics.StatisticsBrief;
import org.apache.rocketmq.common.statistics.StatisticsItem;

public class StatisticsBriefInterceptor
implements Interceptor {
    private int[] indexOfItems;
    private StatisticsBrief[] statisticsBriefs;

    public StatisticsBriefInterceptor(StatisticsItem item, Pair<String, long[][]>[] briefMetas) {
        this.indexOfItems = new int[briefMetas.length];
        this.statisticsBriefs = new StatisticsBrief[briefMetas.length];
        for (int i = 0; i < briefMetas.length; ++i) {
            String name = (String)briefMetas[i].getKey();
            int index = ArrayUtils.indexOf((Object[])item.getItemNames(), (Object)name);
            if (index < 0) {
                throw new IllegalArgumentException("illegal breifItemName: " + name);
            }
            this.indexOfItems[i] = index;
            this.statisticsBriefs[i] = new StatisticsBrief((long[][])briefMetas[i].getValue());
        }
    }

    @Override
    public void inc(long ... itemValues) {
        for (int i = 0; i < this.indexOfItems.length; ++i) {
            int indexOfItem = this.indexOfItems[i];
            if (indexOfItem >= itemValues.length) continue;
            this.statisticsBriefs[i].sample(itemValues[indexOfItem]);
        }
    }

    @Override
    public void reset() {
        for (StatisticsBrief brief : this.statisticsBriefs) {
            brief.reset();
        }
    }

    public int[] getIndexOfItems() {
        return this.indexOfItems;
    }

    public void setIndexOfItems(int[] indexOfItems) {
        this.indexOfItems = indexOfItems;
    }

    public StatisticsBrief[] getStatisticsBriefs() {
        return this.statisticsBriefs;
    }

    public void setStatisticsBriefs(StatisticsBrief[] statisticsBriefs) {
        this.statisticsBriefs = statisticsBriefs;
    }
}

