/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.metadata;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.config.RocksDBConfigManager;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class RocksDBConfigToJsonCommand
implements SubCommand {
    private static final String TOPICS_JSON_CONFIG = "topics";
    private static final String SUBSCRIPTION_GROUP_JSON_CONFIG = "subscriptionGroups";

    @Override
    public String commandName() {
        return "rocksDBConfigToJson";
    }

    @Override
    public String commandDesc() {
        return "Convert RocksDB kv config (topics/subscriptionGroups) to json";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option pathOption = new Option("p", "path", true, "Absolute path to the metadata directory");
        pathOption.setRequired(true);
        options.addOption(pathOption);
        Option configTypeOption = new Option("t", "configType", true, "Name of kv config, e.g. topics/subscriptionGroups");
        configTypeOption.setRequired(true);
        options.addOption(configTypeOption);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        String path = commandLine.getOptionValue("path").trim();
        if (StringUtils.isEmpty((CharSequence)path) || !new File(path).exists()) {
            System.out.print("Rocksdb path is invalid.\n");
            return;
        }
        String configType = commandLine.getOptionValue("configType").trim().toLowerCase();
        long memTableFlushInterval = 3600000L;
        RocksDBConfigManager kvConfigManager = new RocksDBConfigManager(3600000L);
        try {
            boolean isLoad;
            if (TOPICS_JSON_CONFIG.toLowerCase().equals(configType)) {
                HashMap<String, JSONObject> topicsJsonConfig = new HashMap<String, JSONObject>();
                HashMap topicConfigTable = new HashMap();
                isLoad = kvConfigManager.load(path, (key, value) -> {
                    String topic = new String((byte[])key, DataConverter.CHARSET_UTF8);
                    String topicConfig = new String((byte[])value, DataConverter.CHARSET_UTF8);
                    JSONObject jsonObject = JSONObject.parseObject((String)topicConfig);
                    topicConfigTable.put(topic, jsonObject);
                });
                if (isLoad) {
                    topicsJsonConfig.put("topicConfigTable", (JSONObject)JSONObject.toJSON(topicConfigTable));
                    String topicsJsonStr = JSONObject.toJSONString(topicsJsonConfig, (boolean)true);
                    System.out.print(topicsJsonStr + "\n");
                    return;
                }
            }
            if (SUBSCRIPTION_GROUP_JSON_CONFIG.toLowerCase().equals(configType)) {
                HashMap<String, JSONObject> subscriptionGroupJsonConfig = new HashMap<String, JSONObject>();
                HashMap subscriptionGroupTable = new HashMap();
                isLoad = kvConfigManager.load(path, (key, value) -> {
                    String subscriptionGroup = new String((byte[])key, DataConverter.CHARSET_UTF8);
                    String subscriptionGroupConfig = new String((byte[])value, DataConverter.CHARSET_UTF8);
                    JSONObject jsonObject = JSONObject.parseObject((String)subscriptionGroupConfig);
                    subscriptionGroupTable.put(subscriptionGroup, jsonObject);
                });
                if (isLoad) {
                    subscriptionGroupJsonConfig.put("subscriptionGroupTable", (JSONObject)JSONObject.toJSON(subscriptionGroupTable));
                    String subscriptionGroupJsonStr = JSONObject.toJSONString(subscriptionGroupJsonConfig, (boolean)true);
                    System.out.print(subscriptionGroupJsonStr + "\n");
                    return;
                }
            }
            System.out.print("Config type was not recognized, configType=" + configType + "\n");
        }
        finally {
            kvConfigManager.stop();
        }
    }
}

