/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.JraftConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.srvutil.ShutdownHookThread;

public class NamesrvStartup {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    private static final Logger logConsole = LoggerFactory.getLogger((String)"RocketmqNamesrvConsole");
    private static Properties properties = null;
    private static NamesrvConfig namesrvConfig = null;
    private static NettyServerConfig nettyServerConfig = null;
    private static NettyClientConfig nettyClientConfig = null;
    private static ControllerConfig controllerConfig = null;

    public static void main(String[] args) {
        NamesrvStartup.main0(args);
        NamesrvStartup.controllerManagerMain();
    }

    public static NamesrvController main0(String[] args) {
        try {
            NamesrvStartup.parseCommandlineAndConfigFile(args);
            NamesrvController controller = NamesrvStartup.createAndStartNamesrvController();
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static ControllerManager controllerManagerMain() {
        try {
            if (namesrvConfig.isEnableControllerInNamesrv()) {
                return NamesrvStartup.createAndStartControllerManager();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return null;
    }

    public static void parseCommandlineAndConfigFile(String[] args) throws Exception {
        String file;
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"mqnamesrv", (String[])args, (Options)NamesrvStartup.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            System.exit(-1);
            return;
        }
        namesrvConfig = new NamesrvConfig();
        nettyServerConfig = new NettyServerConfig();
        nettyClientConfig = new NettyClientConfig();
        nettyServerConfig.setListenPort(9876);
        if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
            BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]));
            properties = new Properties();
            properties.load(in);
            MixAll.properties2Object((Properties)properties, (Object)namesrvConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyClientConfig);
            if (namesrvConfig.isEnableControllerInNamesrv()) {
                controllerConfig = new ControllerConfig();
                JraftConfig jraftConfig = new JraftConfig();
                controllerConfig.setJraftConfig(jraftConfig);
                MixAll.properties2Object((Properties)properties, (Object)controllerConfig);
                MixAll.properties2Object((Properties)properties, (Object)jraftConfig);
            }
            namesrvConfig.setConfigStorePath(file);
            System.out.printf("load config properties file OK, %s%n", file);
            ((InputStream)in).close();
        }
        MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)namesrvConfig);
        if (commandLine.hasOption('p')) {
            MixAll.printObjectProperties((Logger)logConsole, (Object)namesrvConfig);
            MixAll.printObjectProperties((Logger)logConsole, (Object)nettyServerConfig);
            MixAll.printObjectProperties((Logger)logConsole, (Object)nettyClientConfig);
            if (namesrvConfig.isEnableControllerInNamesrv()) {
                MixAll.printObjectProperties((Logger)logConsole, (Object)controllerConfig);
            }
            System.exit(0);
        }
        if (null == namesrvConfig.getRocketmqHome()) {
            System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation%n", "ROCKETMQ_HOME");
            System.exit(-2);
        }
        MixAll.printObjectProperties((Logger)log, (Object)namesrvConfig);
        MixAll.printObjectProperties((Logger)log, (Object)nettyServerConfig);
    }

    public static NamesrvController createAndStartNamesrvController() throws Exception {
        NamesrvController controller = NamesrvStartup.createNamesrvController();
        NamesrvStartup.start(controller);
        NettyServerConfig serverConfig = controller.getNettyServerConfig();
        String tip = String.format("The Name Server boot success. serializeType=%s, address %s:%d", RemotingCommand.getSerializeTypeConfigInThisServer(), serverConfig.getBindAddress(), serverConfig.getListenPort());
        log.info(tip);
        System.out.printf("%s%n", tip);
        return controller;
    }

    public static NamesrvController createNamesrvController() {
        NamesrvController controller = new NamesrvController(namesrvConfig, nettyServerConfig, nettyClientConfig);
        controller.getConfiguration().registerConfig(properties);
        return controller;
    }

    public static NamesrvController start(NamesrvController controller) throws Exception {
        if (null == controller) {
            throw new IllegalArgumentException("NamesrvController is null");
        }
        boolean initResult = controller.initialize();
        if (!initResult) {
            controller.shutdown();
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, () -> {
            controller.shutdown();
            return null;
        }));
        controller.start();
        return controller;
    }

    public static ControllerManager createAndStartControllerManager() throws Exception {
        ControllerManager controllerManager = NamesrvStartup.createControllerManager();
        NamesrvStartup.start(controllerManager);
        String tip = "The ControllerManager boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
        log.info(tip);
        System.out.printf("%s%n", tip);
        return controllerManager;
    }

    public static ControllerManager createControllerManager() throws Exception {
        NettyServerConfig controllerNettyServerConfig = (NettyServerConfig)nettyServerConfig.clone();
        ControllerManager controllerManager = new ControllerManager(controllerConfig, controllerNettyServerConfig, nettyClientConfig);
        controllerManager.getConfiguration().registerConfig(properties);
        return controllerManager;
    }

    public static ControllerManager start(ControllerManager controllerManager) throws Exception {
        if (null == controllerManager) {
            throw new IllegalArgumentException("ControllerManager is null");
        }
        boolean initResult = controllerManager.initialize();
        if (!initResult) {
            controllerManager.shutdown();
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, () -> {
            controllerManager.shutdown();
            return null;
        }));
        controllerManager.start();
        return controllerManager;
    }

    public static void shutdown(NamesrvController controller) {
        controller.shutdown();
    }

    public static void shutdown(ControllerManager controllerManager) {
        controllerManager.shutdown();
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Name server config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config items");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static Properties getProperties() {
        return properties;
    }
}

