/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.core;

import io.opentelemetry.api.common.Attributes;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.MessageStoreExecutor;
import org.apache.rocketmq.tieredstore.TieredMessageStore;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.core.MessageStoreDispatcher;
import org.apache.rocketmq.tieredstore.core.MessageStoreFilter;
import org.apache.rocketmq.tieredstore.file.FlatFileInterface;
import org.apache.rocketmq.tieredstore.file.FlatFileStore;
import org.apache.rocketmq.tieredstore.index.IndexService;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.util.MessageFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreDispatcherImpl
extends ServiceThread
implements MessageStoreDispatcher {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected final String brokerName;
    protected final MessageStore defaultStore;
    protected final MessageStoreConfig storeConfig;
    protected final TieredMessageStore messageStore;
    protected final FlatFileStore flatFileStore;
    protected final MessageStoreExecutor storeExecutor;
    protected final MessageStoreFilter topicFilter;
    protected final Semaphore semaphore;
    protected final IndexService indexService;

    public MessageStoreDispatcherImpl(TieredMessageStore messageStore) {
        this.messageStore = messageStore;
        this.storeConfig = messageStore.getStoreConfig();
        this.defaultStore = messageStore.getDefaultStore();
        this.brokerName = this.storeConfig.getBrokerName();
        this.semaphore = new Semaphore(this.storeConfig.getTieredStoreMaxPendingLimit() / 4);
        this.topicFilter = messageStore.getTopicFilter();
        this.flatFileStore = messageStore.getFlatFileStore();
        this.storeExecutor = messageStore.getStoreExecutor();
        this.indexService = messageStore.getIndexService();
    }

    public String getServiceName() {
        return MessageStoreDispatcher.class.getSimpleName();
    }

    public void dispatchWithSemaphore(FlatFileInterface flatFile) {
        try {
            if (this.stopped) {
                return;
            }
            this.semaphore.acquire();
            this.doScheduleDispatch(flatFile, false).whenComplete((future, throwable) -> this.semaphore.release());
        }
        catch (InterruptedException e) {
            this.semaphore.release();
        }
    }

    public void dispatch(DispatchRequest request) {
        if (this.stopped || this.topicFilter != null && this.topicFilter.filterTopic(request.getTopic())) {
            return;
        }
        this.flatFileStore.computeIfAbsent(new MessageQueue(request.getTopic(), this.brokerName, request.getQueueId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> doScheduleDispatch(FlatFileInterface flatFile, boolean force) {
        if (this.stopped) {
            return CompletableFuture.completedFuture(true);
        }
        String topic = flatFile.getMessageQueue().getTopic();
        int queueId = flatFile.getMessageQueue().getQueueId();
        boolean bl = force = !this.storeConfig.isTieredStoreGroupCommit() || force;
        if (force) {
            flatFile.getFileLock().lock();
        } else if (!flatFile.getFileLock().tryLock()) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            boolean repeat;
            long offset;
            boolean bufferFull;
            if (this.topicFilter != null && this.topicFilter.filterTopic(flatFile.getMessageQueue().getTopic())) {
                this.flatFileStore.destroyFile(flatFile.getMessageQueue());
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                return completableFuture;
            }
            long currentOffset = flatFile.getConsumeQueueMaxOffset();
            long commitOffset = flatFile.getConsumeQueueCommitOffset();
            long minOffsetInQueue = this.defaultStore.getMinOffsetInQueue(topic, queueId);
            long maxOffsetInQueue = this.defaultStore.getMaxOffsetInQueue(topic, queueId);
            if (!flatFile.isFlatFileInit()) {
                currentOffset = Math.max(minOffsetInQueue, maxOffsetInQueue - (long)this.storeConfig.getTieredStoreGroupCommitSize());
                flatFile.initOffset(currentOffset);
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
                return completableFuture;
            }
            if (commitOffset < currentOffset) {
                this.commitAsync(flatFile);
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                return completableFuture;
            }
            if (currentOffset < minOffsetInQueue) {
                log.warn("MessageDispatcher#dispatch, current offset is too small, topic={}, queueId={}, offset={}-{}, current={}", new Object[]{topic, queueId, minOffsetInQueue, maxOffsetInQueue, currentOffset});
                this.flatFileStore.destroyFile(flatFile.getMessageQueue());
                this.flatFileStore.computeIfAbsent(new MessageQueue(topic, this.brokerName, queueId));
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(true);
                return completableFuture;
            }
            if (currentOffset > maxOffsetInQueue) {
                log.warn("MessageDispatcher#dispatch, current offset is too large, topic: {}, queueId: {}, offset={}-{}, current={}", new Object[]{topic, queueId, minOffsetInQueue, maxOffsetInQueue, currentOffset});
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                return completableFuture;
            }
            long interval = TimeUnit.HOURS.toMillis(this.storeConfig.getCommitLogRollingInterval());
            if (flatFile.rollingFile(interval)) {
                log.info("MessageDispatcher#dispatch, rolling file, topic: {}, queueId: {}, offset={}-{}, current={}", new Object[]{topic, queueId, minOffsetInQueue, maxOffsetInQueue, currentOffset});
            }
            if (currentOffset == maxOffsetInQueue) {
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                return completableFuture;
            }
            long bufferSize = 0L;
            long groupCommitSize = this.storeConfig.getTieredStoreGroupCommitSize();
            long groupCommitCount = this.storeConfig.getTieredStoreGroupCommitCount();
            long targetOffset = Math.min(currentOffset + groupCommitCount, maxOffsetInQueue);
            ConsumeQueueInterface consumeQueue = this.defaultStore.getConsumeQueue(topic, queueId);
            CqUnit cqUnit = consumeQueue.get(currentOffset);
            SelectMappedBufferResult message = this.defaultStore.selectOneMessageByOffset(cqUnit.getPos(), cqUnit.getSize());
            boolean timeout = MessageFormatUtil.getStoreTimeStamp(message.getByteBuffer()) + (long)this.storeConfig.getTieredStoreGroupCommitTimeout() < System.currentTimeMillis();
            boolean bl2 = bufferFull = maxOffsetInQueue - currentOffset > (long)this.storeConfig.getTieredStoreGroupCommitCount();
            if (!(timeout || bufferFull || force)) {
                log.debug("MessageDispatcher#dispatch hold, topic={}, queueId={}, offset={}-{}, current={}, remain={}", new Object[]{topic, queueId, minOffsetInQueue, maxOffsetInQueue, currentOffset, maxOffsetInQueue - currentOffset});
                CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                return completableFuture;
            }
            if (MessageFormatUtil.getStoreTimeStamp(message.getByteBuffer()) + TimeUnit.MINUTES.toMillis(5L) < System.currentTimeMillis()) {
                log.warn("MessageDispatcher#dispatch behind too much, topic={}, queueId={}, offset={}-{}, current={}, remain={}", new Object[]{topic, queueId, minOffsetInQueue, maxOffsetInQueue, currentOffset, maxOffsetInQueue - currentOffset});
            } else {
                log.info("MessageDispatcher#dispatch, topic={}, queueId={}, offset={}-{}, current={}, remain={}", new Object[]{topic, queueId, minOffsetInQueue, maxOffsetInQueue, currentOffset, maxOffsetInQueue - currentOffset});
            }
            message.release();
            for (offset = currentOffset; offset < targetOffset && (bufferSize += (long)(cqUnit = consumeQueue.get(offset)).getSize()) < groupCommitSize; ++offset) {
                message = this.defaultStore.selectOneMessageByOffset(cqUnit.getPos(), cqUnit.getSize());
                ByteBuffer byteBuffer = message.getByteBuffer();
                AppendResult result = flatFile.appendCommitLog(message);
                if (!AppendResult.SUCCESS.equals((Object)result)) break;
                long mappedCommitLogOffset = flatFile.getCommitLogMaxOffset() - (long)byteBuffer.remaining();
                Map<String, String> properties = MessageFormatUtil.getProperties(byteBuffer);
                DispatchRequest dispatchRequest = new DispatchRequest(topic, queueId, mappedCommitLogOffset, cqUnit.getSize(), cqUnit.getTagsCode(), MessageFormatUtil.getStoreTimeStamp(byteBuffer), cqUnit.getQueueOffset(), properties.getOrDefault("KEYS", ""), properties.getOrDefault("UNIQ_KEY", ""), 0, 0L, new HashMap());
                dispatchRequest.setOffsetId(MessageFormatUtil.getOffsetId(byteBuffer));
                result = flatFile.appendConsumeQueue(dispatchRequest);
                if (!AppendResult.SUCCESS.equals((Object)result)) break;
            }
            boolean bl3 = repeat = timeout || maxOffsetInQueue - offset > (long)this.storeConfig.getTieredStoreGroupCommitCount();
            if (!flatFile.getDispatchRequestList().isEmpty()) {
                Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", topic).put("queue_id", (long)queueId).put("file_type", FileSegmentType.COMMIT_LOG.name().toLowerCase()).build();
                TieredStoreMetricsManager.messagesDispatchTotal.add(offset - currentOffset, attributes);
                this.commitAsync(flatFile).whenComplete((unused, throwable) -> {
                    if (repeat) {
                        this.storeExecutor.commonExecutor.submit(() -> this.dispatchWithSemaphore(flatFile));
                    }
                });
            }
        }
        finally {
            flatFile.getFileLock().unlock();
        }
        return CompletableFuture.completedFuture(false);
    }

    public CompletableFuture<Void> commitAsync(FlatFileInterface flatFile) {
        return flatFile.commitAsync().thenAcceptAsync(success -> {
            if (success.booleanValue()) {
                if (this.storeConfig.isMessageIndexEnable()) {
                    flatFile.getDispatchRequestList().forEach(request -> this.constructIndexFile(flatFile.getTopicId(), (DispatchRequest)request));
                }
                flatFile.release();
            }
        }, (Executor)MessageStoreExecutor.getInstance().bufferCommitExecutor);
    }

    public void constructIndexFile(long topicId, DispatchRequest request) {
        HashSet<String> keySet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)request.getUniqKey())) {
            keySet.add(request.getUniqKey());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getKeys())) {
            keySet.addAll(Arrays.asList(request.getKeys().split(" ")));
        }
        this.indexService.putKey(request.getTopic(), (int)topicId, request.getQueueId(), keySet, request.getCommitLogOffset(), request.getMsgSize(), request.getStoreTimestamp());
    }

    public void run() {
        log.info("{} service started", (Object)this.getServiceName());
        while (!this.isStopped()) {
            this.flatFileStore.deepCopyFlatFileToList().forEach(this::dispatchWithSemaphore);
            this.waitForRunning(Duration.ofSeconds(20L).toMillis());
        }
        log.info("{} service shutdown", (Object)this.getServiceName());
    }
}

