/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.file.FlatAppendFile;
import org.apache.rocketmq.tieredstore.file.FlatCommitLogFile;
import org.apache.rocketmq.tieredstore.file.FlatConsumeQueueFile;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.apache.rocketmq.tieredstore.provider.FileSegmentFactory;

public class FlatFileFactory {
    private final MetadataStore metadataStore;
    private final MessageStoreConfig storeConfig;
    private final FileSegmentFactory fileSegmentFactory;

    public FlatFileFactory(MetadataStore metadataStore, MessageStoreConfig storeConfig) {
        this.metadataStore = metadataStore;
        this.storeConfig = storeConfig;
        this.fileSegmentFactory = new FileSegmentFactory(metadataStore, storeConfig);
    }

    public MessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public FlatCommitLogFile createFlatFileForCommitLog(String filePath) {
        return new FlatCommitLogFile(this.fileSegmentFactory, filePath);
    }

    public FlatConsumeQueueFile createFlatFileForConsumeQueue(String filePath) {
        return new FlatConsumeQueueFile(this.fileSegmentFactory, filePath);
    }

    public FlatAppendFile createFlatFileForIndexFile(String filePath) {
        return new FlatAppendFile(this.fileSegmentFactory, FileSegmentType.INDEX, filePath);
    }
}

