/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.Stopwatch;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.FastCodesHeader;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommandType;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.RocketMQSerializable;
import org.apache.rocketmq.remoting.protocol.SerializeType;

public class RemotingCommand {
    public static final String SERIALIZE_TYPE_PROPERTY = "rocketmq.serialize.type";
    public static final String SERIALIZE_TYPE_ENV = "ROCKETMQ_SERIALIZE_TYPE";
    public static final String REMOTING_VERSION_KEY = "rocketmq.remoting.version";
    static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;
    private static final Map<Class<? extends CommandCustomHeader>, Field[]> CLASS_HASH_MAP = new HashMap<Class<? extends CommandCustomHeader>, Field[]>();
    private static final Map<Class, String> CANONICAL_NAME_CACHE = new HashMap<Class, String>();
    private static final Map<Field, Boolean> NULLABLE_FIELD_CACHE = new HashMap<Field, Boolean>();
    private static final String STRING_CANONICAL_NAME = String.class.getCanonicalName();
    private static final String DOUBLE_CANONICAL_NAME_1 = Double.class.getCanonicalName();
    private static final String DOUBLE_CANONICAL_NAME_2 = Double.TYPE.getCanonicalName();
    private static final String INTEGER_CANONICAL_NAME_1 = Integer.class.getCanonicalName();
    private static final String INTEGER_CANONICAL_NAME_2 = Integer.TYPE.getCanonicalName();
    private static final String LONG_CANONICAL_NAME_1 = Long.class.getCanonicalName();
    private static final String LONG_CANONICAL_NAME_2 = Long.TYPE.getCanonicalName();
    private static final String BOOLEAN_CANONICAL_NAME_1 = Boolean.class.getCanonicalName();
    private static final String BOOLEAN_CANONICAL_NAME_2 = Boolean.TYPE.getCanonicalName();
    private static final String BOUNDARY_TYPE_CANONICAL_NAME = BoundaryType.class.getCanonicalName();
    private static volatile int configVersion = -1;
    private static AtomicInteger requestId = new AtomicInteger(0);
    private static SerializeType serializeTypeConfigInThisServer = SerializeType.JSON;
    private int code;
    private LanguageCode language = LanguageCode.JAVA;
    private int version = 0;
    private int opaque = requestId.getAndIncrement();
    private int flag = 0;
    private String remark;
    private HashMap<String, String> extFields;
    private transient CommandCustomHeader customHeader;
    private transient CommandCustomHeader cachedHeader;
    private SerializeType serializeTypeCurrentRPC = serializeTypeConfigInThisServer;
    private transient byte[] body;
    private boolean suspended;
    private transient Stopwatch processTimer;

    protected RemotingCommand() {
    }

    public static RemotingCommand createRequestCommand(int code, CommandCustomHeader customHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        cmd.customHeader = customHeader;
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    public static RemotingCommand createResponseCommandWithHeader(int code, CommandCustomHeader customHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        cmd.markResponseType();
        cmd.customHeader = customHeader;
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    protected static void setCmdVersion(RemotingCommand cmd) {
        if (configVersion >= 0) {
            cmd.setVersion(configVersion);
        } else {
            String v = System.getProperty(REMOTING_VERSION_KEY);
            if (v != null) {
                int value = Integer.parseInt(v);
                cmd.setVersion(value);
                configVersion = value;
            }
        }
    }

    public static RemotingCommand createResponseCommand(Class<? extends CommandCustomHeader> classHeader) {
        return RemotingCommand.createResponseCommand(1, "not set any response code", classHeader);
    }

    public static RemotingCommand buildErrorResponse(int code, String remark, Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand response = RemotingCommand.createResponseCommand(classHeader);
        response.setCode(code);
        response.setRemark(remark);
        return response;
    }

    public static RemotingCommand buildErrorResponse(int code, String remark) {
        return RemotingCommand.buildErrorResponse(code, remark, null);
    }

    public static RemotingCommand createResponseCommand(int code, String remark, Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setRemark(remark);
        RemotingCommand.setCmdVersion(cmd);
        if (classHeader != null) {
            try {
                CommandCustomHeader objectHeader;
                cmd.customHeader = objectHeader = classHeader.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, String remark) {
        return RemotingCommand.createResponseCommand(code, remark, null);
    }

    public static RemotingCommand decode(byte[] array) throws RemotingCommandException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        return RemotingCommand.decode(byteBuffer);
    }

    public static RemotingCommand decode(ByteBuffer byteBuffer) throws RemotingCommandException {
        return RemotingCommand.decode(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
    }

    public static RemotingCommand decode(ByteBuf byteBuffer) throws RemotingCommandException {
        int length = byteBuffer.readableBytes();
        int oriHeaderLen = byteBuffer.readInt();
        int headerLength = RemotingCommand.getHeaderLength(oriHeaderLen);
        if (headerLength > length - 4) {
            throw new RemotingCommandException("decode error, bad header length: " + headerLength);
        }
        RemotingCommand cmd = RemotingCommand.headerDecode(byteBuffer, headerLength, RemotingCommand.getProtocolType(oriHeaderLen));
        int bodyLength = length - 4 - headerLength;
        byte[] bodyData = null;
        if (bodyLength > 0) {
            bodyData = new byte[bodyLength];
            byteBuffer.readBytes(bodyData);
        }
        cmd.body = bodyData;
        return cmd;
    }

    public static int getHeaderLength(int length) {
        return length & 0xFFFFFF;
    }

    private static RemotingCommand headerDecode(ByteBuf byteBuffer, int len, SerializeType type) throws RemotingCommandException {
        switch (type) {
            case JSON: {
                byte[] headerData = new byte[len];
                byteBuffer.readBytes(headerData);
                RemotingCommand resultJson = RemotingSerializable.decode(headerData, RemotingCommand.class);
                resultJson.setSerializeTypeCurrentRPC(type);
                return resultJson;
            }
            case ROCKETMQ: {
                RemotingCommand resultRMQ = RocketMQSerializable.rocketMQProtocolDecode(byteBuffer, len);
                resultRMQ.setSerializeTypeCurrentRPC(type);
                return resultRMQ;
            }
        }
        return null;
    }

    public static SerializeType getProtocolType(int source) {
        return SerializeType.valueOf((byte)(source >> 24 & 0xFF));
    }

    public static int createNewRequestId() {
        return requestId.getAndIncrement();
    }

    public static SerializeType getSerializeTypeConfigInThisServer() {
        return serializeTypeConfigInThisServer;
    }

    public static int markProtocolType(int source, SerializeType type) {
        return type.getCode() << 24 | source & 0xFFFFFF;
    }

    public void markResponseType() {
        int bits = 1;
        this.flag |= bits;
    }

    public CommandCustomHeader readCustomHeader() {
        return this.customHeader;
    }

    public void writeCustomHeader(CommandCustomHeader customHeader) {
        this.customHeader = customHeader;
    }

    public <T extends CommandCustomHeader> T decodeCommandCustomHeader(Class<T> classHeader) throws RemotingCommandException {
        return this.decodeCommandCustomHeader(classHeader, false);
    }

    public <T extends CommandCustomHeader> T decodeCommandCustomHeader(Class<T> classHeader, boolean isCached) throws RemotingCommandException {
        if (isCached && this.cachedHeader != null) {
            return (T)((CommandCustomHeader)classHeader.cast(this.cachedHeader));
        }
        this.cachedHeader = this.decodeCommandCustomHeaderDirectly(classHeader, true);
        if (this.cachedHeader == null) {
            return null;
        }
        return (T)((CommandCustomHeader)classHeader.cast(this.cachedHeader));
    }

    public <T extends CommandCustomHeader> T decodeCommandCustomHeaderDirectly(Class<T> classHeader, boolean useFastEncode) throws RemotingCommandException {
        CommandCustomHeader objectHeader;
        try {
            objectHeader = (CommandCustomHeader)classHeader.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        if (this.extFields != null) {
            Field[] fields;
            if (objectHeader instanceof FastCodesHeader && useFastEncode) {
                ((FastCodesHeader)((Object)objectHeader)).decode(this.extFields);
                objectHeader.checkFields();
                return (T)objectHeader;
            }
            for (Field field : fields = this.getClazzFields(classHeader)) {
                String fieldName;
                if (Modifier.isStatic(field.getModifiers()) || (fieldName = field.getName()).startsWith("this")) continue;
                try {
                    Object valueParsed;
                    String value = this.extFields.get(fieldName);
                    if (null == value) {
                        if (this.isFieldNullable(field)) continue;
                        throw new RemotingCommandException("the custom field <" + fieldName + "> is null");
                    }
                    field.setAccessible(true);
                    String type = this.getCanonicalName(field.getType());
                    if (type.equals(STRING_CANONICAL_NAME)) {
                        valueParsed = value;
                    } else if (type.equals(INTEGER_CANONICAL_NAME_1) || type.equals(INTEGER_CANONICAL_NAME_2)) {
                        valueParsed = Integer.parseInt(value);
                    } else if (type.equals(LONG_CANONICAL_NAME_1) || type.equals(LONG_CANONICAL_NAME_2)) {
                        valueParsed = Long.parseLong(value);
                    } else if (type.equals(BOOLEAN_CANONICAL_NAME_1) || type.equals(BOOLEAN_CANONICAL_NAME_2)) {
                        valueParsed = Boolean.parseBoolean(value);
                    } else if (type.equals(DOUBLE_CANONICAL_NAME_1) || type.equals(DOUBLE_CANONICAL_NAME_2)) {
                        valueParsed = Double.parseDouble(value);
                    } else if (type.equals(BOUNDARY_TYPE_CANONICAL_NAME)) {
                        valueParsed = BoundaryType.getType((String)value);
                    } else {
                        throw new RemotingCommandException("the custom field <" + fieldName + "> type is not supported");
                    }
                    field.set(objectHeader, valueParsed);
                }
                catch (Throwable e) {
                    log.error("Failed field [{}] decoding", (Object)fieldName, (Object)e);
                }
            }
            objectHeader.checkFields();
        }
        return (T)objectHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Field[] getClazzFields(Class<? extends CommandCustomHeader> classHeader) {
        Field[] field = CLASS_HASH_MAP.get(classHeader);
        if (field == null) {
            HashSet<Field> fieldList = new HashSet<Field>();
            for (Class<? extends CommandCustomHeader> className = classHeader; className != Object.class; className = className.getSuperclass()) {
                Field[] fields = className.getDeclaredFields();
                fieldList.addAll(Arrays.asList(fields));
            }
            field = fieldList.toArray(new Field[0]);
            Map<Class<? extends CommandCustomHeader>, Field[]> map = CLASS_HASH_MAP;
            synchronized (map) {
                CLASS_HASH_MAP.put(classHeader, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFieldNullable(Field field) {
        if (!NULLABLE_FIELD_CACHE.containsKey(field)) {
            CFNotNull annotation = field.getAnnotation(CFNotNull.class);
            Map<Field, Boolean> map = NULLABLE_FIELD_CACHE;
            synchronized (map) {
                NULLABLE_FIELD_CACHE.put(field, annotation == null);
            }
        }
        return NULLABLE_FIELD_CACHE.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCanonicalName(Class clazz) {
        String name = CANONICAL_NAME_CACHE.get(clazz);
        if (name == null) {
            name = clazz.getCanonicalName();
            Map<Class, String> map = CANONICAL_NAME_CACHE;
            synchronized (map) {
                CANONICAL_NAME_CACHE.put(clazz, name);
            }
        }
        return name;
    }

    public ByteBuffer encode() {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        if (this.body != null) {
            length += this.body.length;
        }
        ByteBuffer result = ByteBuffer.allocate(4 + length);
        result.putInt(length);
        result.putInt(RemotingCommand.markProtocolType(headerData.length, this.serializeTypeCurrentRPC));
        result.put(headerData);
        if (this.body != null) {
            result.put(this.body);
        }
        result.flip();
        return result;
    }

    private byte[] headerEncode() {
        this.makeCustomHeaderToNet();
        if (SerializeType.ROCKETMQ == this.serializeTypeCurrentRPC) {
            return RocketMQSerializable.rocketMQProtocolEncode(this);
        }
        return RemotingSerializable.encode(this);
    }

    public void makeCustomHeaderToNet() {
        if (this.customHeader != null) {
            Field[] fields = this.getClazzFields(this.customHeader.getClass());
            if (null == this.extFields) {
                this.extFields = new HashMap();
            }
            for (Field field : fields) {
                String name;
                if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
                Object value = null;
                try {
                    field.setAccessible(true);
                    value = field.get(this.customHeader);
                }
                catch (Exception e) {
                    log.error("Failed to access field [{}]", (Object)name, (Object)e);
                }
                if (value == null) continue;
                this.extFields.put(name, value.toString());
            }
        }
    }

    public void fastEncodeHeader(ByteBuf out) {
        int headerSize;
        int bodySize = this.body != null ? this.body.length : 0;
        int beginIndex = out.writerIndex();
        out.writeLong(0L);
        if (SerializeType.ROCKETMQ == this.serializeTypeCurrentRPC) {
            if (this.customHeader != null && !(this.customHeader instanceof FastCodesHeader)) {
                this.makeCustomHeaderToNet();
            }
            headerSize = RocketMQSerializable.rocketMQProtocolEncode(this, out);
        } else {
            this.makeCustomHeaderToNet();
            byte[] header = RemotingSerializable.encode(this);
            headerSize = header.length;
            out.writeBytes(header);
        }
        out.setInt(beginIndex, 4 + headerSize + bodySize);
        out.setInt(beginIndex + 4, RemotingCommand.markProtocolType(headerSize, this.serializeTypeCurrentRPC));
    }

    public ByteBuffer encodeHeader() {
        return this.encodeHeader(this.body != null ? this.body.length : 0);
    }

    public ByteBuffer encodeHeader(int bodyLength) {
        int length = 4;
        byte[] headerData = this.headerEncode();
        length += headerData.length;
        ByteBuffer result = ByteBuffer.allocate(4 + (length += bodyLength) - bodyLength);
        result.putInt(length);
        result.putInt(RemotingCommand.markProtocolType(headerData.length, this.serializeTypeCurrentRPC));
        result.put(headerData);
        ((Buffer)result).flip();
        return result;
    }

    public void markOnewayRPC() {
        int bits = 2;
        this.flag |= bits;
    }

    @JSONField(serialize=false)
    public boolean isOnewayRPC() {
        int bits = 2;
        return (this.flag & bits) == bits;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @JSONField(serialize=false)
    public RemotingCommandType getType() {
        if (this.isResponseType()) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }

    @JSONField(serialize=false)
    public boolean isResponseType() {
        int bits = 1;
        return (this.flag & bits) == bits;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    @JSONField(serialize=false)
    public boolean isSuspended() {
        return this.suspended;
    }

    @JSONField(serialize=false)
    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public void addExtField(String key, String value) {
        if (null == this.extFields) {
            this.extFields = new HashMap(256);
        }
        this.extFields.put(key, value);
    }

    public void addExtFieldIfNotExist(String key, String value) {
        this.extFields.putIfAbsent(key, value);
    }

    public String toString() {
        return "RemotingCommand [code=" + this.code + ", language=" + (Object)((Object)this.language) + ", version=" + this.version + ", opaque=" + this.opaque + ", flag(B)=" + Integer.toBinaryString(this.flag) + ", remark=" + this.remark + ", extFields=" + this.extFields + ", serializeTypeCurrentRPC=" + (Object)((Object)this.serializeTypeCurrentRPC) + "]";
    }

    public SerializeType getSerializeTypeCurrentRPC() {
        return this.serializeTypeCurrentRPC;
    }

    public void setSerializeTypeCurrentRPC(SerializeType serializeTypeCurrentRPC) {
        this.serializeTypeCurrentRPC = serializeTypeCurrentRPC;
    }

    public Stopwatch getProcessTimer() {
        return this.processTimer;
    }

    public void setProcessTimer(Stopwatch processTimer) {
        this.processTimer = processTimer;
    }

    static {
        String protocol = System.getProperty(SERIALIZE_TYPE_PROPERTY, System.getenv(SERIALIZE_TYPE_ENV));
        if (!StringUtils.isBlank((CharSequence)protocol)) {
            try {
                serializeTypeConfigInThisServer = SerializeType.valueOf(protocol);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("parser specified protocol error. protocol=" + protocol, e);
            }
        }
    }
}

