/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.common.utils.FutureUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.processor.AbstractProcessor;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.QueueSelector;
import org.apache.rocketmq.proxy.processor.validator.DefaultTopicMessageTypeValidator;
import org.apache.rocketmq.proxy.processor.validator.TopicMessageTypeValidator;
import org.apache.rocketmq.proxy.service.ServiceManager;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.ConsumerSendMsgBackRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;

public class ProducerProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final ExecutorService executor;
    private final TopicMessageTypeValidator topicMessageTypeValidator;

    public ProducerProcessor(MessagingProcessor messagingProcessor, ServiceManager serviceManager, ExecutorService executor) {
        super(messagingProcessor, serviceManager);
        this.executor = executor;
        this.topicMessageTypeValidator = new DefaultTopicMessageTypeValidator();
    }

    public CompletableFuture<List<SendResult>> sendMessage(ProxyContext ctx, QueueSelector queueSelector, String producerGroup, int sysFlag, List<Message> messageList, long timeoutMillis) {
        CompletionStage future = new CompletableFuture();
        long beginTimestampFirst = System.currentTimeMillis();
        AddressableMessageQueue messageQueue = null;
        try {
            Message message = messageList.get(0);
            String topic = message.getTopic();
            if (ConfigurationManager.getProxyConfig().isEnableTopicMessageTypeCheck() && this.topicMessageTypeValidator != null && !NamespaceUtil.isRetryTopic((String)topic) && !NamespaceUtil.isDLQTopic((String)topic)) {
                TopicMessageType topicMessageType = this.serviceManager.getMetadataService().getTopicMessageType(ctx, topic);
                TopicMessageType messageType = TopicMessageType.parseFromMessageProperty((Map)message.getProperties());
                this.topicMessageTypeValidator.validate(topicMessageType, messageType);
            }
            if ((messageQueue = queueSelector.select(ctx, this.serviceManager.getTopicRouteService().getCurrentMessageQueueView(ctx, topic))) == null) {
                throw new ProxyException(ProxyExceptionCode.FORBIDDEN, "no writable queue");
            }
            for (Message msg : messageList) {
                MessageClientIDSetter.setUniqID((Message)msg);
            }
            SendMessageRequestHeader requestHeader = this.buildSendMessageRequestHeader(messageList, producerGroup, sysFlag, messageQueue.getQueueId());
            AddressableMessageQueue finalMessageQueue = messageQueue;
            future = ((CompletableFuture)this.serviceManager.getMessageService().sendMessage(ctx, messageQueue, messageList, requestHeader, timeoutMillis).thenApplyAsync(sendResultList -> {
                for (SendResult sendResult : sendResultList) {
                    int tranType = MessageSysFlag.getTransactionValue((int)requestHeader.getSysFlag());
                    if (!SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus()) || tranType != 4 || !StringUtils.isNotBlank((CharSequence)sendResult.getTransactionId())) continue;
                    this.fillTransactionData(ctx, producerGroup, finalMessageQueue, sendResult, messageList);
                }
                return sendResultList;
            }, (Executor)this.executor)).whenComplete((result, exception) -> {
                long endTimestamp = System.currentTimeMillis();
                if (exception != null) {
                    this.serviceManager.getTopicRouteService().updateFaultItem(finalMessageQueue.getBrokerName(), endTimestamp - beginTimestampFirst, true, false);
                } else {
                    this.serviceManager.getTopicRouteService().updateFaultItem(finalMessageQueue.getBrokerName(), endTimestamp - beginTimestampFirst, false, true);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, (ExecutorService)this.executor);
    }

    protected void fillTransactionData(ProxyContext ctx, String producerGroup, AddressableMessageQueue messageQueue, SendResult sendResult, List<Message> messageList) {
        try {
            MessageId id = sendResult.getOffsetMsgId() != null ? MessageDecoder.decodeMessageId((String)sendResult.getOffsetMsgId()) : MessageDecoder.decodeMessageId((String)sendResult.getMsgId());
            this.serviceManager.getTransactionService().addTransactionDataByBrokerName(ctx, messageQueue.getBrokerName(), messageList.get(0).getTopic(), producerGroup, sendResult.getQueueOffset(), id.getOffset(), sendResult.getTransactionId(), messageList.get(0));
        }
        catch (Throwable t) {
            log.warn("fillTransactionData failed. messageQueue: {}, sendResult: {}", new Object[]{messageQueue, sendResult, t});
        }
    }

    protected SendMessageRequestHeader buildSendMessageRequestHeader(List<Message> messageList, String producerGroup, int sysFlag, int queueId) {
        SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
        Message message = messageList.get(0);
        requestHeader.setProducerGroup(producerGroup);
        requestHeader.setTopic(message.getTopic());
        requestHeader.setDefaultTopic("TBW102");
        requestHeader.setDefaultTopicQueueNums(Integer.valueOf(4));
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setSysFlag(Integer.valueOf(sysFlag));
        try {
            requestHeader.setBornTimestamp(Long.valueOf(Long.parseLong(message.getProperty("BORN_TIMESTAMP"))));
        }
        catch (Exception e) {
            log.warn("parse born time error, with value:{}", (Object)message.getProperty("BORN_TIMESTAMP"));
            requestHeader.setBornTimestamp(Long.valueOf(System.currentTimeMillis()));
        }
        requestHeader.setFlag(Integer.valueOf(message.getFlag()));
        requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)message.getProperties()));
        requestHeader.setReconsumeTimes(Integer.valueOf(0));
        if (messageList.size() > 1) {
            requestHeader.setBatch(Boolean.valueOf(true));
        }
        if (requestHeader.getTopic().startsWith("%RETRY%")) {
            String maxReconsumeTimes;
            String reconsumeTimes = MessageAccessor.getReconsumeTime((Message)message);
            if (reconsumeTimes != null) {
                requestHeader.setReconsumeTimes(Integer.valueOf(reconsumeTimes));
                MessageAccessor.clearProperty((Message)message, (String)"RECONSUME_TIME");
            }
            if ((maxReconsumeTimes = MessageAccessor.getMaxReconsumeTimes((Message)message)) != null) {
                requestHeader.setMaxReconsumeTimes(Integer.valueOf(maxReconsumeTimes));
                MessageAccessor.clearProperty((Message)message, (String)"MAX_RECONSUME_TIMES");
            }
        }
        return requestHeader;
    }

    public CompletableFuture<RemotingCommand> forwardMessageToDeadLetterQueue(ProxyContext ctx, ReceiptHandle handle, String messageId, String groupName, String topicName, long timeoutMillis) {
        CompletionStage future = new CompletableFuture();
        try {
            if (handle.getCommitLogOffset() < 0L) {
                throw new ProxyException(ProxyExceptionCode.INVALID_RECEIPT_HANDLE, "commit log offset is empty");
            }
            ConsumerSendMsgBackRequestHeader consumerSendMsgBackRequestHeader = new ConsumerSendMsgBackRequestHeader();
            consumerSendMsgBackRequestHeader.setOffset(Long.valueOf(handle.getCommitLogOffset()));
            consumerSendMsgBackRequestHeader.setGroup(groupName);
            consumerSendMsgBackRequestHeader.setDelayLevel(Integer.valueOf(-1));
            consumerSendMsgBackRequestHeader.setOriginMsgId(messageId);
            consumerSendMsgBackRequestHeader.setOriginTopic(handle.getRealTopic(topicName, groupName));
            consumerSendMsgBackRequestHeader.setMaxReconsumeTimes(Integer.valueOf(0));
            future = this.serviceManager.getMessageService().sendMessageBack(ctx, handle, messageId, consumerSendMsgBackRequestHeader, timeoutMillis).whenCompleteAsync((remotingCommand, t) -> {
                if (t == null && remotingCommand.getCode() == 0) {
                    this.messagingProcessor.ackMessage(ctx, handle, messageId, groupName, topicName, timeoutMillis);
                }
            }, (Executor)this.executor);
        }
        catch (Throwable t2) {
            future.completeExceptionally(t2);
        }
        return FutureUtils.addExecutor(future, (ExecutorService)this.executor);
    }
}

