/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

class ObjectReaderImplLocalDate
extends DateTimeCodec
implements ObjectReader {
    static final ObjectReaderImplLocalDate INSTANCE = new ObjectReaderImplLocalDate(null, null);

    public ObjectReaderImplLocalDate(String format, Locale locale) {
        super(format, locale);
    }

    public static ObjectReaderImplLocalDate of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplLocalDate(format, locale);
    }

    public Class getObjectClass() {
        return LocalDate.class;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return jsonReader.readLocalDate();
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (this.format == null || this.yyyyMMddhhmmss19 || this.formatISO8601 || jsonReader.isNumber()) {
            return jsonReader.readLocalDate();
        }
        String str = jsonReader.readString();
        if (str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (this.formatMillis || this.formatUnixTime) {
            long millis = Long.parseLong(str);
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, context.getZoneId()).toLocalDate();
        }
        DateTimeFormatter formatter = this.getDateFormatter(context.getLocale());
        if (!this.formatHasHour) {
            return LocalDate.parse(str, formatter);
        }
        if (!this.formatHasDay) {
            return LocalDate.of(1970, 1, 1);
        }
        return LocalDateTime.parse(str, formatter).toLocalDate();
    }
}

