/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.javascript.jscomp.Result;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.config.ExterncConfigurator;
import org.apache.royale.compiler.internal.codegen.typedefs.emit.ReferenceEmitter;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.ReferenceCompiler;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.targets.ITarget;

public class EXTERNC
implements FlexTool {
    public ProblemQuery problems;
    protected Configurator projectConfigurator;
    private ExternCConfiguration configuration;
    private ReferenceModel model;
    private ReferenceCompiler compiler;
    private ReferenceEmitter emitter;

    public ReferenceModel getModel() {
        return this.model;
    }

    public ReferenceCompiler getCompiler() {
        return this.compiler;
    }

    public ReferenceEmitter getEmitter() {
        return this.emitter;
    }

    public EXTERNC() {
    }

    public EXTERNC(ExternCConfiguration configuration) {
        this.configure(configuration);
    }

    public boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        this.projectConfigurator.setConfiguration(args, "typedefs", false);
        this.projectConfigurator.getTargetSettings(ITarget.TargetType.SWC);
        this.configure((ExternCConfiguration)this.projectConfigurator.getConfiguration());
        this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
        this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
        return !this.problems.hasErrors();
    }

    public void configure(ExternCConfiguration configuration) {
        this.configuration = configuration;
        this.model = new ReferenceModel(configuration);
        this.compiler = new ReferenceCompiler(this.model);
        this.emitter = new ReferenceEmitter(this.model);
    }

    protected Configurator createConfigurator() {
        return new ExterncConfigurator(ExternCConfiguration.class);
    }

    public static void main(String[] args) {
        int exitCode = EXTERNC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        EXTERNC compiler = new EXTERNC();
        int exitCode = compiler.mainNoExit(args, System.err);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainNoExit(String[] args, OutputStream stderr) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(args);
        }
        catch (Exception e) {
            PrintWriter writer = new PrintWriter(stderr);
            writer.println(e.toString());
        }
        finally {
            ProblemFormatter formatter = new ProblemFormatter();
            ProblemPrinter printer = new ProblemPrinter(formatter, stderr);
            printer.printProblems(this.problems.getFilteredProblems());
        }
        return exitCode;
    }

    public int _mainNoExit(String[] args) {
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            if (continueCompilation) {
                this.model.problems = this.problems;
                this.cleanOutput();
                this.compile();
                this.emit();
            } else {
                exitCode = this.problems.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
            }
        }
        catch (Exception e) {
            if (this.problems == null) {
                System.err.println(e.getMessage());
            } else {
                UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
            }
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
        }
        return exitCode.code;
    }

    public void cleanOutput() throws IOException {
        FileUtils.deleteDirectory((File)this.configuration.getAsRoot());
    }

    public void emit() throws IOException {
        this.emitter.emit();
    }

    public Result compile() throws IOException {
        return this.compiler.compile();
    }

    public String getName() {
        return "EXTERNC";
    }

    public int execute(String[] args) {
        EXTERNC generator = new EXTERNC();
        generator.configure(args);
        try {
            generator.cleanOutput();
            generator.compile();
            generator.emit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

