/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class VariablesOnTopRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IScopedNode scopedNode = functionNode.getScopedNode();
        if (scopedNode == null) {
            return;
        }
        boolean afterNonVariable = false;
        for (int i = 0; i < scopedNode.getChildCount(); ++i) {
            IASNode child = scopedNode.getChild(i);
            afterNonVariable = this.checkVariablesNotAtTop(child, afterNonVariable, problems);
        }
    }

    private boolean checkVariablesNotAtTop(IASNode node, boolean afterNonVariable, Collection<ICompilerProblem> problems) {
        if (node instanceof IVariableNode) {
            IVariableNode variableNode = (IVariableNode)node;
            if (afterNonVariable) {
                problems.add(new VariablesOnTopLinterProblem(variableNode));
            }
            return afterNonVariable;
        }
        afterNonVariable = true;
        for (int i = 0; i < node.getChildCount(); ++i) {
            IASNode child = node.getChild(i);
            afterNonVariable = this.checkVariablesNotAtTop(child, afterNonVariable, problems);
        }
        return afterNonVariable;
    }

    public static class VariablesOnTopLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Variable name '${varName}' must be declared at the top of this function";
        public String varName;

        public VariablesOnTopLinterProblem(IVariableNode node) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.varName = node.getName();
        }
    }
}

