/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6InjectRuntimeLibraries
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final boolean getterSetterSupported;
    private static final FeatureSet requiredForFeatures = FeatureSet.ES6.without(FeatureSet.ES5);

    public Es6InjectRuntimeLibraries(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.getterSetterSupported = !FeatureSet.ES3.contains(compiler.getOptions().getOutputFeatureSet());
    }

    @Override
    public void process(Node externs, Node root) {
        FeatureSet used = FeatureSet.ES3;
        for (Node script : root.children()) {
            used = used.with(Es6InjectRuntimeLibraries.getScriptFeatures(script));
        }
        FeatureSet mustBeCompiledAway = used.without(this.compiler.getOptions().getOutputFeatureSet());
        TranspilationPasses.processTranspile(this.compiler, root, requiredForFeatures, this);
        if (mustBeCompiledAway.contains(FeatureSet.Feature.FOR_OF)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "makeIterator");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ARRAY_DESTRUCTURING)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "makeIterator");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ARRAY_PATTERN_REST)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "arrayFromIterator");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.SPREAD_EXPRESSIONS)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "arrayfromiterable");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.CLASS_EXTENDS)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "inherits");
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.CLASS_GETTER_SETTER)) {
            this.compiler.ensureLibraryInjected("util/global", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.GENERATORS)) {
            this.compiler.ensureLibraryInjected("es6/generator_engine", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ASYNC_FUNCTIONS)) {
            this.compiler.ensureLibraryInjected("es6/execute_async_generator", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.ASYNC_GENERATORS)) {
            this.compiler.ensureLibraryInjected("es6/async_generator_wrapper", false);
        }
        if (mustBeCompiledAway.contains(FeatureSet.Feature.FOR_AWAIT_OF)) {
            this.compiler.ensureLibraryInjected("es6/util/makeasynciterator", false);
        }
    }

    private static FeatureSet getScriptFeatures(Node script) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null ? features : FeatureSet.ES3;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, requiredForFeatures, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                if (n.isFromExterns() || !this.isGlobalSymbol(t, n)) break;
                this.initSymbolBefore(n);
                break;
            }
            case GETPROP: {
                if (n.isFromExterns()) break;
                this.visitGetprop(t, n);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.getterSetterSupported) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                break;
            }
        }
    }

    private boolean isGlobalSymbol(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol")) {
            return false;
        }
        Var var = (Var)t.getScope().getVar("Symbol");
        return var == null || var.isGlobal();
    }

    private void initSymbolBefore(Node n) {
        this.compiler.ensureLibraryInjected("es6/symbol", false);
        Node statement = NodeUtil.getEnclosingStatement(n);
        Node initSymbol = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbol"), new Node[0]));
        statement.getParent().addChildBefore(initSymbol.useSourceInfoFromForTree(statement), statement);
        this.compiler.reportChangeToEnclosingScope(initSymbol);
    }

    private void visitGetprop(NodeTraversal t, Node n) {
        Node receiverNode = n.getFirstChild();
        String propName = receiverNode.getNext().getString();
        if (this.isGlobalSymbol(t, receiverNode)) {
            this.compiler.ensureLibraryInjected("es6/symbol", false);
            Node statement = NodeUtil.getEnclosingStatement(n);
            switch (propName) {
                case "iterator": {
                    Node init = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbolIterator"), new Node[0])).useSourceInfoFromForTree(statement);
                    statement.getParent().addChildBefore(init, statement);
                    this.compiler.reportChangeToEnclosingScope(init);
                    break;
                }
                case "asyncIterator": {
                    Node init = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbolAsyncIterator"), new Node[0])).useSourceInfoFromForTree(statement);
                    statement.getParent().addChildBefore(init, statement);
                    this.compiler.reportChangeToEnclosingScope(init);
                    break;
                }
            }
        }
    }
}

