/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MaxParametersRule
extends LinterRule {
    public int maximum = 6;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (functionNode.getParameterNodes().length <= this.maximum) {
            return;
        }
        problems.add(new MaxParametersLinterProblem(functionNode, this.maximum));
    }

    public static class MaxParametersLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Function '${functionName}' has ${params} parameters, but expected no more than ${maxParams} parameters";
        public String functionName;
        public int params;
        public int maxParams;

        public MaxParametersLinterProblem(IFunctionNode node, int maxParams) {
            super((ISourceLocation)node.getParametersContainerNode());
            this.maxParams = maxParams;
            this.params = node.getParameterNodes().length;
            this.functionName = node.getName();
        }
    }
}

