/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoWildcardImportRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ImportID, (node, tokenQuery, problems) -> this.checkImportNode((IImportNode)node, tokenQuery, problems));
        return result;
    }

    private void checkImportNode(IImportNode importNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!importNode.isWildcardImport()) {
            return;
        }
        problems.add(new NoWildcardImportLinterProblem(importNode));
    }

    public static class NoWildcardImportLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must not use wildcard import";

        public NoWildcardImportLinterProblem(IImportNode node) {
            super((ISourceLocation)node);
        }
    }
}

