/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo.tcp;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Timer;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.metrics.ClientMetricEventsListener;
import io.reactivex.netty.servo.RefCountingMonitor;
import io.reactivex.netty.servo.ServoUtils;
import java.util.concurrent.TimeUnit;

public class TcpClientListener<T extends ClientMetricsEvent<?>>
extends ClientMetricEventsListener<T> {
    private final LongGauge liveConnections;
    private final Counter connectionCount;
    private final LongGauge pendingConnects;
    private final Counter failedConnects;
    private final Timer connectionTimes;
    private final LongGauge pendingConnectionClose;
    private final Counter failedConnectionClose;
    private final LongGauge pendingPoolAcquires;
    private final Counter failedPoolAcquires;
    private final Timer poolAcquireTimes;
    private final LongGauge pendingPoolReleases;
    private final Counter failedPoolReleases;
    private final Timer poolReleaseTimes;
    private final Counter poolAcquires;
    private final Counter poolEvictions;
    private final Counter poolReuse;
    private final Counter poolReleases;
    private final LongGauge pendingWrites;
    private final LongGauge pendingFlushes;
    private final Counter bytesWritten;
    private final Timer writeTimes;
    private final Counter bytesRead;
    private final Counter failedWrites;
    private final Counter failedFlushes;
    private final Timer flushTimes;
    private final RefCountingMonitor refCounter;

    protected TcpClientListener(String monitorId) {
        this.refCounter = new RefCountingMonitor(monitorId);
        this.liveConnections = ServoUtils.newLongGauge("liveConnections");
        this.connectionCount = Monitors.newCounter((String)"connectionCount");
        this.pendingConnects = ServoUtils.newLongGauge("pendingConnects");
        this.failedConnects = Monitors.newCounter((String)"failedConnects");
        this.connectionTimes = Monitors.newTimer((String)"connectionTimes");
        this.pendingConnectionClose = ServoUtils.newLongGauge("pendingConnectionClose");
        this.failedConnectionClose = Monitors.newCounter((String)"failedConnectionClose");
        this.pendingPoolAcquires = ServoUtils.newLongGauge("pendingPoolAcquires");
        this.poolAcquireTimes = Monitors.newTimer((String)"poolAcquireTimes");
        this.failedPoolAcquires = Monitors.newCounter((String)"failedPoolAcquires");
        this.pendingPoolReleases = ServoUtils.newLongGauge("pendingPoolReleases");
        this.poolReleaseTimes = Monitors.newTimer((String)"poolReleaseTimes");
        this.failedPoolReleases = Monitors.newCounter((String)"failedPoolReleases");
        this.poolAcquires = Monitors.newCounter((String)"poolAcquires");
        this.poolEvictions = Monitors.newCounter((String)"poolEvictions");
        this.poolReuse = Monitors.newCounter((String)"poolReuse");
        this.poolReleases = Monitors.newCounter((String)"poolReleases");
        this.pendingWrites = ServoUtils.newLongGauge("pendingWrites");
        this.pendingFlushes = ServoUtils.newLongGauge("pendingFlushes");
        this.bytesWritten = Monitors.newCounter((String)"bytesWritten");
        this.writeTimes = Monitors.newTimer((String)"writeTimes");
        this.bytesRead = Monitors.newCounter((String)"bytesRead");
        this.failedWrites = Monitors.newCounter((String)"failedWrites");
        this.failedFlushes = Monitors.newCounter((String)"failedFlushes");
        this.flushTimes = Monitors.newTimer((String)"flushTimes");
    }

    protected void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingFlushes);
        this.failedFlushes.increment();
    }

    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.pendingFlushes);
        this.flushTimes.record(duration, timeUnit);
    }

    protected void onFlushStart() {
        ServoUtils.incrementLongGauge(this.pendingFlushes);
    }

    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingWrites);
        this.failedWrites.increment();
    }

    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
        ServoUtils.decrementLongGauge(this.pendingWrites);
        this.bytesWritten.increment(bytesWritten);
        this.writeTimes.record(duration, timeUnit);
    }

    protected void onWriteStart() {
        ServoUtils.incrementLongGauge(this.pendingWrites);
    }

    protected void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingPoolReleases);
        this.poolReleases.increment();
        this.failedPoolReleases.increment();
    }

    protected void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.pendingPoolReleases);
        this.poolReleases.increment();
        this.poolReleaseTimes.record(duration, timeUnit);
    }

    protected void onPoolReleaseStart() {
        ServoUtils.incrementLongGauge(this.pendingPoolReleases);
    }

    protected void onPooledConnectionEviction() {
        this.poolEvictions.increment();
    }

    protected void onPooledConnectionReuse(long duration, TimeUnit timeUnit) {
        this.poolReuse.increment();
    }

    protected void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingPoolAcquires);
        this.poolAcquires.increment();
        this.failedPoolAcquires.increment();
    }

    protected void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.pendingPoolAcquires);
        this.poolAcquires.increment();
        this.poolAcquireTimes.record(duration, timeUnit);
    }

    protected void onPoolAcquireStart() {
        ServoUtils.incrementLongGauge(this.pendingPoolAcquires);
    }

    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.liveConnections);
        ServoUtils.decrementLongGauge(this.pendingConnectionClose);
        this.failedConnectionClose.increment();
    }

    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.liveConnections);
        ServoUtils.decrementLongGauge(this.pendingConnectionClose);
    }

    protected void onConnectionCloseStart() {
        ServoUtils.incrementLongGauge(this.pendingConnectionClose);
    }

    protected void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        ServoUtils.decrementLongGauge(this.pendingConnects);
        this.failedConnects.increment();
    }

    protected void onConnectSuccess(long duration, TimeUnit timeUnit) {
        ServoUtils.decrementLongGauge(this.pendingConnects);
        ServoUtils.incrementLongGauge(this.liveConnections);
        this.connectionCount.increment();
        this.connectionTimes.record(duration, timeUnit);
    }

    protected void onConnectStart() {
        ServoUtils.incrementLongGauge(this.pendingConnects);
    }

    public void onCompleted() {
        this.refCounter.onCompleted((Object)this);
    }

    public void onSubscribe() {
        this.refCounter.onSubscribe((Object)this);
    }

    public long getLiveConnections() {
        return this.liveConnections.getNumber().get();
    }

    public long getConnectionCount() {
        return ((Number)this.connectionCount.getValue()).longValue();
    }

    public long getPendingConnects() {
        return this.pendingConnects.getNumber().get();
    }

    public long getFailedConnects() {
        return ((Number)this.failedConnects.getValue()).longValue();
    }

    public Timer getConnectionTimes() {
        return this.connectionTimes;
    }

    public long getPendingConnectionClose() {
        return this.pendingConnectionClose.getNumber().get();
    }

    public long getFailedConnectionClose() {
        return ((Number)this.failedConnectionClose.getValue()).longValue();
    }

    public long getPendingPoolAcquires() {
        return this.pendingPoolAcquires.getNumber().get();
    }

    public long getFailedPoolAcquires() {
        return ((Number)this.failedPoolAcquires.getValue()).longValue();
    }

    public Timer getPoolAcquireTimes() {
        return this.poolAcquireTimes;
    }

    public long getPendingPoolReleases() {
        return this.pendingPoolReleases.getNumber().get();
    }

    public long getFailedPoolReleases() {
        return ((Number)this.failedPoolReleases.getValue()).longValue();
    }

    public Timer getPoolReleaseTimes() {
        return this.poolReleaseTimes;
    }

    public long getPoolEvictions() {
        return ((Number)this.poolEvictions.getValue()).longValue();
    }

    public long getPoolReuse() {
        return ((Number)this.poolReuse.getValue()).longValue();
    }

    public long getPendingWrites() {
        return this.pendingWrites.getNumber().get();
    }

    public long getPendingFlushes() {
        return this.pendingFlushes.getNumber().get();
    }

    public long getBytesWritten() {
        return ((Number)this.bytesWritten.getValue()).longValue();
    }

    public Timer getWriteTimes() {
        return this.writeTimes;
    }

    public long getBytesRead() {
        return ((Number)this.bytesRead.getValue()).longValue();
    }

    public long getFailedWrites() {
        return ((Number)this.failedWrites.getValue()).longValue();
    }

    public long getFailedFlushes() {
        return ((Number)this.failedFlushes.getValue()).longValue();
    }

    public Timer getFlushTimes() {
        return this.flushTimes;
    }

    public long getPoolAcquires() {
        return ((Number)this.poolAcquires.getValue()).longValue();
    }

    public long getPoolReleases() {
        return ((Number)this.poolReleases.getValue()).longValue();
    }

    public static TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>> newListener(String monitorId) {
        return new TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>>(monitorId);
    }
}

