/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.query;

import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.StringJoiner;
import org.apache.servicecomb.common.rest.codec.param.QueryProcessorCreator;
import org.apache.servicecomb.common.rest.codec.query.AbstractQueryCodec;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;

public class QueryCodecWithDelimiter
extends AbstractQueryCodec {
    private final String joinDelimiter;
    private final String splitDelimiter;

    public QueryCodecWithDelimiter(String codecName, String joinDelimiter, String splitDelimiter) {
        super(codecName);
        this.joinDelimiter = joinDelimiter;
        this.splitDelimiter = splitDelimiter;
    }

    @Override
    public void encode(URLPathBuilder.URLPathStringBuilder builder, String name, @Nonnull Collection<Object> values) throws Exception {
        String joined = this.join(values);
        if (joined == null) {
            return;
        }
        builder.appendQuery(name, joined);
    }

    protected String join(Collection<Object> values) throws Exception {
        StringJoiner joiner = new StringJoiner(this.joinDelimiter);
        boolean hasValue = false;
        for (Object value : values) {
            if (value == null) continue;
            String strValue = QueryCodec.convertToString(value);
            joiner.add(strValue);
            hasValue = true;
        }
        return hasValue ? QueryCodec.encodeValue(joiner.toString()) : null;
    }

    @Override
    public Object decode(QueryProcessorCreator.QueryProcessor processor, HttpServletRequest request) {
        String[] value = processor.getAndCheckParameter(request);
        value = value != null ? value.toString().split(this.splitDelimiter, -1) : new String[]{};
        return processor.convertValue(value);
    }
}

