/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.context;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.generator.context.IExtensionsContext;
import org.apache.servicecomb.toolkit.generator.context.OasContext;
import org.apache.servicecomb.toolkit.generator.context.ParameterContext;
import org.apache.servicecomb.toolkit.generator.parser.api.OpenApiAnnotationParser;
import org.apache.servicecomb.toolkit.generator.util.ModelConverter;
import org.apache.servicecomb.toolkit.generator.util.RequestResponse;

public class OperationContext
implements IExtensionsContext {
    private static final RequestBody nullRequestBody = new RequestBody();
    private OasContext parentContext;
    private Method method;
    private Operation operation = new Operation();
    private String operationId;
    private String path;
    private String httpMethod;
    private ApiResponses apiResponses = new ApiResponses();
    private List<ParameterContext> parameterContexts = new ArrayList<ParameterContext>();
    private OpenApiAnnotationParser parser;
    private Boolean deprecated = false;
    private String description = null;
    private String summary;
    private List<String> tags;
    private String[] consumes;
    private String[] produces;
    private String[] headers;

    public OperationContext(Method method, OasContext parentContext) {
        this.parentContext = parentContext;
        this.method = method;
        this.parser = parentContext.getParser();
        this.parentContext.addOperation(this);
    }

    @Override
    public OpenApiAnnotationParser getParser() {
        return this.parser;
    }

    public boolean hasOperation() {
        return this.getHttpMethod() != null && this.method != null;
    }

    public Operation toOperation() {
        if (!this.hasOperation()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.operationId)) {
            this.operationId = this.method.getName();
        }
        this.operation.operationId(this.operationId);
        this.processHeaders();
        this.processProduces();
        this.correctResponse(this.apiResponses);
        this.operation.setResponses(this.apiResponses);
        RequestBody requestBody = new RequestBody();
        Content content = new Content();
        MediaType mediaType = new MediaType();
        List parameterList = this.parameterContexts.stream().map(parameterContext -> {
            if (parameterContext.isRequestBody()) {
                Schema schema = mediaType.getSchema();
                if (schema == null) {
                    schema = new ObjectSchema();
                    mediaType.schema(schema);
                }
                schema.addProperties(parameterContext.getName(), parameterContext.getSchema());
                if (this.consumes != null) {
                    for (String consume : this.getConsumers()) {
                        content.addMediaType(consume, mediaType);
                    }
                } else if (parameterContext.getConsumers() != null && parameterContext.getConsumers().size() > 0) {
                    for (String consume : parameterContext.getConsumers()) {
                        content.addMediaType(consume, mediaType);
                    }
                } else {
                    content.addMediaType("application/json", mediaType);
                }
                requestBody.setContent(content);
                requestBody.setRequired(parameterContext.getRequired());
                return null;
            }
            return parameterContext.toParameter();
        }).filter(parameter -> parameter != null).collect(Collectors.toList());
        if (parameterList.size() > 0) {
            this.operation.parameters(parameterList);
        }
        if (!nullRequestBody.equals((Object)requestBody)) {
            this.operation.setRequestBody(requestBody);
        }
        return this.operation;
    }

    private void processHeaders() {
        if (this.getHeaders() == null) {
            return;
        }
        Arrays.stream(this.headers).forEach(header -> {
            String[] headMap = header.split("=");
            if (headMap.length == 2) {
                HeaderParameter headerParameter = new HeaderParameter();
                headerParameter.setName(headMap[0]);
                StringSchema value = new StringSchema();
                value.setDefault((Object)headMap[1]);
                headerParameter.setSchema((Schema)value);
                this.operation.addParametersItem((Parameter)headerParameter);
            }
        });
    }

    private void processProduces() {
        if (this.getProduces() == null) {
            return;
        }
        List produceList = Arrays.stream(this.produces).filter(s -> !StringUtils.isEmpty((CharSequence)s)).collect(Collectors.toList());
        if (!produceList.isEmpty()) {
            ApiResponse apiResponse = new ApiResponse();
            Content content = new Content();
            MediaType mediaType = new MediaType();
            Schema schema = ModelConverter.getSchema(this.getMethod().getReturnType(), this.getComponents(), RequestResponse.RESPONSE);
            mediaType.schema(schema);
            for (String produce : produceList) {
                content.addMediaType(produce, mediaType);
            }
            apiResponse.description("OK");
            apiResponse.setContent(content);
            this.addResponse("200", apiResponse);
        }
    }

    public void setRequestBody(RequestBody requestBody) {
        this.operation.requestBody(requestBody);
    }

    public void correctResponse(ApiResponses apiResponses) {
        if (apiResponses == null) {
            return;
        }
        if (apiResponses.get((Object)"200") == null) {
            ApiResponse apiResponse = new ApiResponse();
            Class<?> returnType = this.method.getReturnType();
            if (returnType == Void.TYPE || returnType == Void.class) {
                return;
            }
            MediaType mediaType = new MediaType();
            Schema refSchema = ModelConverter.getSchema(returnType, this.getComponents(), RequestResponse.RESPONSE);
            mediaType.schema(refSchema);
            Content content = new Content();
            content.addMediaType("application/json", mediaType);
            apiResponse.description("OK");
            apiResponse.setContent(content);
            apiResponses.addApiResponse("200", apiResponse);
        }
    }

    public Components getComponents() {
        return this.parentContext.getComponents();
    }

    public void addResponse(String key, ApiResponse response) {
        this.apiResponses.addApiResponse(key, response);
    }

    public ApiResponses getApiResponses() {
        return this.apiResponses;
    }

    public void setApiResponses(ApiResponses apiResponses) {
        this.apiResponses = apiResponses;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public OpenAPI getOpenAPI() {
        return this.parentContext.getOpenAPI();
    }

    public Method getMethod() {
        return this.method;
    }

    public OasContext getOpenApiContext() {
        return this.parentContext;
    }

    public String getHttpMethod() {
        return Optional.ofNullable(this.httpMethod).orElse(this.parentContext.getHttpMethod());
    }

    public void setHttpMethod(String httpMethod) {
        if (this.httpMethod != null) {
            throw new IllegalArgumentException(String.format("too many http method in the method %s", this.method.getName()));
        }
        this.httpMethod = httpMethod.toUpperCase();
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    @Override
    public void addExtension(String name, Object value) {
        this.operation.addExtension(name, value);
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.operation.getExtensions();
    }

    public String[] getConsumers() {
        return this.consumes;
    }

    public void setConsumers(String[] consumes) {
        this.consumes = consumes;
    }

    public void addParamCtx(ParameterContext ctx) {
        this.parameterContexts.add(ctx);
    }

    public String[] getProduces() {
        if (this.produces == null) {
            this.produces = this.parentContext.getProduces();
        }
        return this.produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    public String[] getHeaders() {
        if (this.headers == null) {
            this.headers = this.parentContext.getHeaders();
        }
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }
}

