/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.toolkit.generator.util.LocalVariableVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ParamUtils {
    private static final String STATIC_CLASS_INIT = "<clinit>";
    public static final Map<Method, String[]> parameterCache = new HashMap<Method, String[]>();

    public static String getParameterName(Method method, Parameter parameter) {
        String[] parameterNames = parameterCache.get(method);
        if (parameterNames == null && (parameterNames = ParamUtils.initParameterNames(method)) == null) {
            return null;
        }
        int paramIndex = ParamUtils.getParamIndex(method, parameter);
        if (paramIndex >= 0) {
            return parameterNames[paramIndex];
        }
        return null;
    }

    private static int getParamIndex(Method method, Parameter parameter) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(parameter)) continue;
            return i;
        }
        return -1;
    }

    private static String[] initParameterNames(final Method m) {
        final boolean isStatic = Modifier.isStatic(m.getModifiers());
        final String[] parameterNames = new String[m.getParameterCount()];
        try {
            String className = m.getDeclaringClass().getName();
            String classRawName = className.replace('.', '/') + ".class";
            InputStream is = null;
            ClassLoader classLoader = m.getDeclaringClass().getClassLoader();
            is = classLoader != null ? classLoader.getResourceAsStream(classRawName) : m.getDeclaringClass().getResourceAsStream(classRawName);
            if (is == null) {
                return null;
            }
            ClassReader clsReader = new ClassReader(is);
            ClassWriter clsWriter = new ClassWriter(1);
            clsReader.accept(new ClassVisitor(458752, (ClassVisitor)clsWriter){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if (!m.getName().equals(name) || !descriptor.equals(Type.getMethodDescriptor((Method)m))) {
                        return methodVisitor;
                    }
                    if (!ParamUtils.isSyntheticOrBridged(access) && !ParamUtils.STATIC_CLASS_INIT.equals(name)) {
                        return new LocalVariableVisitor(this.api, descriptor, isStatic, parameterNames);
                    }
                    return methodVisitor;
                }
            }, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        parameterCache.put(m, parameterNames);
        return parameterNames;
    }

    private static boolean isSyntheticOrBridged(int access) {
        return (access & 0x1000 | access & 0x40) > 0;
    }
}

