/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sling.commons.log.logback.internal.config.ConfigurationException;
import org.apache.sling.commons.log.logback.internal.config.LogConfigurator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.cm.ManagedServiceFactory;

public class LoggerManagedServiceFactory
extends LogConfigurator
implements ManagedServiceFactory {
    public static final String LOG_FILE_DEFAULT = "logs/error.log";

    @NotNull
    public String getName() {
        return "Logger configurator";
    }

    public void updated(@NotNull String pid, @NotNull Dictionary<String, ?> configuration) throws org.osgi.service.cm.ConfigurationException {
        try {
            Dictionary<String, ?> conf = configuration;
            if (configuration.get("org.apache.sling.commons.log.file") == null) {
                ArrayList<String> keys = Collections.list(configuration.keys());
                Map confCopy = keys.stream().collect(Collectors.toMap(Function.identity(), configuration::get));
                confCopy.put("org.apache.sling.commons.log.file", LOG_FILE_DEFAULT);
                conf = new Hashtable(confCopy);
            }
            this.getLogConfigManager().updateLoggerConfiguration(pid, conf, true);
        }
        catch (ConfigurationException ce) {
            throw new org.osgi.service.cm.ConfigurationException(ce.getProperty(), ce.getReason(), (Throwable)ce);
        }
    }

    public void deleted(@NotNull String pid) {
        try {
            this.getLogConfigManager().updateLoggerConfiguration(pid, null, true);
        }
        catch (ConfigurationException ce) {
            this.getLogConfigManager().internalFailure("Unexpected Configuration Problem", ce);
        }
    }
}

