/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageBuilderProvider;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.exporter.AgentDistributionPackageExporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionPackageExporter.class}, property={"webconsole.configurationFactory.nameHint=Exporter name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class AgentDistributionPackageExporterFactory
implements DistributionPackageExporter {
    @Reference(name="agent")
    private DistributionAgent agent;
    @Reference
    private DistributionPackageBuilderProvider packageBuilderProvider;
    private DistributionPackageExporter packageExporter;

    @Activate
    public void activate(Config conf) {
        String queueName = conf.queue();
        queueName = (queueName = SettingsUtils.removeEmptyEntry(queueName)) == null ? "default" : queueName;
        String name = conf.name();
        boolean dropInvalidItems = conf.drop_invalid_items();
        this.packageExporter = new AgentDistributionPackageExporter(queueName, this.agent, this.packageBuilderProvider, name, dropInvalidItems);
    }

    @Override
    public void exportPackages(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest, @NotNull DistributionPackageProcessor packageProcessor) throws DistributionException {
        this.packageExporter.exportPackages(resourceResolver, distributionRequest, packageProcessor);
    }

    @Override
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String distributionPackageId) throws DistributionException {
        return this.packageExporter.getPackage(resourceResolver, distributionPackageId);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Exporter - Agent Based Package Exporter")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the exporter.")
        public String name();

        @AttributeDefinition(name="Queue", description="The name of the queue from which the packages should be exported.")
        public String queue() default "default";

        @AttributeDefinition(name="Drop invalid queue items", description="Remove invalid items from the queue.")
        public boolean drop_invalid_items() default false;

        @AttributeDefinition(name="The target reference for the DistributionAgent that will be used to export packages.")
        public String agent_target();
    }
}

