/*
 * Decompiled with CFR 0.152.
 */
package com.aem632.core.models;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class})
public class HelloWorldModel {
    @ValueMapValue(name="sling:resourceType", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"No resourceType"})
    protected String resourceType;
    @SlingObject
    private Resource currentResource;
    @SlingObject
    private ResourceResolver resourceResolver;
    private String message;

    @PostConstruct
    protected void init() {
        PageManager pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
        String currentPagePath = Optional.ofNullable(pageManager).map(pm -> pm.getContainingPage(this.currentResource)).map(Page::getPath).orElse("");
        ValueMap initialContentProps = ResourceUtil.getValueMap((Resource)this.resourceResolver.getResource("/apps/aem632/core/test"));
        this.message = "Hello World!\nResource type is: " + this.resourceType + "\nCurrent page is:  " + currentPagePath + "\nTest property 1:  " + (String)initialContentProps.get("property1", String.class) + "\nTest property 2:  " + (String)initialContentProps.get("property2", String.class) + "\n";
    }

    public String getMessage() {
        return this.message;
    }
}

