/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.Operation;

public class FactoryConfigurationDescription
extends ConfigurableEntity {
    private final Set<Operation> operations = new HashSet<Operation>();
    private final List<String> internalNames = new ArrayList<String>();
    private Mode internalMode;

    public FactoryConfigurationDescription() {
        this.setDefaults();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.getOperations().add(Operation.CREATE);
        this.getOperations().add(Operation.UPDATE);
    }

    @Override
    public void clear() {
        super.clear();
        this.internalNames.clear();
        this.internalMode = null;
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            String internalModeVal;
            JsonValue val = this.getAttributes().remove("operations");
            if (val != null) {
                this.getOperations().clear();
                for (JsonValue innerVal : val.asJsonArray()) {
                    String v = this.getString(innerVal).toUpperCase();
                    this.getOperations().add(Operation.valueOf(v));
                }
                if (this.getOperations().isEmpty()) {
                    throw new IOException("Operations must not be empty");
                }
            }
            if ((val = this.getAttributes().remove("internal-names")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalNames().add(this.getString(innerVal));
                }
            }
            if ((internalModeVal = this.getString("internal-mode")) != null) {
                this.setInternalMode(Mode.valueOf(internalModeVal.toUpperCase()));
            }
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public List<String> getInternalNames() {
        return this.internalNames;
    }

    public Mode getInternalMode() {
        return this.internalMode;
    }

    public void setInternalMode(Mode internalMode) {
        this.internalMode = internalMode;
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonArrayBuilder arrayBuilder;
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getOperations().isEmpty() && this.getOperations().size() != 2) {
            arrayBuilder = Json.createArrayBuilder();
            for (Operation op : this.getOperations()) {
                arrayBuilder.add(op.name());
            }
            objBuilder.add("operations", arrayBuilder);
        }
        if (!this.getInternalNames().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (String n : this.getInternalNames()) {
                arrayBuilder.add(n);
            }
            objBuilder.add("internal-names", arrayBuilder);
        }
        if (this.getInternalMode() != null) {
            objBuilder.add("internal-mode", this.getInternalMode().name());
        }
        return objBuilder;
    }
}

