/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public final class ExporterFilterFactoryUtil {
    public static final String EXCEPTION_MESSAGE_KEY_FACTORY_CLASS_NOT_FOUND = "export.filter.factory.class.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_FACTORY_CLASS_INSTANCE_FAILURE = "export.filter.factory.class.instance.failure";

    public static ExporterFilterFactory getFilterFactory(String factoryClassName) throws JRException {
        try {
            Class<?> clazz = JRClassLoader.loadClassForName(factoryClassName);
            return (ExporterFilterFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_FACTORY_CLASS_NOT_FOUND, new Object[]{factoryClassName}, e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_FACTORY_CLASS_INSTANCE_FAILURE, new Object[]{factoryClassName}, e);
        }
    }

    private ExporterFilterFactoryUtil() {
    }
}

