/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;

public class DocxZip
extends FileBufferedZip {
    private ExportZipEntry documentEntry = this.createEntry("word/document.xml");
    private ExportZipEntry stylesEntry = this.createEntry("word/styles.xml");
    private ExportZipEntry settingsEntry = this.createEntry("word/settings.xml");
    private ExportZipEntry relsEntry;
    private ExportZipEntry contentTypesEntry;
    private ExportZipEntry appEntry;
    private ExportZipEntry coreEntry;
    private ExportZipEntry fontTableEntry = this.createEntry("word/fontTable.xml");
    private ExportZipEntry fontTableRelsEntry = this.createEntry("word/_rels/fontTable.xml.rels");

    public DocxZip() throws IOException {
        this.relsEntry = this.createEntry("word/_rels/document.xml.rels");
        this.contentTypesEntry = this.createEntry("[Content_Types].xml");
        this.appEntry = this.createEntry("docProps/app.xml");
        this.coreEntry = this.createEntry("docProps/core.xml");
        this.addEntry("_rels/.rels", "net/sf/jasperreports/engine/export/ooxml/docx/_rels/xml.rels");
    }

    public ExportZipEntry getDocumentEntry() {
        return this.documentEntry;
    }

    public ExportZipEntry addHeader(int index) {
        return this.createEntry("word/header" + index + ".xml");
    }

    public ExportZipEntry addHeaderRels(int index) {
        return this.createEntry("word/_rels/header" + index + ".xml.rels");
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public ExportZipEntry getSettingsEntry() {
        return this.settingsEntry;
    }

    public ExportZipEntry getRelsEntry() {
        return this.relsEntry;
    }

    public ExportZipEntry getContentTypesEntry() {
        return this.contentTypesEntry;
    }

    public ExportZipEntry getAppEntry() {
        return this.appEntry;
    }

    public ExportZipEntry getCoreEntry() {
        return this.coreEntry;
    }

    public ExportZipEntry getFontTableEntry() {
        return this.fontTableEntry;
    }

    public ExportZipEntry getFontTableRelsEntry() {
        return this.fontTableRelsEntry;
    }
}

