/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.rest.API;

public class MultiXMLConfigurationBuilder {
    public static final String PROXY_SERVICES_DIR = "proxy-services";
    public static final String SEQUENCES_DIR = "sequences";
    public static final String TEMPLATES_DIR = "templates";
    public static final String ENDPOINTS_DIR = "endpoints";
    public static final String LOCAL_ENTRY_DIR = "local-entries";
    public static final String TASKS_DIR = "tasks";
    public static final String EVENTS_DIR = "event-sources";
    public static final String EXECUTORS_DIR = "priority-executors";
    public static final String MESSAGE_STORE_DIR = "message-stores";
    public static final String MESSAGE_PROCESSOR_DIR = "message-processors";
    public static final String REST_API_DIR = "api";
    public static final String SYNAPSE_IMPORTS_DIR = "imports";
    public static final String REGISTRY_FILE = "registry.xml";
    public static final String SEPARATE_REGISTRY_DEFINITION = "__separateRegDef";
    private static final String[] extensions = new String[]{"xml"};
    private static Log log = LogFactory.getLog(MultiXMLConfigurationBuilder.class);

    public static SynapseConfiguration getConfiguration(String root, Properties properties) {
        log.info((Object)("Building synapse configuration from the synapse artifact repository at : " + root));
        SynapseConfiguration synapseConfig = MultiXMLConfigurationBuilder.createConfigurationFromSynapseXML(root, properties);
        if (synapseConfig == null) {
            synapseConfig = SynapseConfigUtils.newConfiguration();
            synapseConfig.setDefaultQName(XMLConfigConstants.DEFINITIONS_ELT);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Found a synapse configuration in the synapse.xml file at the artifact repository root, which gets precedence over other definitions");
        }
        if (synapseConfig.getRegistry() == null) {
            MultiXMLConfigurationBuilder.createRegistry(synapseConfig, root, properties);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Using the registry defined in the synapse.xml as the registry, any definitions in the registry.xml will be neglected");
        }
        MultiXMLConfigurationBuilder.createLocalEntries(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createEndpoints(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createSequences(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createTemplates(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createProxyServices(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createTasks(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createEventSources(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createExecutors(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createMessageStores(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createMessageProcessors(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createSynapseImports(synapseConfig, root, properties);
        MultiXMLConfigurationBuilder.createAPIs(synapseConfig, root);
        return synapseConfig;
    }

    private static SynapseConfiguration createConfigurationFromSynapseXML(String rootDirPath, Properties properties) {
        FileInputStream is;
        File synapseXML = new File(rootDirPath, "synapse.xml");
        if (!synapseXML.exists() || !synapseXML.isFile()) {
            return null;
        }
        SynapseConfiguration config = null;
        try {
            is = FileUtils.openInputStream((File)synapseXML);
        }
        catch (IOException e) {
            MultiXMLConfigurationBuilder.handleException("Error while opening the file: " + synapseXML.getName(), e);
            return null;
        }
        try {
            config = XMLConfigurationBuilder.getConfiguration(is, properties);
            is.close();
        }
        catch (XMLStreamException e) {
            MultiXMLConfigurationBuilder.handleException("Error while loading the Synapse configuration from the " + synapseXML.getName() + " file", e);
        }
        catch (IOException e) {
            log.warn((Object)("Error while closing the input stream from file: " + synapseXML.getName()), (Throwable)e);
        }
        return config;
    }

    private static void createRegistry(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File registryDef = new File(rootDirPath, REGISTRY_FILE);
        if (registryDef.exists() && registryDef.isFile()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing Synapse registry from the configuration at : " + registryDef.getPath()));
            }
            OMElement document = MultiXMLConfigurationBuilder.getOMElement(registryDef);
            SynapseXMLConfigurationFactory.defineRegistry(synapseConfig, document, properties);
            synapseConfig.setProperty(SEPARATE_REGISTRY_DEFINITION, String.valueOf(Boolean.TRUE));
        }
    }

    private static void createLocalEntries(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File localEntriesDir = new File(rootDirPath, LOCAL_ENTRY_DIR);
        if (localEntriesDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading local entry definitions from : " + localEntriesDir.getPath()));
            }
            Iterator entryDefinitions = FileUtils.iterateFiles((File)localEntriesDir, (String[])extensions, (boolean)false);
            while (entryDefinitions.hasNext()) {
                Entry entry;
                File file = (File)entryDefinitions.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Local Entry from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("localentries", msg, e);
                }
                if (document == null || (entry = SynapseXMLConfigurationFactory.defineEntry(synapseConfig, document, properties)) == null) continue;
                entry.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), entry.getKey());
            }
        }
    }

    private static void createProxyServices(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File proxyServicesDir = new File(rootDirPath, PROXY_SERVICES_DIR);
        if (proxyServicesDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading proxy services from : " + proxyServicesDir.getPath()));
            }
            Iterator proxyDefinitions = FileUtils.iterateFiles((File)proxyServicesDir, (String[])extensions, (boolean)false);
            while (proxyDefinitions.hasNext()) {
                ProxyService proxy;
                File file = (File)proxyDefinitions.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Proxy service configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("proxyservices", msg, e);
                }
                if (document == null || (proxy = SynapseXMLConfigurationFactory.defineProxy(synapseConfig, document, properties)) == null) continue;
                proxy.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), proxy.getName());
            }
        }
    }

    private static void createTasks(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File tasksDir = new File(rootDirPath, TASKS_DIR);
        if (tasksDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading tasks from : " + tasksDir.getPath()));
            }
            Iterator taskDefinitions = FileUtils.iterateFiles((File)tasksDir, (String[])extensions, (boolean)false);
            while (taskDefinitions.hasNext()) {
                File file = (File)taskDefinitions.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Task configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError(TASKS_DIR, msg, e);
                }
                if (document == null) continue;
                Startup startup = SynapseXMLConfigurationFactory.defineStartup(synapseConfig, document, properties);
                startup.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), startup.getName());
            }
        }
    }

    private static void createSequences(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File sequencesDir = new File(rootDirPath, SEQUENCES_DIR);
        if (sequencesDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading sequences from : " + sequencesDir.getPath()));
            }
            Iterator sequences = FileUtils.iterateFiles((File)sequencesDir, (String[])extensions, (boolean)false);
            while (sequences.hasNext()) {
                Mediator seq;
                File file = (File)sequences.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Sequence configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError(SEQUENCES_DIR, msg, e);
                }
                if (document == null || (seq = SynapseXMLConfigurationFactory.defineSequence(synapseConfig, document, properties)) == null || !(seq instanceof SequenceMediator)) continue;
                SequenceMediator sequence = (SequenceMediator)seq;
                sequence.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), sequence.getName());
            }
        }
    }

    private static void createTemplates(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File templatesDir = new File(rootDirPath, TEMPLATES_DIR);
        if (templatesDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading template from : " + templatesDir.getPath()));
            }
            Iterator templates = FileUtils.iterateFiles((File)templatesDir, (String[])extensions, (boolean)false);
            while (templates.hasNext()) {
                Template endpointTemplate;
                File file = (File)templates.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Template configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError(TEMPLATES_DIR, msg, e);
                }
                if (document == null) continue;
                OMElement element = document.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
                if (element != null) {
                    TemplateMediator mediator = (TemplateMediator)SynapseXMLConfigurationFactory.defineMediatorTemplate(synapseConfig, document, properties);
                    if (mediator == null) continue;
                    mediator.setFileName(file.getName());
                    synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), mediator.getName());
                    continue;
                }
                element = document.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
                if (element == null || (endpointTemplate = SynapseXMLConfigurationFactory.defineEndpointTemplate(synapseConfig, document, properties)) == null) continue;
                endpointTemplate.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), endpointTemplate.getName());
            }
        }
    }

    private static void createEndpoints(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File endpointsDir = new File(rootDirPath, ENDPOINTS_DIR);
        if (endpointsDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading endpoints from : " + endpointsDir.getPath()));
            }
            Iterator endpoints = FileUtils.iterateFiles((File)endpointsDir, (String[])extensions, (boolean)false);
            while (endpoints.hasNext()) {
                Endpoint endpoint;
                File file = (File)endpoints.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Endpoint configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError(ENDPOINTS_DIR, msg, e);
                }
                if (document == null || (endpoint = SynapseXMLConfigurationFactory.defineEndpoint(synapseConfig, document, properties)) == null) continue;
                endpoint.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), endpoint.getName());
            }
        }
    }

    private static void createEventSources(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File eventsDir = new File(rootDirPath, EVENTS_DIR);
        if (eventsDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading event sources from : " + eventsDir.getPath()));
            }
            Iterator events = FileUtils.iterateFiles((File)eventsDir, (String[])extensions, (boolean)false);
            while (events.hasNext()) {
                SynapseEventSource eventSource;
                File file = (File)events.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Event Source configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("eventsources", msg, e);
                }
                if (document == null || (eventSource = SynapseXMLConfigurationFactory.defineEventSource(synapseConfig, document, properties)) == null) continue;
                eventSource.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), eventSource.getName());
            }
        }
    }

    private static void createExecutors(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File executorsDir = new File(rootDirPath, EXECUTORS_DIR);
        if (executorsDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading event sources from : " + executorsDir.getPath()));
            }
            Iterator executors = FileUtils.iterateFiles((File)executorsDir, (String[])extensions, (boolean)false);
            while (executors.hasNext()) {
                PriorityExecutor executor;
                File file = (File)executors.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Executor configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("executors", msg, e);
                }
                if (document == null || (executor = SynapseXMLConfigurationFactory.defineExecutor(synapseConfig, document, properties)) == null) continue;
                executor.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), executor.getName());
            }
        }
    }

    private static void createMessageStores(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File messageStoresDir = new File(rootDirPath, MESSAGE_STORE_DIR);
        if (messageStoresDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading Message Stores from :" + messageStoresDir.getPath()));
            }
            Iterator messageStores = FileUtils.iterateFiles((File)messageStoresDir, (String[])extensions, (boolean)false);
            while (messageStores.hasNext()) {
                MessageStore messageStore;
                File file = (File)messageStores.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Message Store configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("messagestores", msg, e);
                }
                if (document == null || (messageStore = SynapseXMLConfigurationFactory.defineMessageStore(synapseConfig, document, properties)) == null) continue;
                messageStore.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), messageStore.getName());
            }
        }
    }

    private static void createMessageProcessors(SynapseConfiguration synapseConfig, String rootDirPath, Properties properties) {
        File messageProcessorDir = new File(rootDirPath, MESSAGE_PROCESSOR_DIR);
        if (messageProcessorDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading Message Processors from :" + messageProcessorDir.getPath()));
            }
            Iterator messageProcessors = FileUtils.iterateFiles((File)messageProcessorDir, (String[])extensions, (boolean)false);
            while (messageProcessors.hasNext()) {
                MessageProcessor messageProcessor;
                File file = (File)messageProcessors.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Message Processor configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("messageprocessors", msg, e);
                }
                if (document == null || (messageProcessor = SynapseXMLConfigurationFactory.defineMessageProcessor(synapseConfig, document, properties)) == null) continue;
                messageProcessor.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), messageProcessor.getName());
            }
        }
    }

    private static void createSynapseImports(SynapseConfiguration synapseConfig, String root, Properties properties) {
        File synImportsDir = new File(root, SYNAPSE_IMPORTS_DIR);
        if (synImportsDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading Synapse Imports from :" + synImportsDir.getPath()));
            }
            Iterator synImports = FileUtils.iterateFiles((File)synImportsDir, (String[])extensions, (boolean)false);
            while (synImports.hasNext()) {
                SynapseImport synImp;
                File file = (File)synImports.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building Synapse Import configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError(SYNAPSE_IMPORTS_DIR, msg, e);
                }
                if (document == null || (synImp = SynapseXMLConfigurationFactory.defineImport(synapseConfig, document, properties)) == null) continue;
                synImp.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), synImp.getName());
            }
        }
    }

    private static void createAPIs(SynapseConfiguration synapseConfig, String rootDirPath) {
        File apiDir = new File(rootDirPath, REST_API_DIR);
        if (apiDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading APIs from :" + apiDir.getPath()));
            }
            Iterator apiIterator = FileUtils.iterateFiles((File)apiDir, (String[])extensions, (boolean)false);
            while (apiIterator.hasNext()) {
                API api;
                File file = (File)apiIterator.next();
                OMElement document = null;
                try {
                    document = MultiXMLConfigurationBuilder.getOMElement(file);
                }
                catch (Exception e) {
                    String msg = "Error while building API configuration from file : " + file.getName();
                    MultiXMLConfigurationBuilder.handleConfigurationError("apis", msg, e);
                }
                if (document == null || (api = SynapseXMLConfigurationFactory.defineAPI(synapseConfig, document)) == null) continue;
                api.setFileName(file.getName());
                synapseConfig.getArtifactDeploymentStore().addArtifact(file.getAbsolutePath(), api.getName());
            }
        }
    }

    private static OMElement getOMElement(File file) {
        FileInputStream is;
        try {
            is = FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            MultiXMLConfigurationBuilder.handleException("Error while opening the file: " + file.getName() + " for reading", e);
            return null;
        }
        OMElement document = OMXMLBuilderFactory.createOMBuilder((InputStream)is).getDocumentElement();
        document.build();
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn((Object)("Error while closing the input stream from the file: " + file.getName()), (Throwable)e);
        }
        return document;
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void handleConfigurationError(String componentType, String msg, Exception e) {
        if (!SynapseConfigUtils.isFailSafeEnabled(componentType)) {
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
        log.warn((Object)(msg + " - Continue in fail-safe mode"), (Throwable)e);
    }
}

