/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.metadata.ServiceName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.DescriptionKey;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ResolvedHandlersDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.converter.JavaClassToDBCConverter;
import org.apache.axis2.jaxws.description.impl.ResolvedHandlersDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.ServiceDescriptionImpl;
import org.apache.axis2.jaxws.description.validator.EndpointDescriptionValidator;
import org.apache.axis2.jaxws.description.validator.ServiceDescriptionValidator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionFactoryImpl {
    private static final Log log = LogFactory.getLog(DescriptionFactoryImpl.class);
    private static Map<DescriptionKey, ServiceDescription> cache = new Hashtable<DescriptionKey, ServiceDescription>();

    private DescriptionFactoryImpl() {
    }

    public static ServiceDescription createServiceDescription(URL wsdlURL, QName serviceQName, Class serviceClass) {
        return DescriptionFactoryImpl.createServiceDescription(wsdlURL, serviceQName, serviceClass, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceDescription createServiceDescription(URL wsdlURL, QName serviceQName, Class serviceClass, DescriptionBuilderComposite sparseComposite, Object sparseCompositeKey) {
        ConfigurationContext configContext = DescriptionFactory.createClientConfigurationFactory().getClientConfigurationContext();
        DescriptionKey key = new DescriptionKey(serviceQName, wsdlURL, serviceClass, configContext, DescriptionBuilderComposite.getServiceRefName(sparseComposite));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache Map = " + cache.toString()));
            if (key != null) {
                log.debug((Object)("Description Key = " + key.printKey()));
            }
        }
        ServiceDescription serviceDesc = null;
        ConfigurationContext configurationContext = configContext;
        synchronized (configurationContext) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check to see if ServiceDescription is found in cache");
            }
            if ((serviceDesc = cache.get(key)) != null && log.isDebugEnabled()) {
                log.debug((Object)"ServiceDescription found in the cache");
                log.debug((Object)serviceDesc.toString());
            }
            if (serviceDesc == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceDescription not found in the cache");
                    log.debug((Object)" creating new ServiceDescriptionImpl");
                }
                ServiceDescriptionImpl serviceDescImpl = null;
                if (sparseComposite != null) {
                    serviceDescImpl = new ServiceDescriptionImpl(wsdlURL, serviceQName, serviceClass, sparseComposite, sparseCompositeKey);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Client-side service description created with service class: " + serviceClass + ", Service QN: " + serviceQName + ", and DBC: " + sparseComposite));
                        log.debug((Object)serviceDescImpl.toString());
                    }
                } else {
                    serviceDescImpl = new ServiceDescriptionImpl(wsdlURL, serviceQName, serviceClass);
                }
                serviceDescImpl.setAxisConfigContext(configContext);
                serviceDesc = serviceDescImpl;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDescription created with WSDL URL: " + wsdlURL + "; QName: " + serviceQName + "; Class: " + serviceClass));
                    log.debug((Object)serviceDesc.toString());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Caching new ServiceDescription in the cache");
                }
                cache.put(key, serviceDesc);
            } else {
                ((ServiceDescriptionImpl)serviceDesc).getDescriptionBuilderComposite().setSparseComposite(sparseCompositeKey, sparseComposite);
            }
            ((ServiceDescriptionImpl)serviceDesc).registerUse();
        }
        return serviceDesc;
    }

    public static void clearServiceDescriptionCache() {
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServiceDescriptionCache(ConfigurationContext configContext) {
        if (configContext == null) {
            return;
        }
        ConfigurationContext configurationContext = configContext;
        synchronized (configurationContext) {
            Map<DescriptionKey, ServiceDescription> map = cache;
            synchronized (map) {
                Iterator<DescriptionKey> iter = cache.keySet().iterator();
                while (iter.hasNext()) {
                    DescriptionKey key = iter.next();
                    if (key.getConfigContext() != configContext) continue;
                    iter.remove();
                }
            }
        }
    }

    public static ServiceDescription createServiceDescription(Class serviceImplClass) {
        return DescriptionFactoryImpl.createServiceDescription(serviceImplClass, null);
    }

    public static ServiceDescription createServiceDescription(Class serviceImplClass, ConfigurationContext configContext) {
        ServiceDescription serviceDesc = null;
        if (serviceImplClass != null) {
            JavaClassToDBCConverter converter = new JavaClassToDBCConverter(serviceImplClass);
            HashMap<String, DescriptionBuilderComposite> dbcMap = converter.produceDBC();
            List<ServiceDescription> serviceDescList = DescriptionFactoryImpl.createServiceDescriptionFromDBCMap(dbcMap, configContext);
            if (serviceDescList != null && serviceDescList.size() > 0) {
                serviceDesc = serviceDescList.get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDescription created with class: " + serviceImplClass));
                    log.debug((Object)serviceDesc);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ServiceDesciption was not created for class: " + serviceImplClass));
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createServiceDescrErr", serviceImplClass.getName()));
            }
        }
        return serviceDesc;
    }

    public static List<ServiceDescription> createServiceDescriptionFromDBCMap(HashMap<String, DescriptionBuilderComposite> dbcMap, ConfigurationContext configContext, boolean performVaidation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createServiceDescriptionFromDBCMap(Hashmap<String,DescriptionBuilderComposite>,ConfigurationContext,boolean performVaidation ");
        }
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        for (DescriptionBuilderComposite serviceImplComposite : dbcMap.values()) {
            if (DescriptionFactoryImpl.isImpl(serviceImplComposite)) {
                Set<QName> sQNames = serviceImplComposite.getServiceQNames();
                if (sQNames == null || sQNames.isEmpty()) {
                    ServiceDescriptionImpl serviceDescription;
                    ServiceDescriptionValidator validator;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Adding ServiceDescription instances from composite");
                    }
                    if ((validator = new ServiceDescriptionValidator(serviceDescription = new ServiceDescriptionImpl(dbcMap, serviceImplComposite, configContext))).validate(performVaidation)) {
                        serviceDescriptionList.add(serviceDescription);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Service Description created from DescriptionComposite: " + serviceDescription));
                        continue;
                    }
                    String msg = Messages.getMessage("createSrvcDescrDBCMapErr", validator.toString(), serviceImplComposite.toString(), serviceDescription.toString());
                    throw ExceptionFactory.makeWebServiceException(msg);
                }
                for (QName sQName : sQNames) {
                    ServiceDescriptionImpl serviceDescription;
                    ServiceDescriptionValidator validator;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding ServiceDescription from service QName set for : " + sQName));
                    }
                    if ((validator = new ServiceDescriptionValidator(serviceDescription = new ServiceDescriptionImpl(dbcMap, serviceImplComposite, configContext, sQName))).validate(performVaidation)) {
                        serviceDescriptionList.add(serviceDescription);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Service Description created from DescriptionComposite: " + serviceDescription));
                        continue;
                    }
                    String msg = Messages.getMessage("createSrvcDescrDBCMapErr", validator.toString(), serviceImplComposite.toString(), serviceDescription.toString());
                    throw ExceptionFactory.makeWebServiceException(msg);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("DBC is not a service impl: " + serviceImplComposite.toString()));
        }
        return serviceDescriptionList;
    }

    public static List<ServiceDescription> createServiceDescriptionFromDBCMap(HashMap<String, DescriptionBuilderComposite> dbcMap, ConfigurationContext configContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createServiceDescriptionFromDBCMap(Hashmap<String,DescriptionBuilderComposite>,ConfigurationContext ");
        }
        return DescriptionFactoryImpl.createServiceDescriptionFromDBCMap(dbcMap, configContext, false);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, DescriptionFactory.UpdateType updateType, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, null, null, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, DescriptionFactory.UpdateType updateType, Object serviceDelegateKey, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, null, serviceDelegateKey, bindingId, endpointAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, DescriptionFactory.UpdateType updateType, DescriptionBuilderComposite composite, Object serviceDelegateKey, String bindingId, String endpointAddress) {
        EndpointDescription endpointDesc = null;
        ServiceDescription serviceDescription2 = serviceDescription;
        synchronized (serviceDescription2) {
            endpointDesc = ((ServiceDescriptionImpl)serviceDescription).updateEndpointDescription(sei, portQName, updateType, composite, serviceDelegateKey, bindingId, endpointAddress);
        }
        EndpointDescriptionValidator endpointValidator = new EndpointDescriptionValidator(endpointDesc);
        boolean isEndpointValid = endpointValidator.validate();
        if (!isEndpointValid) {
            String msg = Messages.getMessage("endpointDescriptionValidationErrors", endpointValidator.toString());
            throw ExceptionFactory.makeWebServiceException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("EndpointDescription updated: " + endpointDesc));
        }
        DescriptionFactoryImpl.setPropertiesOnEndpointDesc(endpointDesc, composite);
        return endpointDesc;
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, DescriptionFactory.UpdateType updateType, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, null, null, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, DescriptionFactory.UpdateType updateType, Object sparseCompositeKey, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, null, sparseCompositeKey, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, DescriptionFactory.UpdateType updateType, DescriptionBuilderComposite composite, Object sparseCompositeKey, String bindingId, String endpointAddress) {
        QName portQName = null;
        try {
            ServiceName serviceName = EndpointReferenceHelper.getServiceNameMetadata((EndpointReference)epr, (String)addressingNamespace);
            QName serviceQName = serviceDescription.getServiceQName();
            if (serviceName.getName() != null && !serviceQName.equals(serviceName.getName())) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceNameMismatch", serviceName.getName().toString(), serviceQName.toString()));
            }
            if (serviceName.getEndpointName() != null) {
                portQName = new QName(serviceQName.getNamespaceURI(), serviceName.getEndpointName());
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("updateEndpointError", e.getMessage()));
        }
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, composite, sparseCompositeKey, bindingId, endpointAddress);
    }

    public static ClientConfigurationFactory getClientConfigurationFactory() {
        return ClientConfigurationFactory.newInstance();
    }

    private static boolean isImpl(DescriptionBuilderComposite dbc) {
        return !dbc.isInterface() && (dbc.getWebServiceAnnot() != null || dbc.getWebServiceProviderAnnot() != null);
    }

    static void setPropertiesOnEndpointDesc(EndpointDescription endpointDesc, DescriptionBuilderComposite composite) {
        if (composite != null && composite.getProperties() != null && !composite.getProperties().isEmpty()) {
            for (String key : composite.getProperties().keySet()) {
                Object value = composite.getProperties().get(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting property from DBC onto EndpointDescription, key= " + key + ", value= " + value));
                }
                endpointDesc.setProperty(key, value);
            }
        }
    }

    public static ResolvedHandlersDescription createResolvedHandlersDescription() {
        return new ResolvedHandlersDescriptionImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeFromCache(ServiceDescriptionImpl svcDesc) {
        ConfigurationContext configContext;
        boolean svcDescRemoved = false;
        ConfigurationContext configurationContext = configContext = svcDesc.getAxisConfigContext();
        synchronized (configurationContext) {
            svcDesc.deregisterUse();
            if (svcDesc.isInUse()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceDescription still in use; not removed from cache");
                }
                svcDescRemoved = false;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceDescription not in use; will be removed from cache");
                }
                svcDescRemoved = true;
                Map<DescriptionKey, ServiceDescription> map = cache;
                synchronized (map) {
                    Set<Map.Entry<DescriptionKey, ServiceDescription>> cacheEntrySet = cache.entrySet();
                    Iterator<Map.Entry<DescriptionKey, ServiceDescription>> cacheEntryIterator = cacheEntrySet.iterator();
                    while (cacheEntryIterator.hasNext()) {
                        Map.Entry<DescriptionKey, ServiceDescription> entry = cacheEntryIterator.next();
                        ServiceDescription entrySvcDescValue = entry.getValue();
                        if (svcDesc != entrySvcDescValue) continue;
                        cacheEntryIterator.remove();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Removed service description from cache");
                    }
                }
            }
        }
        return svcDescRemoved;
    }
}

