/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.experimental.mediators.seda;

import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.experimental.mediators.seda.DefaultConsumer;
import org.apache.synapse.experimental.mediators.seda.SEDAQueue;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueConsumerPolicy;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueConsumerWorkerFactory;
import org.apache.synapse.experimental.mediators.seda.SEDAQueuePolicy;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueProducer;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueProducerPolicy;
import org.apache.synapse.mediators.AbstractMediator;

public class SEDAMediator
extends AbstractMediator
implements ManagedLifecycle {
    private SEDAQueueConsumerPolicy sedaQueueConsumerPolicy;
    private SEDAQueueProducerPolicy sedaQueueProducerPolicy;
    private SEDAQueuePolicy sedaQueuePolicy;
    private SEDAQueue sedaQueue;
    private SEDAQueueProducer sedaQueueProducer;
    private boolean initialized = false;
    private String consumer;

    public boolean mediate(MessageContext synCtx) {
        if (this.initialized) {
            this.sedaQueueProducer.produce(synCtx);
        }
        return false;
    }

    public void init(SynapseEnvironment se) {
        Mediator mediator = se.getSynapseConfiguration().getSequence(this.consumer);
        this.sedaQueue = new SEDAQueue(this.sedaQueuePolicy, new SEDAQueueConsumerWorkerFactory(this.sedaQueueConsumerPolicy, new DefaultConsumer(mediator)));
        this.sedaQueueProducer = new SEDAQueueProducer(this.sedaQueueProducerPolicy, this.sedaQueue);
        this.sedaQueue.init();
        this.initialized = true;
    }

    public void destroy() {
        this.sedaQueue.destory();
        this.initialized = false;
    }

    public SEDAQueueConsumerPolicy getSedaQueueConsumerPolicy() {
        return this.sedaQueueConsumerPolicy;
    }

    public void setSedaQueueConsumerPolicy(SEDAQueueConsumerPolicy sedaQueueConsumerPolicy) {
        this.sedaQueueConsumerPolicy = sedaQueueConsumerPolicy;
    }

    public SEDAQueueProducerPolicy getSedaQueueProducerPolicy() {
        return this.sedaQueueProducerPolicy;
    }

    public void setSedaQueueProducerPolicy(SEDAQueueProducerPolicy sedaQueueProducerPolicy) {
        this.sedaQueueProducerPolicy = sedaQueueProducerPolicy;
    }

    public SEDAQueuePolicy getSedaQueuePolicy() {
        return this.sedaQueuePolicy;
    }

    public void setSedaQueuePolicy(SEDAQueuePolicy sedaQueuePolicy) {
        this.sedaQueuePolicy = sedaQueuePolicy;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public void setConsumer(String consumer) {
        this.consumer = consumer;
    }
}

