/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.resequence;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processors.ScheduledMessageProcessor;
import org.apache.synapse.message.processors.resequence.ResequencingJob;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ResequencingProcessor
extends ScheduledMessageProcessor {
    private static final Log log = LogFactory.getLog(ResequencingProcessor.class);
    private AtomicBoolean active = new AtomicBoolean(true);
    private AtomicBoolean initSeqNo = new AtomicBoolean(false);
    private AtomicInteger nextSeqNo = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicInteger requiredInitMsgs = new AtomicInteger(4);
    private AtomicInteger requiredInitMsgsDelay = new AtomicInteger(5);
    public static final String SEQUENCE_NUMBER_XPATH = "seqNumXpath";
    public static final String NEXT_SEQUENCE = "nextEsbSequence";
    public static final String REQ_INIT_MSGS = "requiredInitMessages";
    public static final String REQ_INIT_MSGS_DELAY = "requiredInitMessagesDelay";
    public static final int STARTING_NUMBER_INIT_DELAY = 6000;
    public int tried = 0;
    public static final String DELETE_DUPLICATES = "deleteDuplicateMessages";
    private AtomicBoolean deleteDuplicates = new AtomicBoolean(false);

    @Override
    public void init(SynapseEnvironment se) {
        super.init(se);
        this.findFirstSeqNum();
    }

    private void findFirstSeqNum() {
        MessageStore store = this.configuration.getMessageStore(this.messageStore);
        SynapseXPath seqNoxPath = null;
        if (this.parameters != null && this.parameters.get(SEQUENCE_NUMBER_XPATH) != null) {
            seqNoxPath = (SynapseXPath)((Object)this.parameters.get(SEQUENCE_NUMBER_XPATH));
        }
        int messageIndex = 0;
        while (true) {
            try {
                MessageContext messageContext = store.get(messageIndex);
                if (messageContext == null) break;
                int sequenceNo = Integer.parseInt(seqNoxPath.stringValueOf(messageContext));
                if (sequenceNo < this.getNextSeqNo()) {
                    this.setNextSeqNo(sequenceNo);
                    this.initSeqNo = new AtomicBoolean(true);
                }
            }
            catch (NumberFormatException e) {
                ResequencingProcessor.handleException("Invalid xPath parameter - Sequence number specified is not an integer ");
            }
            catch (Exception e) {
                ResequencingProcessor.handleException("Failed to initialize starting sequence number at startup: " + e.getMessage());
            }
            ++messageIndex;
        }
    }

    @Override
    protected JobBuilder getJobBuilder() {
        return JobBuilder.newJob(ResequencingJob.class).withIdentity(this.name + "-resequencing-job", "synapse.message.processor.quartz");
    }

    @Override
    protected JobDataMap getJobDataMap() {
        JobDataMap jdm = new JobDataMap();
        jdm.put("processor.instance", (Object)this);
        return jdm;
    }

    @Override
    public void destroy() {
        try {
            this.scheduler.deleteJob(new JobKey(this.name + "-resequencing-job", "synapse.message.processor.quartz"));
            this.scheduler.shutdown();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public void activate() {
        this.active.set(true);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void deactivate() {
        this.active.set(false);
    }

    public synchronized int getNextSeqNo() {
        return this.nextSeqNo.get();
    }

    public synchronized void setNextSeqNo(int value) {
        this.nextSeqNo.set(value);
    }

    public synchronized void incrementNextSeqNo() {
        this.nextSeqNo.incrementAndGet();
    }

    public AtomicBoolean isInitSeqNo() {
        return this.initSeqNo;
    }

    public void setInitSeqNo(AtomicBoolean initSeqNo) {
        this.initSeqNo = initSeqNo;
    }

    public AtomicInteger getRequiredInitMsgs() {
        return this.requiredInitMsgs;
    }

    public void setRequiredInitMsgs(AtomicInteger requiredInitMsgs) {
        this.requiredInitMsgs = requiredInitMsgs;
    }

    public AtomicInteger getRequiredInitMsgsDelay() {
        return this.requiredInitMsgsDelay;
    }

    public void setRequiredInitMsgsDelay(AtomicInteger requiredInitMsgsDelay) {
        this.requiredInitMsgsDelay = requiredInitMsgsDelay;
    }

    public boolean getDeleteDuplicates() {
        return this.deleteDuplicates.get();
    }

    public void setDeleteDuplicates(AtomicBoolean deleteDuplicates) {
        this.deleteDuplicates = deleteDuplicates;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

