/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.message.databinding.DataSourceBlock;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.WrappedDataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(ApplicationXMLFormatter.class);
    private final String contentType;

    public DataSourceFormatter(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        throw new UnsupportedOperationException("FIXME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        block14: {
            AttachmentsAdapter attachments = (AttachmentsAdapter)messageContext.getProperty("javax.xml.ws.binding.attachments.outbound");
            try {
                DataSource busObject;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"start writeTo()");
                }
                OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
                try {
                    busObject = (DataSource)((DataSourceBlock)((OMSourcedElement)omElement).getDataSource()).getBusinessObject(true);
                }
                catch (XMLStreamException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
                DataHandler dataHandler = new DataHandler(busObject);
                if (attachments != null && !attachments.isEmpty()) {
                    OMMultipartWriter mpw = new OMMultipartWriter(outputStream, format);
                    if (!dataHandler.getContentType().equals(this.contentType)) {
                        dataHandler = new WrappedDataHandler(dataHandler, this.contentType);
                    }
                    try {
                        mpw.writePart(dataHandler, format.getRootContentId());
                        for (String cid : attachments.keySet()) {
                            mpw.writePart(attachments.get(cid), cid);
                        }
                        mpw.complete();
                        outputStream.flush();
                        break block14;
                    }
                    catch (IOException ex) {
                        throw AxisFault.makeFault((Throwable)ex);
                    }
                }
                try {
                    dataHandler.writeTo(outputStream);
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"end writeTo()");
                }
            }
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        AttachmentsAdapter attachments = (AttachmentsAdapter)messageContext.getProperty("javax.xml.ws.binding.attachments.outbound");
        if (attachments != null && !attachments.isEmpty()) {
            return format.getContentTypeForSwA(this.contentType);
        }
        return this.contentType;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)messageContext, (boolean)false);
        return targetURL;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }
}

