/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixCell;
import org.apache.sysml.runtime.matrix.data.TripleIndexes;
import org.apache.sysml.runtime.matrix.mapred.MMRJMRMapper;
import org.apache.sysml.runtime.matrix.mapred.MMRJMRReducer;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class MMRJMR {
    private static final Log LOG = LogFactory.getLog(MMRJMR.class.getName());

    private MMRJMR() {
    }

    public static JobReturn runJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, String instructionsInMapper, String aggInstructionsInReducer, String aggBinInstrctions, String otherInstructionsInReducer, int numReducers, int replication, byte[] resultIndexes, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        JobConf job = new JobConf(MMRJMR.class);
        job.setJobName("MMRJ-MR");
        if (numReducers <= 0) {
            throw new Exception("MMRJ-MR has to have at least one reduce task!");
        }
        boolean inBlockRepresentation = MRJobConfiguration.deriveRepresentation(inputInfos);
        MRJobConfiguration.setMatrixValueClass(job, inBlockRepresentation);
        byte[] realIndexes = new byte[inputs.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        MRJobConfiguration.setUpMultipleInputs(job, realIndexes, inputs, inputInfos, brlens, bclens, true, inBlockRepresentation ? MRJobConfiguration.ConvertTarget.BLOCK : MRJobConfiguration.ConvertTarget.CELL);
        MRJobConfiguration.setMatricesDimensions(job, realIndexes, rlens, clens);
        MRJobConfiguration.setBlocksSizes(job, realIndexes, brlens, bclens);
        MRJobConfiguration.setInstructionsInMapper(job, instructionsInMapper);
        MRJobConfiguration.setAggregateInstructions(job, aggInstructionsInReducer);
        MRJobConfiguration.setAggregateBinaryInstructions(job, aggBinInstrctions);
        MRJobConfiguration.setInstructionsInReducer(job, otherInstructionsInReducer);
        job.setInt("dfs.replication", replication);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        DMLAppMasterUtils.setupMRJobRemoteMaxMemory(job, config);
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, instructionsInMapper, aggInstructionsInReducer, aggBinInstrctions, resultIndexes);
        MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, realIndexes, instructionsInMapper, aggInstructionsInReducer, aggBinInstrctions, otherInstructionsInReducer, resultIndexes, mapoutputIndexes, false);
        MatrixCharacteristics[] stats = ret.stats;
        MRJobConfiguration.setNumReducers(job, ret.numReducerGroups, numReducers);
        if (LOG.isTraceEnabled()) {
            inst.printCompleteMRJobInstruction(stats);
        }
        byte[] dimsUnknown = new byte[resultIndexes.length];
        for (int i = 0; i < resultIndexes.length; ++i) {
            dimsUnknown[i] = stats[i].getRows() == -1L || stats[i].getCols() == -1L ? (byte)1 : 0;
        }
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, dimsUnknown, outputs, outputInfos, inBlockRepresentation);
        job.setMapperClass(MMRJMRMapper.class);
        job.setMapOutputKeyClass(TripleIndexes.class);
        if (inBlockRepresentation) {
            job.setMapOutputValueClass(TaggedMatrixBlock.class);
        } else {
            job.setMapOutputValueClass(TaggedMatrixCell.class);
        }
        job.setOutputKeyComparatorClass(TripleIndexes.Comparator.class);
        job.setPartitionerClass(TripleIndexes.FirstTwoIndexesPartitioner.class);
        job.setReducerClass(MMRJMRReducer.class);
        MatrixCharacteristics[] inputStats = new MatrixCharacteristics[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputStats[i] = new MatrixCharacteristics(rlens[i], clens[i], brlens[i], bclens[i]);
        }
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runjob = JobClient.runJob(job);
        Counters.Group group = runjob.getCounters().getGroup("nonzeros");
        for (int i = 0; i < resultIndexes.length; ++i) {
            stats[i].setNonZeros(group.getCounter(Integer.toString(i)));
        }
        return new JobReturn(stats, outputInfos, runjob.isSuccessful());
    }
}

