/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.QDictionary;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.MemoryEstimates;

public class ColGroupSizes {
    protected static final Log LOG = LogFactory.getLog((String)ColGroupSizes.class.getName());

    public static long estimateInMemorySizeGroup(int nrColumns) {
        long size = 0L;
        size += 16L;
        size += 4L;
        ++size;
        size += 3L;
        return size += MemoryEstimates.intArrayCost(nrColumns);
    }

    public static long estimateInMemorySizeGroupValue(int nrColumns, int nrValues, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroup(nrColumns);
        size += 8L;
        size = lossy ? (size += QDictionary.getInMemorySize(nrValues)) : (size += Dictionary.getInMemorySize(nrValues));
        return size;
    }

    public static long estimateInMemorySizeDDC(int nrCols, int uniqueVals, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrCols, uniqueVals, lossy);
        return size;
    }

    public static long estimateInMemorySizeDDC1(int nrCols, int uniqueVals, int dataLength, boolean lossy) {
        if (uniqueVals > 255) {
            return Long.MAX_VALUE;
        }
        long size = ColGroupSizes.estimateInMemorySizeDDC(nrCols, uniqueVals, lossy);
        return size += MemoryEstimates.byteArrayCost(dataLength);
    }

    public static long estimateInMemorySizeDDC2(int nrCols, int uniqueVals, int dataLength, boolean lossy) {
        if (uniqueVals > 65535) {
            return Long.MAX_VALUE;
        }
        long size = ColGroupSizes.estimateInMemorySizeDDC(nrCols, uniqueVals, lossy);
        return size += MemoryEstimates.charArrayCost(dataLength);
    }

    public static long estimateInMemorySizeOffset(int nrColumns, int nrValues, int pointers, int offsetLength, boolean lossy) {
        long size = ColGroupSizes.estimateInMemorySizeGroupValue(nrColumns, nrValues, lossy);
        size += MemoryEstimates.intArrayCost(pointers);
        return size += MemoryEstimates.charArrayCost(offsetLength);
    }

    public static long estimateInMemorySizeOLE(int nrColumns, int nrValues, int offsetLength, int nrRows, boolean lossy) {
        nrColumns = nrColumns > 0 ? nrColumns : 1;
        long size = 0L;
        size = ColGroupSizes.estimateInMemorySizeOffset(nrColumns, nrValues, nrValues / nrColumns + 1, offsetLength += nrRows / 65536 * 2, lossy);
        if (nrRows > 131072) {
            size += MemoryEstimates.intArrayCost(nrValues / nrColumns);
        }
        return size;
    }

    public static long estimateInMemorySizeRLE(int nrColumns, int nrValues, int nrRuns, int nrRows, boolean lossy) {
        nrColumns = nrColumns > 0 ? nrColumns : 1;
        int offsetLength = nrRuns * 2;
        long size = ColGroupSizes.estimateInMemorySizeOffset(nrColumns, nrValues, nrValues / nrColumns + 1, offsetLength, lossy);
        return size;
    }

    public static long estimateInMemorySizeUncompressed(int nrRows, int nrColumns, double sparsity) {
        long size = 0L;
        size += ColGroupSizes.estimateInMemorySizeGroup(nrColumns);
        size += 8L;
        return size += MatrixBlock.estimateSizeInMemory(nrRows, nrColumns, sparsity);
    }
}

