/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class GetStoragePolicies
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        if (!(fs instanceof DistributedFileSystem)) {
            System.err.println("GetStoragePolicies can only be used against HDFS. Please check the default FileSystem setting in your configuration.");
            return 1;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            BlockStoragePolicy[] policies = dfs.getStoragePolicies();
            System.out.println("Block Storage Policies:");
            for (BlockStoragePolicy policy : policies) {
                if (policy == null) continue;
                System.out.println("\t" + policy);
            }
        }
        catch (IOException e) {
            String[] content = e.getLocalizedMessage().split("\n");
            System.err.println("GetStoragePolicies: " + content[0]);
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int rc = ToolRunner.run((Tool)new GetStoragePolicies(), (String[])args);
        System.exit(rc);
    }
}

