/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.util;

import java.util.HashSet;
import java.util.Set;
import org.spark_project.jetty.util.Predicate;

public class IncludeExclude<ITEM> {
    private final Set<ITEM> _includes;
    private final Predicate<ITEM> _includePredicate;
    private final Set<ITEM> _excludes;
    private final Predicate<ITEM> _excludePredicate;

    public IncludeExclude() {
        this(HashSet.class);
    }

    public <SET extends Set<ITEM>> IncludeExclude(Class<SET> setClass) {
        try {
            this._includes = (Set)setClass.newInstance();
            this._excludes = (Set)setClass.newInstance();
            this._includePredicate = this._includes instanceof Predicate ? (Predicate)((Object)this._includes) : new SetContainsPredicate<ITEM>(this._includes);
            this._excludePredicate = this._excludes instanceof Predicate ? (Predicate)((Object)this._excludes) : new SetContainsPredicate<ITEM>(this._excludes);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public <SET extends Set<ITEM>> IncludeExclude(Set<ITEM> includeSet, Predicate<ITEM> includePredicate, Set<ITEM> excludeSet, Predicate<ITEM> excludePredicate) {
        this._includes = includeSet;
        this._includePredicate = includePredicate;
        this._excludes = excludeSet;
        this._excludePredicate = excludePredicate;
    }

    public void include(ITEM element) {
        this._includes.add(element);
    }

    public void include(ITEM ... element) {
        for (ITEM e : element) {
            this._includes.add(e);
        }
    }

    public void exclude(ITEM element) {
        this._excludes.add(element);
    }

    public void exclude(ITEM ... element) {
        for (ITEM e : element) {
            this._excludes.add(e);
        }
    }

    public boolean matches(ITEM e) {
        if (!this._includes.isEmpty() && !this._includePredicate.test(e)) {
            return false;
        }
        return !this._excludePredicate.test(e);
    }

    public int size() {
        return this._includes.size() + this._excludes.size();
    }

    public Set<ITEM> getIncluded() {
        return this._includes;
    }

    public Set<ITEM> getExcluded() {
        return this._excludes;
    }

    public void clear() {
        this._includes.clear();
        this._excludes.clear();
    }

    public String toString() {
        return String.format("%s@%x{i=%s,ip=%s,e=%s,ep=%s}", this.getClass().getSimpleName(), this.hashCode(), this._includes, this._includePredicate, this._excludes, this._excludePredicate);
    }

    private static class SetContainsPredicate<ITEM>
    implements Predicate<ITEM> {
        private final Set<ITEM> set;

        public SetContainsPredicate(Set<ITEM> set) {
            this.set = set;
        }

        @Override
        public boolean test(ITEM item) {
            return this.set.contains(item);
        }
    }
}

