/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class QuantileSortFEDInstruction
extends UnaryFEDInstruction {
    private QuantileSortFEDInstruction(CPOperand in, CPOperand out, String opcode, String istr) {
        this(in, null, out, opcode, istr);
    }

    private QuantileSortFEDInstruction(CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.QSort, null, in1, in2, out, opcode, istr);
    }

    public static QuantileSortFEDInstruction parseInstruction(String str) {
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qsort")) {
            if (parts.length == 3) {
                QuantileSortFEDInstruction.parseUnaryInstruction(str, in1, out);
                return new QuantileSortFEDInstruction(in1, out, opcode, str);
            }
            if (parts.length == 4) {
                in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                QuantileSortFEDInstruction.parseUnaryInstruction(str, in1, in2, out);
                return new QuantileSortFEDInstruction(in1, in2, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a QuantileSortFEDInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap fedMapping = in.getFedMapping();
        long varID = FederationUtils.getNextFedDataID();
        FederationMap sortedMapping = fedMapping.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response;
                MatrixBlock wtBlock = null;
                if (this.input2 != null) {
                    wtBlock = ec.getMatrixInput(this.input2.getName());
                }
                if (!(response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetSorted(data.getVarID(), varID, wtBlock))).get()).isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        MatrixObject sorted = ec.getMatrixObject(this.output);
        sorted.getDataCharacteristics().set(in.getDataCharacteristics());
        sorted.setFedMapping(sortedMapping);
    }

    private static class GetSorted
    extends FederatedUDF {
        private static final long serialVersionUID = -1969015577260167645L;
        private final long _outputID;
        private final MatrixBlock _weights;

        protected GetSorted(long input, long outputID, MatrixBlock weights) {
            super(new long[]{input});
            this._outputID = outputID;
            this._weights = weights;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            MatrixBlock res = mb.sortOperations(this._weights, new MatrixBlock());
            MatrixObject mout = ExecutionContext.createMatrixObject(res);
            ec.setVariable(String.valueOf(this._outputID), mout);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

