/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers;

import io.netty.handler.codec.http.FullHttpResponse;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.IController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.Request;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.Response;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.MapperService;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.WorkerService;

public class WorkerController
implements IController {
    private final WorkerService _workerService = new WorkerService();

    @Override
    public FullHttpResponse create(Request request) {
        BaseEntityModel model = MapperService.getModelFromBody(request);
        this._workerService.create(model);
        return Response.ok("Success");
    }

    @Override
    public FullHttpResponse update(Request request, Long objectId) {
        BaseEntityModel model = MapperService.getModelFromBody(request);
        this._workerService.update(model);
        return Response.ok("Success");
    }

    @Override
    public FullHttpResponse delete(Request request, Long objectId) {
        this._workerService.remove(objectId);
        return Response.ok("Success");
    }

    @Override
    public FullHttpResponse get(Request request, Long objectId) {
        BaseEntityModel result = this._workerService.get(objectId);
        if (result == null) {
            return Response.notFound("No such worker can be found");
        }
        return Response.ok(result.toString());
    }

    @Override
    public FullHttpResponse getAll(Request request) {
        List<BaseEntityModel> workers = this._workerService.getAll();
        if (workers.isEmpty()) {
            return Response.notFound("No workers can be found");
        }
        return Response.ok(workers.toString());
    }
}

