/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.data.BasicTensorBlock;
import org.apache.sysds.runtime.data.DataTensorBlock;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.MatrixReaderFactory;
import org.apache.sysds.runtime.io.MatrixWriter;
import org.apache.sysds.runtime.io.MatrixWriterFactory;
import org.apache.sysds.runtime.io.ReadProperties;
import org.apache.sysds.runtime.io.TensorReader;
import org.apache.sysds.runtime.io.TensorReaderFactory;
import org.apache.sysds.runtime.io.TensorWriter;
import org.apache.sysds.runtime.io.TensorWriterFactory;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DataConverter {
    private static final String DELIM = " ";

    public static void writeMatrixToHDFS(MatrixBlock mat, String dir, Types.FileFormat fmt, DataCharacteristics dc) throws IOException {
        DataConverter.writeMatrixToHDFS(mat, dir, fmt, dc, -1, null);
    }

    public static void writeMatrixToHDFS(MatrixBlock mat, String dir, Types.FileFormat fmt, DataCharacteristics dc, int replication, FileFormatProperties formatProperties) throws IOException {
        DataConverter.writeMatrixToHDFS(mat, dir, fmt, dc, -1, null, false);
    }

    public static void writeMatrixToHDFS(MatrixBlock mat, String dir, Types.FileFormat fmt, DataCharacteristics dc, int replication, FileFormatProperties formatProperties, boolean diag) throws IOException {
        MatrixWriter writer = MatrixWriterFactory.createMatrixWriter(fmt, replication, formatProperties);
        writer.writeMatrixToHDFS(mat, dir, dc.getRows(), dc.getCols(), dc.getBlocksize(), dc.getNonZeros(), diag);
    }

    public static void writeTensorToHDFS(TensorBlock tensor, String dir, Types.FileFormat fmt, DataCharacteristics dc) throws IOException {
        TensorWriter writer = TensorWriterFactory.createTensorWriter(fmt);
        int blen = dc.getBlocksize();
        writer.writeTensorToHDFS(tensor, dir, blen);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen, boolean localFS) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.fmt = fmt;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.blen = blen;
        prop.localFS = localFS;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.fmt = fmt;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.blen = blen;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen, long expectedNnz) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.fmt = fmt;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.blen = blen;
        prop.expectedNnz = expectedNnz;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen, long expectedNnz, boolean localFS) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.fmt = fmt;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.blen = blen;
        prop.expectedNnz = expectedNnz;
        prop.localFS = localFS;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static MatrixBlock readMatrixFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen, long expectedNnz, FileFormatProperties formatProperties) throws IOException {
        ReadProperties prop = new ReadProperties();
        prop.path = dir;
        prop.fmt = fmt;
        prop.rlen = rlen;
        prop.clen = clen;
        prop.blen = blen;
        prop.expectedNnz = expectedNnz;
        prop.formatProperties = formatProperties;
        return DataConverter.readMatrixFromHDFS(prop);
    }

    public static TensorBlock readTensorFromHDFS(String dir, Types.FileFormat fmt, long[] dims, int blen, Types.ValueType[] schema) throws IOException {
        TensorBlock ret;
        try {
            TensorReader reader = TensorReaderFactory.createTensorReader(fmt);
            ret = reader.readTensorFromHDFS(dir, dims, blen, schema);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public static MatrixBlock readMatrixFromHDFS(ReadProperties prop) throws IOException {
        MatrixBlock ret = null;
        try {
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(prop);
            ret = reader.readMatrixFromHDFS(prop.path, prop.rlen, prop.clen, prop.blen, prop.expectedNnz);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public static double[][] convertToDoubleMatrix(MatrixBlock mb) {
        double[][] ret;
        block6: {
            int rows = mb.getNumRows();
            int cols = mb.getNumColumns();
            ret = new double[rows][cols];
            if (mb instanceof CompressedMatrixBlock) {
                mb = ((CompressedMatrixBlock)mb).getUncompressed("convert to Double Matrix");
            }
            if (mb.getNonZeros() <= 0L) break block6;
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret[cell.getI()][cell.getJ()] = cell.getV();
                }
            } else {
                double[] a = mb.getDenseBlockValues();
                int ix = 0;
                for (int i = 0; i < rows; ++i) {
                    int j = 0;
                    while (j < cols) {
                        ret[i][j] = a[ix];
                        ++j;
                        ++ix;
                    }
                }
            }
        }
        return ret;
    }

    public static boolean[] convertToBooleanVector(MatrixBlock mb) {
        boolean[] ret;
        block5: {
            int rows = mb.getNumRows();
            int cols = mb.getNumColumns();
            ret = new boolean[rows * cols];
            if (mb.getNonZeros() <= 0L) break block5;
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret[cell.getI() * cols + cell.getJ()] = cell.getV() != 0.0;
                }
            } else {
                int cix = 0;
                for (int i = 0; i < rows; ++i) {
                    int j = 0;
                    while (j < cols) {
                        ret[cix] = mb.getValueDenseUnsafe(i, j) != 0.0;
                        ++j;
                        ++cix;
                    }
                }
            }
        }
        return ret;
    }

    public static int[] convertVectorToIndexList(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        if (mb.isEmpty()) {
            return null;
        }
        if (mb.isInSparseFormat()) {
            if (rows == 1) {
                SparseBlock sb = mb.getSparseBlock();
                int[] tmp = sb.indexes(0);
                return tmp.length == sb.size(0) ? tmp : Arrays.copyOfRange(tmp, 0, sb.size(0));
            }
            int index = 0;
            int[] indices = new int[(int)mb.getNonZeros()];
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                if (cell.getV() == 0.0) continue;
                indices[index++] = cell.getI() * cols + cell.getJ();
            }
            return indices;
        }
        int[] indices = new int[(int)mb.getNonZeros()];
        int aix = 0;
        int cix = 0;
        for (int i = 0; i < rows; ++i) {
            int j = 0;
            while (j < cols) {
                if (mb.getValueDenseUnsafe(i, j) != 0.0) {
                    indices[cix++] = aix;
                }
                ++j;
                ++aix;
            }
        }
        return indices;
    }

    public static int[] convertToIntVector(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        int[] ret = new int[rows * cols];
        if (mb.isEmptyBlock(false)) {
            return ret;
        }
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                ret[cell.getI() * cols + cell.getJ()] = (int)cell.getV();
            }
        } else {
            int cix = 0;
            for (int i = 0; i < rows; ++i) {
                int j = 0;
                while (j < cols) {
                    ret[cix] = (int)mb.getValueDenseUnsafe(i, j);
                    ++j;
                    ++cix;
                }
            }
        }
        return ret;
    }

    public static long[] convertToLongVector(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        long[] ret = new long[rows * cols];
        if (mb.isEmptyBlock(false)) {
            return ret;
        }
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                ret[cell.getI() * cols + cell.getJ()] = (int)cell.getV();
            }
        } else {
            int cix = 0;
            for (int i = 0; i < rows; ++i) {
                int j = 0;
                while (j < cols) {
                    ret[cix] = (int)mb.getValueDenseUnsafe(i, j);
                    ++j;
                    ++cix;
                }
            }
        }
        return ret;
    }

    public static DenseBlock convertToDenseBlock(MatrixBlock mb) {
        return DataConverter.convertToDenseBlock(mb, true);
    }

    public static DenseBlock convertToDenseBlock(MatrixBlock mb, boolean deep) {
        DenseBlock ret;
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        DenseBlock denseBlock = ret = !mb.isInSparseFormat() && mb.isAllocated() && !deep ? mb.getDenseBlock() : DenseBlockFactory.createDenseBlock(rows, cols);
        if (!mb.isEmptyBlock(false)) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret.set(cell.getI(), cell.getJ(), cell.getV());
                }
            } else if (deep) {
                ret.set(mb.getDenseBlock());
            }
        }
        return ret;
    }

    public static double[] convertToDoubleVector(MatrixBlock mb) {
        return DataConverter.convertToDoubleVector(mb, true);
    }

    public static double[] convertToDoubleVector(MatrixBlock mb, boolean deep) {
        return DataConverter.convertToDoubleVector(mb, deep, false);
    }

    public static double[] convertToDoubleVector(MatrixBlock mb, boolean deep, boolean allowNull) {
        double[] ret;
        if (mb.isEmpty() && allowNull) {
            return null;
        }
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        double[] dArray = ret = !mb.isInSparseFormat() && mb.isAllocated() && !deep ? mb.getDenseBlockValues() : new double[rows * cols];
        if (!mb.isEmptyBlock(false)) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret[cell.getI() * cols + cell.getJ()] = cell.getV();
                }
            } else if (deep) {
                System.arraycopy(mb.getDenseBlockValues(), 0, ret, 0, rows * cols);
            }
        }
        return ret;
    }

    public static List<Double> convertToDoubleList(MatrixBlock mb) {
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        long nnz = mb.getNonZeros();
        ArrayList<Double> ret = new ArrayList<Double>();
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                ret.add(cell.getV());
            }
            for (long i = nnz; i < (long)rows * (long)cols; ++i) {
                ret.add(0.0);
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ret.add(mb.getValueDenseUnsafe(i, j));
                }
            }
        }
        return ret;
    }

    public static MatrixBlock convertToMatrixBlock(double[][] data) {
        int rows = data.length;
        int cols = rows > 0 ? data[0].length : 0;
        MatrixBlock mb = new MatrixBlock(rows, cols, false);
        try {
            mb.init(data, rows, cols);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mb.examSparsity();
        return mb;
    }

    public static MatrixBlock convertToMatrixBlock(int[][] data) {
        int rows = data.length;
        int cols = rows > 0 ? data[0].length : 0;
        MatrixBlock res = new MatrixBlock(rows, cols, false);
        for (int row = 0; row < data.length; ++row) {
            for (int col = 0; col < cols; ++col) {
                double v = data[row][col];
                if (v == 0.0) continue;
                res.appendValue(row, col, v);
            }
        }
        return res;
    }

    public static MatrixBlock convertToMatrixBlock(double[] data, boolean columnVector) {
        int rows = columnVector ? data.length : 1;
        int cols = columnVector ? 1 : data.length;
        MatrixBlock mb = new MatrixBlock(rows, cols, false);
        mb.init(data, rows, cols);
        mb.examSparsity();
        return mb;
    }

    public static MatrixBlock convertToMatrixBlock(HashMap<MatrixIndexes, Double> map) {
        long nrows = 0L;
        long ncols = 0L;
        for (MatrixIndexes index : map.keySet()) {
            nrows = Math.max(nrows, index.getRowIndex());
            ncols = Math.max(ncols, index.getColumnIndex());
        }
        return DataConverter.convertToMatrixBlock(map, (int)nrows, (int)ncols);
    }

    public static MatrixBlock convertToMatrixBlock(HashMap<MatrixIndexes, Double> map, int rlen, int clen) {
        int nnz = map.size();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz);
        MatrixBlock mb = new MatrixBlock(rlen, clen, sparse, nnz);
        if (sparse) {
            for (Map.Entry<MatrixIndexes, Double> e : map.entrySet()) {
                MatrixIndexes index = e.getKey();
                double value = e.getValue();
                int rix = (int)index.getRowIndex();
                int cix = (int)index.getColumnIndex();
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.appendValue(rix - 1, cix - 1, value);
            }
            mb.sortSparseRows();
        } else {
            for (Map.Entry<MatrixIndexes, Double> e : map.entrySet()) {
                MatrixIndexes index = e.getKey();
                double value = e.getValue();
                int rix = (int)index.getRowIndex();
                int cix = (int)index.getColumnIndex();
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.quickSetValue(rix - 1, cix - 1, value);
            }
        }
        return mb;
    }

    public static MatrixBlock convertToMatrixBlock(CTableMap map) {
        int nrows = (int)map.getMaxRow();
        int ncols = (int)map.getMaxColumn();
        return DataConverter.convertToMatrixBlock(map, nrows, ncols);
    }

    public static MatrixBlock convertToMatrixBlock(CTableMap map, int rlen, int clen) {
        return map.toMatrixBlock(rlen, clen);
    }

    public static MatrixBlock convertToMatrixBlock(FrameBlock frame) {
        int m = frame.getNumRows();
        int n = frame.getNumColumns();
        MatrixBlock mb = new MatrixBlock(m, n, false);
        mb.allocateDenseBlock();
        Types.ValueType[] schema = frame.getSchema();
        int dFreq = UtilFunctions.frequency(schema, Types.ValueType.FP64);
        if (dFreq == schema.length) {
            double[][] a = new double[n][];
            for (int j = 0; j < n; ++j) {
                a[j] = (double[])frame.getColumnData(j);
            }
            int blocksizeIJ = 32;
            long lnnz = 0L;
            if (mb.getDenseBlock().isContiguous()) {
                double[] c = mb.getDenseBlockValues();
                for (int bi = 0; bi < m; bi += blocksizeIJ) {
                    for (int bj = 0; bj < n; bj += blocksizeIJ) {
                        int bimin = Math.min(bi + blocksizeIJ, m);
                        int bjmin = Math.min(bj + blocksizeIJ, n);
                        int i = bi;
                        int aix = bi * n;
                        while (i < bimin) {
                            for (int j = bj; j < bjmin; ++j) {
                                double d = a[j][i];
                                c[aix + j] = d;
                                lnnz += d != 0.0 ? 1L : 0L;
                            }
                            ++i;
                            aix += n;
                        }
                    }
                }
            } else {
                DenseBlock c = mb.getDenseBlock();
                for (int bi = 0; bi < m; bi += blocksizeIJ) {
                    for (int bj = 0; bj < n; bj += blocksizeIJ) {
                        int bimin = Math.min(bi + blocksizeIJ, m);
                        int bjmin = Math.min(bj + blocksizeIJ, n);
                        for (int i = bi; i < bimin; ++i) {
                            double[] cvals = c.values(i);
                            int cpos = c.pos(i);
                            for (int j = bj; j < bjmin; ++j) {
                                double d = a[j][i];
                                cvals[cpos + j] = d;
                                lnnz += d != 0.0 ? 1L : 0L;
                            }
                        }
                    }
                }
            }
            mb.setNonZeros(lnnz);
        } else {
            for (int i = 0; i < frame.getNumRows(); ++i) {
                for (int j = 0; j < frame.getNumColumns(); ++j) {
                    mb.appendValue(i, j, UtilFunctions.objectToDouble(schema[j], frame.get(i, j)));
                }
            }
        }
        mb.examSparsity();
        return mb;
    }

    public static String[][] convertToStringFrame(FrameBlock frame) {
        String[][] ret = new String[frame.getNumRows()][];
        Iterator<String[]> iter = frame.getStringRowIterator();
        int i = 0;
        while (iter.hasNext()) {
            ret[i] = (String[])iter.next().clone();
            ++i;
        }
        return ret;
    }

    public static FrameBlock convertToFrameBlock(String[][] data) {
        if (data == null || data.length == 0) {
            return new FrameBlock();
        }
        Types.ValueType[] schema = UtilFunctions.nCopies(data[0].length, Types.ValueType.STRING);
        return DataConverter.convertToFrameBlock(data, schema);
    }

    public static FrameBlock convertToFrameBlock(String[][] data, Types.ValueType[] schema) {
        if (data == null || data.length == 0) {
            return new FrameBlock();
        }
        return new FrameBlock(schema, data);
    }

    public static FrameBlock convertToFrameBlock(String[][] data, Types.ValueType[] schema, String[] colnames) {
        if (data == null || data.length == 0) {
            return new FrameBlock();
        }
        return new FrameBlock(schema, colnames, data);
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb) {
        return DataConverter.convertToFrameBlock(mb, Types.ValueType.FP64);
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Types.ValueType vt) {
        Types.ValueType[] schema = UtilFunctions.nCopies(mb.getNumColumns(), vt);
        return DataConverter.convertToFrameBlock(mb, schema);
    }

    public static FrameBlock convertToFrameBlock(MatrixBlock mb, Types.ValueType[] schema) {
        FrameBlock frame = new FrameBlock(schema);
        Object[] row = new Object[mb.getNumColumns()];
        if (mb.isInSparseFormat()) {
            SparseBlock sblock = mb.getSparseBlock();
            for (int i = 0; i < mb.getNumRows(); ++i) {
                Arrays.fill(row, null);
                if (sblock != null && !sblock.isEmpty(i)) {
                    int apos = sblock.pos(i);
                    int alen = sblock.size(i);
                    int[] aix = sblock.indexes(i);
                    double[] aval = sblock.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        row[aix[j]] = UtilFunctions.doubleToObject(schema[aix[j]], aval[j]);
                    }
                }
                frame.appendRow(row);
            }
        } else {
            int dFreq = UtilFunctions.frequency(schema, Types.ValueType.FP64);
            if (schema.length == 1 && dFreq == 1 && mb.isAllocated()) {
                frame.reset();
                frame.appendColumns(new double[][]{mb.getDenseBlockValues()});
            } else if (dFreq == schema.length) {
                int m = mb.getNumRows();
                int n = mb.getNumColumns();
                double[][] c = new double[n][m];
                int blocksizeIJ = 32;
                if (!mb.isEmptyBlock(false)) {
                    if (mb.getDenseBlock().isContiguous()) {
                        double[] a = mb.getDenseBlockValues();
                        for (int bi = 0; bi < m; bi += blocksizeIJ) {
                            for (int bj = 0; bj < n; bj += blocksizeIJ) {
                                int bimin = Math.min(bi + blocksizeIJ, m);
                                int bjmin = Math.min(bj + blocksizeIJ, n);
                                int i = bi;
                                int aix = bi * n;
                                while (i < bimin) {
                                    for (int j = bj; j < bjmin; ++j) {
                                        c[j][i] = a[aix + j];
                                    }
                                    ++i;
                                    aix += n;
                                }
                            }
                        }
                    } else {
                        DenseBlock a = mb.getDenseBlock();
                        for (int bi = 0; bi < m; bi += blocksizeIJ) {
                            for (int bj = 0; bj < n; bj += blocksizeIJ) {
                                int bimin = Math.min(bi + blocksizeIJ, m);
                                int bjmin = Math.min(bj + blocksizeIJ, n);
                                for (int i = bi; i < bimin; ++i) {
                                    double[] avals = a.values(i);
                                    int apos = a.pos(i);
                                    for (int j = bj; j < bjmin; ++j) {
                                        c[j][i] = avals[apos + j];
                                    }
                                }
                            }
                        }
                    }
                }
                frame.reset();
                frame.appendColumns(c);
            } else {
                for (int i = 0; i < mb.getNumRows(); ++i) {
                    for (int j = 0; j < mb.getNumColumns(); ++j) {
                        row[j] = UtilFunctions.doubleToObject(schema[j], mb.quickGetValue(i, j));
                    }
                    frame.appendRow(row);
                }
            }
        }
        return frame;
    }

    public static TensorBlock convertToTensorBlock(MatrixBlock mb, Types.ValueType vt, boolean toBasicTensor) {
        TensorBlock ret;
        block5: {
            ret = toBasicTensor ? new TensorBlock(new BasicTensorBlock(vt, new int[]{mb.getNumRows(), mb.getNumColumns()}, false)) : new TensorBlock(new DataTensorBlock(vt, new int[]{mb.getNumRows(), mb.getNumColumns()}));
            ret.allocateBlock();
            if (mb.getNonZeros() <= 0L) break block5;
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret.set(cell.getI(), cell.getJ(), cell.getV());
                }
            } else {
                double[] a = mb.getDenseBlockValues();
                int ix = 0;
                for (int i = 0; i < mb.getNumRows(); ++i) {
                    int j = 0;
                    while (j < mb.getNumColumns()) {
                        ret.set(i, j, a[ix]);
                        ++j;
                        ++ix;
                    }
                }
            }
        }
        return ret;
    }

    public static MatrixBlock[] convertToMatrixBlockPartitions(MatrixBlock mb, boolean colwise) {
        MatrixBlock[] ret;
        block10: {
            int i;
            double sparsity;
            boolean sparse;
            int cols;
            int rows;
            block9: {
                ret = null;
                rows = mb.getNumRows();
                cols = mb.getNumColumns();
                long nnz = mb.getNonZeros();
                sparse = mb.isInSparseFormat();
                sparsity = (double)nnz / (double)(rows * cols);
                if (!colwise) break block9;
                ret = new MatrixBlock[cols];
                for (int j = 0; j < cols; ++j) {
                    ret[j] = new MatrixBlock(rows, 1, false);
                }
                if (mb.isEmptyBlock(false)) break block10;
                if (sparse) {
                    Iterator<IJV> iter = mb.getSparseBlockIterator();
                    while (iter.hasNext()) {
                        IJV cell = iter.next();
                        ret[cell.getJ()].appendValue(cell.getI(), 0, cell.getV());
                    }
                } else {
                    for (int i2 = 0; i2 < rows; ++i2) {
                        for (int j = 0; j < cols; ++j) {
                            ret[j].appendValue(i2, 0, mb.getValueDenseUnsafe(i2, j));
                        }
                    }
                }
                break block10;
            }
            ret = new MatrixBlock[rows];
            for (i = 0; i < rows; ++i) {
                ret[i] = new MatrixBlock(1, cols, sparse, (long)((double)cols * sparsity));
            }
            if (!mb.isEmptyBlock(false)) {
                for (i = 0; i < rows; ++i) {
                    mb.slice(i, i, 0, cols - 1, ret[i]);
                }
            }
        }
        return ret;
    }

    public static Array2DRowRealMatrix convertToArray2DRowRealMatrix(MatrixBlock mb) {
        double[][] data = DataConverter.convertToDoubleMatrix(mb);
        return new Array2DRowRealMatrix(data, false);
    }

    public static BlockRealMatrix convertToBlockRealMatrix(MatrixBlock mb) {
        BlockRealMatrix ret;
        block5: {
            ret = new BlockRealMatrix(mb.getNumRows(), mb.getNumColumns());
            if (mb.getNonZeros() <= 0L) break block5;
            if (mb.isInSparseFormat()) {
                Iterator<IJV> iter = mb.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    ret.setEntry(cell.getI(), cell.getJ(), cell.getV());
                }
            } else {
                double[] a = mb.getDenseBlockValues();
                int ix = 0;
                for (int i = 0; i < mb.getNumRows(); ++i) {
                    int j = 0;
                    while (j < mb.getNumColumns()) {
                        ret.setEntry(i, j, a[ix]);
                        ++j;
                        ++ix;
                    }
                }
            }
        }
        return ret;
    }

    public static MatrixBlock convertToMatrixBlock(RealMatrix rm) {
        MatrixBlock ret = new MatrixBlock(rm.getRowDimension(), rm.getColumnDimension(), false).allocateDenseBlock();
        for (int i = 0; i < ret.getNumRows(); ++i) {
            for (int j = 0; j < ret.getNumColumns(); ++j) {
                ret.quickSetValue(i, j, rm.getEntry(i, j));
            }
        }
        ret.examSparsity();
        return ret;
    }

    public static void copyToDoubleVector(MatrixBlock mb, double[] dest, int destPos) {
        if (mb.isEmptyBlock(false)) {
            return;
        }
        int rows = mb.getNumRows();
        int cols = mb.getNumColumns();
        if (mb.isInSparseFormat()) {
            Iterator<IJV> iter = mb.getSparseBlockIterator();
            while (iter.hasNext()) {
                IJV cell = iter.next();
                dest[destPos + cell.getI() * cols + cell.getJ()] = cell.getV();
            }
        } else {
            System.arraycopy(mb.getDenseBlockValues(), 0, dest, destPos, rows * cols);
        }
    }

    private static String dfFormat(DecimalFormat df, double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.toString(value);
        }
        return df.format(value);
    }

    public static String toString(MatrixBlock mb) {
        return DataConverter.toString(mb, false, DELIM, "\n", mb.getNumRows(), mb.getNumColumns(), 3);
    }

    public static String toString(MatrixBlock mb, boolean sparse, String separator, String lineseparator, int rowsToPrint, int colsToPrint, int decimal) {
        StringBuffer sb = new StringBuffer();
        int rlen = mb.getNumRows();
        int clen = mb.getNumColumns();
        int rowLength = rlen;
        int colLength = clen;
        if (rowsToPrint >= 0) {
            int n = rowLength = rowsToPrint < rlen ? rowsToPrint : rlen;
        }
        if (colsToPrint >= 0) {
            colLength = colsToPrint < clen ? colsToPrint : clen;
        }
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        if (decimal >= 0) {
            df.setMinimumFractionDigits(decimal);
        }
        if (sparse) {
            if (mb.isInSparseFormat()) {
                Iterator<IJV> sbi = mb.getSparseBlockIterator();
                while (sbi.hasNext()) {
                    IJV ijv = sbi.next();
                    int row = ijv.getI();
                    int col = ijv.getJ();
                    double value = ijv.getV();
                    if (row >= rowLength || col >= colLength) continue;
                    sb.append(row + 1).append(separator).append(col + 1).append(separator);
                    sb.append(DataConverter.dfFormat(df, value)).append(lineseparator);
                }
            } else {
                for (int i = 0; i < rowLength; ++i) {
                    for (int j = 0; j < colLength; ++j) {
                        double value = mb.getValue(i, j);
                        if (value == 0.0) continue;
                        sb.append(i + 1).append(separator).append(j + 1).append(separator);
                        sb.append(DataConverter.dfFormat(df, value)).append(lineseparator);
                    }
                }
            }
        } else {
            for (int i = 0; i < rowLength; ++i) {
                for (int j = 0; j < colLength - 1; ++j) {
                    Double value = mb.quickGetValue(i, j);
                    if (value.equals(-0.0)) {
                        value = 0.0;
                    }
                    sb.append(DataConverter.dfFormat(df, value));
                    sb.append(separator);
                }
                Double value = mb.quickGetValue(i, colLength - 1);
                if (value.equals(-0.0)) {
                    value = 0.0;
                }
                sb.append(DataConverter.dfFormat(df, value));
                sb.append(lineseparator);
            }
        }
        return sb.toString();
    }

    public static String toString(TensorBlock tb) {
        return DataConverter.toString(tb, false, DELIM, "\n", "[", "]", tb.getDim(0), tb.getDim(1), 3);
    }

    public static String toString(TensorBlock tb, boolean sparse, String separator, String lineseparator, String leftBorder, String rightBorder, int rowsToPrint, int colsToPrint, int decimal) {
        StringBuilder sb = new StringBuilder();
        int rlen = tb.getDim(0);
        int clen = tb.getDim(1);
        int rowLength = rlen;
        int colLength = clen;
        if (rowsToPrint >= 0) {
            rowLength = Math.min(rowsToPrint, rlen);
        }
        if (colsToPrint >= 0) {
            colLength = Math.min(colsToPrint, clen);
        }
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        if (decimal >= 0) {
            df.setMinimumFractionDigits(decimal);
        }
        if (sparse) {
            int[] ix = new int[tb.getNumDims()];
            int i = 0;
            while ((long)i < tb.getLength()) {
                String str = tb.get(ix).toString();
                if (str != null && !str.isEmpty() && Double.parseDouble(str) != 0.0) {
                    for (int item : ix) {
                        sb.append(item).append(separator);
                    }
                    DataConverter.concatenateTensorValue(tb, sb, df, ix);
                    sb.append(lineseparator);
                }
                TensorBlock.getNextIndexes(tb.getDims(), ix);
                if (ix[0] < rowLength) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int[] ix = new int[tb.getNumDims()];
            sb.append(StringUtils.repeat((String)leftBorder, (int)ix.length));
            int i = 0;
            while ((long)i < tb.getLength()) {
                int j;
                DataConverter.concatenateTensorValue(tb, sb, df, ix);
                int n = j = ix.length - 1;
                ix[n] = ix[n] + 1;
                int borderCount = 0;
                while (ix[j] == tb.getDim(j) || ix[1] >= colLength) {
                    if (ix[j] != tb.getDim(j)) {
                        sb.append("...");
                    }
                    sb.append(rightBorder);
                    ++borderCount;
                    ix[j] = 0;
                    if (--j < 0) break;
                    int n2 = j;
                    ix[n2] = ix[n2] + 1;
                }
                if (ix[0] >= rowLength) {
                    sb.append("...").append(rightBorder).append(lineseparator);
                    break;
                }
                if (j < 0) {
                    sb.append(lineseparator);
                    break;
                }
                if (borderCount == 0) {
                    sb.append(separator);
                } else {
                    sb.append(lineseparator);
                    sb.append(StringUtils.repeat((String)DELIM, (int)((ix.length - borderCount) * leftBorder.length())));
                    sb.append(StringUtils.repeat((String)leftBorder, (int)borderCount));
                }
                ++i;
            }
        }
        return sb.toString();
    }

    private static void concatenateTensorValue(TensorBlock tb, StringBuilder sb, DecimalFormat df, int[] ix) {
        switch (tb.isBasic() ? tb.getValueType() : tb.getSchema()[ix[1]]) {
            case FP32: {
                Float valuef = (Float)tb.get(ix);
                if (valuef.equals(Float.valueOf(-0.0f))) {
                    valuef = Float.valueOf(0.0f);
                }
                sb.append(DataConverter.dfFormat(df, valuef.floatValue()));
                break;
            }
            case FP64: {
                Double value = (Double)tb.get(ix);
                if (value.equals(-0.0)) {
                    value = 0.0;
                }
                sb.append(DataConverter.dfFormat(df, value));
                break;
            }
            case UINT8: 
            case INT32: 
            case INT64: {
                sb.append(tb.get(ix));
                break;
            }
            case BOOLEAN: {
                sb.append(((Boolean)tb.get(ix)).toString().toUpperCase());
                break;
            }
            case STRING: 
            case UNKNOWN: {
                sb.append("\"").append(tb.get(ix)).append("\"");
            }
        }
    }

    public static String toString(FrameBlock fb) {
        return DataConverter.toString(fb, false, DELIM, "\n", fb.getNumRows(), fb.getNumColumns(), 3);
    }

    public static String toString(FrameBlock fb, boolean sparse, String separator, String lineseparator, int rowsToPrint, int colsToPrint, int decimal) {
        int j;
        StringBuffer sb = new StringBuffer();
        int rlen = fb.getNumRows();
        int clen = fb.getNumColumns();
        int rowLength = rlen;
        int colLength = clen;
        if (rowsToPrint >= 0) {
            int n = rowLength = rowsToPrint < rlen ? rowsToPrint : rlen;
        }
        if (colsToPrint >= 0) {
            colLength = colsToPrint < clen ? colsToPrint : clen;
        }
        sb.append("# FRAME: ");
        sb.append("nrow = " + fb.getNumRows() + ", ");
        sb.append("ncol = " + fb.getNumColumns() + lineseparator);
        sb.append("#");
        sb.append(separator);
        for (j = 0; j < colLength; ++j) {
            sb.append(fb.getColumnNames()[j]);
            if (j == colLength - 1) continue;
            sb.append(separator);
        }
        sb.append(lineseparator);
        sb.append("#");
        sb.append(separator);
        for (j = 0; j < colLength; ++j) {
            sb.append((Object)fb.getSchema()[j]);
            if (j == colLength - 1) continue;
            sb.append(separator);
        }
        sb.append(lineseparator);
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        if (decimal >= 0) {
            df.setMinimumFractionDigits(decimal);
        }
        Iterator<Object[]> iter = fb.getObjectRowIterator(0, rowLength);
        while (iter.hasNext()) {
            Object[] row = iter.next();
            for (int j2 = 0; j2 < colLength; ++j2) {
                if (row[j2] == null) {
                    sb.append(String.valueOf(row[j2]));
                } else if (fb.getSchema()[j2] == Types.ValueType.FP64) {
                    sb.append(DataConverter.dfFormat(df, (Double)row[j2]));
                } else if (fb.getSchema()[j2] == Types.ValueType.BOOLEAN) {
                    sb.append(new BooleanObject((Boolean)row[j2]).getLanguageSpecificStringValue());
                } else {
                    sb.append(row[j2]);
                }
                if (j2 == colLength - 1) continue;
                sb.append(separator);
            }
            sb.append(lineseparator);
        }
        return sb.toString();
    }

    public static String toString(ListObject list, int rows, int cols, boolean sparse, String separator, String lineSeparator, int rowsToPrint, int colsToPrint, int decimal) {
        StringBuilder sb = new StringBuilder();
        sb.append("List containing:\n");
        sb.append("[");
        for (Data x : list.getData()) {
            Data dat;
            if (x instanceof MatrixObject) {
                sb.append("\nMatrix:\n");
                dat = (MatrixObject)x;
                MatrixBlock matrix = (MatrixBlock)((CacheableData)dat).acquireRead();
                sb.append(DataConverter.toString(matrix, sparse, separator, lineSeparator, rows, cols, decimal));
                ((CacheableData)dat).release();
            } else if (x instanceof TensorObject) {
                sb.append("\n");
                dat = (TensorObject)x;
                TensorBlock tensor = (TensorBlock)((CacheableData)dat).acquireRead();
                sb.append(DataConverter.toString(tensor, sparse, separator, lineSeparator, "[", "]", rows, cols, decimal));
                ((CacheableData)dat).release();
            } else if (x instanceof FrameObject) {
                sb.append("\n");
                dat = (FrameObject)x;
                FrameBlock frame = (FrameBlock)((CacheableData)dat).acquireRead();
                sb.append(DataConverter.toString(frame, sparse, separator, lineSeparator, rows, cols, decimal));
                ((CacheableData)dat).release();
            } else if (x instanceof ListObject) {
                dat = (ListObject)x;
                sb.append(DataConverter.toString((ListObject)dat, cols, rows, sparse, separator, lineSeparator, rows, cols, decimal));
            } else {
                sb.append(x.toString());
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("]");
        return sb.toString();
    }

    public static int[] getTensorDimensions(ExecutionContext ec, CPOperand dims) {
        int[] tDims;
        switch (dims.getDataType()) {
            case SCALAR: {
                if (dims.getValueType() != Types.ValueType.STRING) {
                    throw new DMLRuntimeException("Dimensions have to be passed as list, string, matrix or tensor.");
                }
                String dimensionString = ec.getScalarInput(dims.getName(), Types.ValueType.STRING, dims.isLiteral()).getStringValue();
                StringTokenizer dimensions = new StringTokenizer(dimensionString, DELIM);
                tDims = new int[dimensions.countTokens()];
                Arrays.setAll(tDims, i -> Integer.parseInt(dimensions.nextToken()));
                break;
            }
            case MATRIX: {
                MatrixBlock in = ec.getMatrixInput(dims.getName());
                boolean colVec = false;
                if (in.getNumRows() == 1) {
                    colVec = true;
                } else if (in.getNumColumns() != 1) {
                    throw new DMLRuntimeException("Dimensions matrix has to be a vector.");
                }
                tDims = new int[(int)in.getLength()];
                int i2 = 0;
                while ((long)i2 < in.getLength()) {
                    tDims[i2] = UtilFunctions.toInt(in.getValue(colVec ? 0 : i2, colVec ? i2 : 0));
                    ++i2;
                }
                ec.releaseMatrixInput(dims.getName());
                break;
            }
            case TENSOR: {
                TensorBlock in = ec.getTensorInput(dims.getName());
                boolean colVec = false;
                if (!in.isVector()) {
                    throw new DMLRuntimeException("Dimensions tensor has to be a vector.");
                }
                if (in.getNumRows() == 1) {
                    colVec = true;
                }
                tDims = new int[(int)in.getLength()];
                int i3 = 0;
                while ((long)i3 < in.getLength()) {
                    tDims[i3] = UtilFunctions.toInt(in.get(new int[]{colVec ? 0 : i3, colVec ? i3 : 0}));
                    ++i3;
                }
                ec.releaseTensorInput(dims.getName());
                break;
            }
            case LIST: {
                ListObject list = ec.getListObject(dims.getName());
                tDims = new int[list.getLength()];
                List<Data> dimsData = list.getData();
                for (int i4 = 0; i4 < tDims.length; ++i4) {
                    if (!(dimsData.get(i4) instanceof ScalarObject)) {
                        throw new DMLRuntimeException("Dims parameter for does not support lists with non scalar values.");
                    }
                    tDims[i4] = (int)((ScalarObject)dimsData.get(i4)).getLongValue();
                }
                break;
            }
            default: {
                throw new DMLRuntimeException("Dimensions have to be passed as list, string, matrix or tensor.");
            }
        }
        return tDims;
    }

    public static double[] toDouble(float[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static double[] toDouble(long[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static double[] toDouble(int[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static double[] toDouble(BitSet data, int len) {
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = data.get(i) ? 1.0 : 0.0;
        }
        return ret;
    }

    public static double[] toDouble(String[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = data[i] == null || data[i].isEmpty() ? 0.0 : Double.parseDouble(data[i]);
        }
        return ret;
    }

    public static float[] toFloat(double[] data) {
        float[] ret = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = (float)data[i];
        }
        return ret;
    }

    public static int[] toInt(double[] data) {
        int[] ret = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = UtilFunctions.toInt(data[i]);
        }
        return ret;
    }

    public static long[] toLong(double[] data) {
        long[] ret = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = UtilFunctions.toLong(data[i]);
        }
        return ret;
    }

    public static BitSet toBitSet(double[] data) {
        BitSet ret = new BitSet(data.length);
        for (int i = 0; i < data.length; ++i) {
            ret.set(i, data[i] != 0.0);
        }
        return ret;
    }

    public static String[] toString(double[] data) {
        String[] ret = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = String.valueOf(data[i]);
        }
        return ret;
    }
}

