/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.net.URL;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.TaskContext$;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSchedulerImpl$;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SparkContext$
implements Logging {
    public static SparkContext$ MODULE$;
    private final Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    private final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private Option<SparkContext> contextBeingConstructed;
    private final String SPARK_JOB_DESCRIPTION;
    private final String SPARK_JOB_GROUP_ID;
    private final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private final String SPARK_SCHEDULER_POOL;
    private final String RDD_SCOPE_KEY;
    private final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private final String DRIVER_IDENTIFIER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkContext$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS() {
        return this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return this.SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return this.org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return this.contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        this.contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get()).filter((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$1(sc, x$40))).foreach((Function1 & Serializable & scala.Serializable)ctx -> {
                String errMsg = new StringBuilder(120).append("Only one SparkContext should be running in this JVM (see SPARK-2243).").append("The currently running SparkContext was created at:\n").append(ctx.org$apache$spark$SparkContext$$creationSite().longForm()).toString();
                throw new SparkException(errMsg);
            });
            this.contextBeingConstructed().filter((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$3(sc, x$41))).foreach((Function1 & Serializable & scala.Serializable)otherContext -> {
                SparkContext$.$anonfun$assertNoOtherContextIsRunning$4(otherContext);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void org$apache$spark$SparkContext$$assertOnDriver() {
        if (TaskContext$.MODULE$.get() != null) {
            throw new IllegalStateException("SparkContext should only be created and accessed on the driver.");
        }
    }

    public SparkContext getOrCreate(SparkConf config) {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config));
            } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.getAll())).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using an existing SparkContext; some configuration may not take effect.");
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public SparkContext getOrCreate() {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext());
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public Option<SparkContext> getActive() {
        Option option;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get());
        }
        return option;
    }

    public void markPartiallyConstructed(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
        }
    }

    public void setActiveContext(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return this.SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return this.SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return this.SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String SPARK_SCHEDULER_POOL() {
        return this.SPARK_SCHEDULER_POOL;
    }

    public String RDD_SCOPE_KEY() {
        return this.RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return this.RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return this.DRIVER_IDENTIFIER;
    }

    private <T extends Writable> ArrayWritable arrayToArrayWritable(Iterable<T> arr, ClassTag<T> evidence$17) {
        return new ArrayWritable(scala.reflect.package$.MODULE$.classTag(evidence$17).runtimeClass(), (Writable[])((TraversableOnce)arr.map((Function1 & Serializable & scala.Serializable)x -> SparkContext$.anyToWritable$1(x), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Writable.class)));
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder(7).append("/").append(cls.getName().replace('.', '/')).append(".class").toString());
        return uri != null ? ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33))) : None$.MODULE$) : None$.MODULE$;
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome != null ? res.setSparkHome(sparkHome) : BoxedUnit.UNIT;
        Object object2 = jars != null && !jars.isEmpty() ? res.setJars(jars) : BoxedUnit.UNIT;
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        return this.numDriverCores(master, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int numDriverCores(String master, SparkConf conf) {
        boolean bl;
        String string = master;
        if ("local".equals(string)) {
            return 1;
        }
        Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        if ("yarn".equals(string)) {
            bl = true;
        } else {
            Option option3 = SparkMasterRegex$.MODULE$.KUBERNETES_REGEX().unapplySeq((CharSequence)string);
            if (option3.isEmpty()) return 0;
            if (option3.get() == null) return 0;
            if (((LinearSeqOptimized)option3.get()).lengthCompare(1) != 0) return 0;
            bl = true;
        }
        if (!bl) return 0;
        if (conf == null) return 0;
        String string2 = conf.get(package$.MODULE$.SUBMIT_DEPLOY_MODE());
        String string3 = "cluster";
        if (string2 == null) {
            if (string3 != null) {
                return 0;
            }
        } else if (!string2.equals(string3)) return 0;
        int n = conf.getInt(package$.MODULE$.DRIVER_CORES().key(), 0);
        return n;
    }

    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master, String deployMode) {
        Tuple2 tuple2;
        int MAX_LOCAL_TASK_FAILURES = 1;
        String string = master;
        if ("local".equals(string)) {
            SparkContext$.checkResourcesPerTask$1(1, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend2 = new LocalSchedulerBackend(sc.getConf(), scheduler, 1);
            scheduler.initialize(backend2);
            tuple2 = new Tuple2((Object)backend2, (Object)scheduler);
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                int threadCount;
                String threads;
                String string2 = threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                String string3 = "*";
                int n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? SparkContext$.localCpuCount$1() : (threadCount = new StringOps(Predef$.MODULE$.augmentString(threads)).toInt());
                if (threadCount <= 0) {
                    throw new SparkException(new StringBuilder(34).append("Asked to run locally with ").append(threadCount).append(" threads").toString());
                }
                SparkContext$.checkResourcesPerTask$1(threadCount, sc);
                TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
                LocalSchedulerBackend backend3 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                scheduler.initialize(backend3);
                tuple2 = new Tuple2((Object)backend3, (Object)scheduler);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String maxFailures = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    String string4 = threads;
                    String string5 = "*";
                    int threadCount = !(string4 != null ? !string4.equals(string5) : string5 != null) ? SparkContext$.localCpuCount$2() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
                    SparkContext$.checkResourcesPerTask$1(threadCount, sc);
                    TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, new StringOps(Predef$.MODULE$.augmentString(maxFailures)).toInt(), true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
                    LocalSchedulerBackend backend4 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                    scheduler.initialize(backend4);
                    tuple2 = new Tuple2((Object)backend4, (Object)scheduler);
                } else {
                    Option option3 = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((CharSequence)string);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                        String sparkUrl = (String)((LinearSeqOptimized)option3.get()).apply(0);
                        TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                        String[] masterUrls = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(","))).map((Function1 & Serializable & scala.Serializable)x$43 -> new StringBuilder(8).append("spark://").append((String)x$43).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        StandaloneSchedulerBackend backend5 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                        scheduler.initialize(backend5);
                        tuple2 = new Tuple2((Object)backend5, (Object)scheduler);
                    } else {
                        Option option4 = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((CharSequence)string);
                        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(3) == 0) {
                            String numWorkers = (String)((LinearSeqOptimized)option4.get()).apply(0);
                            String coresPerWorker = (String)((LinearSeqOptimized)option4.get()).apply(1);
                            String memoryPerWorker = (String)((LinearSeqOptimized)option4.get()).apply(2);
                            SparkContext$.checkResourcesPerTask$1(new StringOps(Predef$.MODULE$.augmentString(coresPerWorker)).toInt(), sc);
                            int memoryPerWorkerInt = new StringOps(Predef$.MODULE$.augmentString(memoryPerWorker)).toInt();
                            if (sc.executorMemory() > memoryPerWorkerInt) {
                                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MiB RAM / worker but requested %d MiB/worker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerWorkerInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
                            }
                            sc.conf().setIfMissing(package$.MODULE$.SHUFFLE_HOST_LOCAL_DISK_READING_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false));
                            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                            LocalSparkCluster localCluster = new LocalSparkCluster(new StringOps(Predef$.MODULE$.augmentString(numWorkers)).toInt(), new StringOps(Predef$.MODULE$.augmentString(coresPerWorker)).toInt(), memoryPerWorkerInt, sc.conf());
                            String[] masterUrls = localCluster.start();
                            StandaloneSchedulerBackend backend6 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                            scheduler.initialize(backend6);
                            backend6.shutdownCallback_$eq((Function1<StandaloneSchedulerBackend, BoxedUnit>)(Function1 & Serializable & scala.Serializable)backend -> {
                                localCluster.stop();
                                return BoxedUnit.UNIT;
                            });
                            tuple2 = new Tuple2((Object)backend6, (Object)scheduler);
                        } else {
                            Tuple2 tuple22;
                            ExternalClusterManager clusterMgr;
                            Option<ExternalClusterManager> option5 = this.getClusterManager(string);
                            if (!(option5 instanceof Some)) {
                                if (None$.MODULE$.equals(option5)) {
                                    throw new SparkException(new StringBuilder(30).append("Could not parse Master URL: '").append(master).append("'").toString());
                                }
                                throw new MatchError(option5);
                            }
                            Some some = (Some)option5;
                            ExternalClusterManager externalClusterManager = clusterMgr = (ExternalClusterManager)some.value();
                            ExternalClusterManager cm = externalClusterManager;
                            try {
                                TaskScheduler scheduler = cm.createTaskScheduler(sc, string);
                                SchedulerBackend backend7 = cm.createSchedulerBackend(sc, string, scheduler);
                                cm.initialize(scheduler, backend7);
                                tuple22 = new Tuple2((Object)backend7, (Object)scheduler);
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                if (throwable2 instanceof SparkException) {
                                    SparkException sparkException = (SparkException)throwable2;
                                    throw sparkException;
                                }
                                Option option6 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option6.isEmpty()) {
                                    Throwable e = (Throwable)option6.get();
                                    throw new SparkException("External scheduler cannot be instantiated", e);
                                }
                                throw throwable;
                            }
                            tuple2 = tuple22;
                        }
                    }
                }
            }
        }
        return tuple2;
    }

    private Option<ExternalClusterManager> getClusterManager(String url) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(ExternalClusterManager.class, loader)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)x$44.canCreate(url)));
        if (serviceLoaders.size() > 1) {
            throw new SparkException(new StringBuilder(60).append("Multiple external cluster managers registered for the url ").append(url).append(": ").append(serviceLoaders).toString());
        }
        return serviceLoaders.headOption();
    }

    public void org$apache$spark$SparkContext$$fillMissingMagicCommitterConfsIfNeeded(SparkConf conf) {
        block1: {
            Tuple2[] magicCommitterConfs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAllWithPrefix("spark.hadoop.fs.s3a.bucket."))).filter((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$fillMissingMagicCommitterConfsIfNeeded$1(x$45))))).filter((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$fillMissingMagicCommitterConfsIfNeeded$2(x$46)));
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])magicCommitterConfs)).nonEmpty()) break block1;
            conf.setIfMissing("spark.hadoop.fs.s3a.committer.magic.enabled", "true");
            if (conf.get("spark.hadoop.fs.s3a.committer.magic.enabled").equals("true")) {
                conf.setIfMissing("spark.hadoop.fs.s3a.committer.name", "magic");
                conf.setIfMissing("spark.hadoop.mapreduce.outputcommitter.factory.scheme.s3a", "org.apache.hadoop.fs.s3a.commit.S3ACommitterFactory");
                conf.setIfMissing("spark.sql.parquet.output.committer.class", "org.apache.spark.internal.io.cloud.BindingParquetOutputCommitter");
                conf.setIfMissing("spark.sql.sources.commitProtocolClass", "org.apache.spark.internal.io.cloud.PathOutputCommitProtocol");
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$1(SparkContext sc$1, SparkContext x$40) {
        return x$40 != sc$1;
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$3(SparkContext sc$1, SparkContext x$41) {
        return x$41 != sc$1;
    }

    public static final /* synthetic */ void $anonfun$assertNoOtherContextIsRunning$4(SparkContext otherContext) {
        String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1 & Serializable & scala.Serializable)x$42 -> x$42.longForm()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown location");
        String warnMsg = new StringBuilder(229).append("Another SparkContext is being constructed (or threw an exception in its constructor). This may indicate an error, since only one SparkContext should be running in this JVM (see SPARK-2243).").append(" The other SparkContext was created at:\n").append(otherContextCreationSite).toString();
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warnMsg);
    }

    private static final Writable anyToWritable$1(Writable u) {
        return u;
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
    }

    private static final void checkResourcesPerTask$1(int executorCores, SparkContext sc$2) {
        int taskCores = BoxesRunTime.unboxToInt((Object)sc$2.conf().get(package$.MODULE$.CPUS_PER_TASK()));
        Object object = !BoxesRunTime.unboxToBoolean((Object)sc$2.conf().get(Tests$.MODULE$.SKIP_VALIDATE_CORES_TESTING())) ? BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.MODULE$.validateTaskCpusLargeEnough(sc$2.conf(), executorCores, taskCores)) : BoxedUnit.UNIT;
        ResourceProfile defaultProf = sc$2.resourceProfileManager().defaultResourceProfile();
        ResourceUtils$.MODULE$.warnOnWastedResources(defaultProf, sc$2.conf(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)executorCores)));
    }

    private static final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static final /* synthetic */ boolean $anonfun$fillMissingMagicCommitterConfsIfNeeded$1(Tuple2 x$45) {
        return ((String)x$45._1()).endsWith(".committer.magic.enabled");
    }

    public static final /* synthetic */ boolean $anonfun$fillMissingMagicCommitterConfsIfNeeded$2(Tuple2 x$46) {
        return ((String)x$46._2()).equalsIgnoreCase("true");
    }

    private SparkContext$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALL", "DEBUG", "ERROR", "FATAL", "INFO", "OFF", "TRACE", "WARN"}));
        this.SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        this.org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        this.contextBeingConstructed = None$.MODULE$;
        this.SPARK_JOB_DESCRIPTION = "spark.job.description";
        this.SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        this.SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        this.SPARK_SCHEDULER_POOL = "spark.scheduler.pool";
        this.RDD_SCOPE_KEY = "spark.rdd.scope";
        this.RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        this.DRIVER_IDENTIFIER = "driver";
    }
}

