/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.rpc;

import java.io.IOException;
import java.util.Collections;
import org.apache.spark.SparkConf;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.netty.SparkTransportConf;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysds.runtime.controlprogram.paramserv.LocalParamServer;
import org.apache.sysds.runtime.controlprogram.paramserv.SparkPSProxy;
import org.apache.sysds.runtime.controlprogram.paramserv.rpc.PSRpcHandler;
import scala.Option;

public class PSRpcFactory {
    private static final String MODULE_NAME = "ps";

    private static TransportContext createTransportContext(SparkConf conf, LocalParamServer ps) {
        TransportConf tc = SparkTransportConf.fromSparkConf((SparkConf)conf, (String)MODULE_NAME, (int)0, (Option)Option.empty());
        PSRpcHandler handler = new PSRpcHandler(ps);
        return new TransportContext(tc, (RpcHandler)handler);
    }

    public static TransportServer createServer(SparkConf conf, LocalParamServer ps, String host) {
        TransportContext context = PSRpcFactory.createTransportContext(conf, ps);
        return context.createServer(host, 0, Collections.emptyList());
    }

    public static SparkPSProxy createSparkPSProxy(SparkConf conf, int port, LongAccumulator aRPC) throws IOException, InterruptedException {
        long rpcTimeout = conf.contains("spark.rpc.askTimeout") ? conf.getTimeAsMs("spark.rpc.askTimeout") : conf.getTimeAsMs("spark.network.timeout", "120s");
        String host = conf.get("spark.driver.host");
        TransportContext context = PSRpcFactory.createTransportContext(conf, new LocalParamServer());
        return new SparkPSProxy(context.createClientFactory().createClient(host, port), rpcTimeout, aRPC);
    }
}

