/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.RelationalBinaryGPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.utils.GPUStatistics;

public class ScalarMatrixRelationalBinaryGPUInstruction
extends RelationalBinaryGPUInstruction {
    protected ScalarMatrixRelationalBinaryGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        CPOperand mat = this._input1.getDataType() == Types.DataType.MATRIX ? this._input1 : this._input2;
        CPOperand scalar = this._input1.getDataType() == Types.DataType.MATRIX ? this._input2 : this._input1;
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, mat.getName());
        ScalarObject constant = ec.getScalarInput(scalar);
        int rlen = (int)in1.getNumRows();
        int clen = (int)in1.getNumColumns();
        ec.setMetaData(this._output.getName(), rlen, clen);
        ScalarOperator sc_op = (ScalarOperator)this._optr;
        sc_op = sc_op.setConstant(constant.getDoubleValue());
        LibMatrixCUDA.matrixScalarRelational(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, this._output.getName(), sc_op);
        ec.releaseMatrixInputForGPUInstruction(mat.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

