/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;

public class UnaryOperator
extends MultiThreadedOperator {
    private static final long serialVersionUID = 2441990876648978637L;
    public final ValueFunction fn;
    private final boolean inplace;

    public UnaryOperator(ValueFunction p) {
        this(p, 1, false);
    }

    public UnaryOperator(ValueFunction p, int k) {
        this(p, k, false);
    }

    public UnaryOperator(ValueFunction p, int numThreads, boolean inPlace) {
        super(p instanceof Builtin && (((Builtin)p).bFunc == Builtin.BuiltinCode.SIN || ((Builtin)p).bFunc == Builtin.BuiltinCode.TAN || ((Builtin)p).bFunc == Builtin.BuiltinCode.SINH || ((Builtin)p).bFunc == Builtin.BuiltinCode.TANH || ((Builtin)p).bFunc == Builtin.BuiltinCode.ROUND || ((Builtin)p).bFunc == Builtin.BuiltinCode.ABS || ((Builtin)p).bFunc == Builtin.BuiltinCode.SQRT || ((Builtin)p).bFunc == Builtin.BuiltinCode.SPROP || ((Builtin)p).bFunc == Builtin.BuiltinCode.LOG_NZ || ((Builtin)p).bFunc == Builtin.BuiltinCode.SIGN));
        this.fn = p;
        this._numThreads = numThreads;
        this.inplace = inPlace;
    }

    public boolean isInplace() {
        return this.inplace;
    }

    public double getPattern() {
        switch (((Builtin)this.fn).bFunc) {
            case ISNAN: 
            case ISNA: {
                return Double.NaN;
            }
            case ISINF: {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw new DMLRuntimeException("No pattern existing for " + ((Builtin)this.fn).bFunc.name());
    }
}

