/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSingleBlock
extends ReaderColumnSelection {
    private final double[] _data;
    private final int _numCols;

    protected ReaderColumnSelectionDenseSingleBlock(MatrixBlock data, IColIndex colIndices, int rl, int ru) {
        super(colIndices, rl, Math.min(ru, data.getNumRows()) - 1);
        this._data = data.getDenseBlockValues();
        this._numCols = data.getNumColumns();
    }

    @Override
    protected DblArray getNextRow() {
        boolean empty = true;
        while (empty && this._rl < this._ru) {
            ++this._rl;
            int indexOff = this._rl * this._numCols;
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                double v = this._data[indexOff + this._colIndexes.get(i)];
                boolean isNan = Double.isNaN(v);
                if (isNan) {
                    this.warnNaN();
                    this.reusableArr[i] = 0.0;
                    continue;
                }
                empty &= v == 0.0;
                this.reusableArr[i] = v;
            }
        }
        return empty ? null : this.reusableReturn;
    }
}

