/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.matrix.data.LibCommonsMath;
import org.apache.sysds.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class BinaryMatrixMatrixCPInstruction
extends BinaryCPInstruction {
    private final boolean inplace;

    protected BinaryMatrixMatrixCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
        if (op instanceof BinaryOperator) {
            String[] parts = InstructionUtils.getInstructionParts(istr);
            if (parts.length == 5) {
                ((BinaryOperator)op).setNumThreads(Integer.parseInt(parts[parts.length - 1]));
                this.inplace = false;
            } else {
                ((BinaryOperator)op).setNumThreads(Integer.parseInt(parts[parts.length - 2]));
                this.inplace = parts[parts.length - 1].equals("InPlace");
            }
        } else {
            this.inplace = false;
        }
    }

    public boolean isInPlace() {
        return this.inplace;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock retBlock;
        MatrixBlock inBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock inBlock2 = ec.getMatrixInput(this.input2.getName());
        boolean compressedLeft = inBlock1 instanceof CompressedMatrixBlock;
        boolean compressedRight = inBlock2 instanceof CompressedMatrixBlock;
        if (this.inplace && (compressedLeft || compressedRight)) {
            LOG.error((Object)"Not supporting inplace compressed binary operations yet");
        }
        if (this.inplace && !compressedLeft && !compressedRight) {
            inBlock1 = LibMatrixBincell.bincellOpInPlace(inBlock1, inBlock2, (BinaryOperator)this._optr);
            ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
            ec.removeVariable(this.input1.getName());
            retBlock = inBlock1;
        } else {
            if (LibCommonsMath.isSupportedMatrixMatrixOperation(this.getOpcode()) && !compressedLeft && !compressedRight) {
                retBlock = LibCommonsMath.matrixMatrixOperations(inBlock1, inBlock2, this.getOpcode());
            } else {
                BinaryOperator bop = (BinaryOperator)this._optr;
                retBlock = !compressedLeft && compressedRight ? ((CompressedMatrixBlock)inBlock2).binaryOperationsLeft(bop, inBlock1, new MatrixBlock()) : inBlock1.binaryOperations(bop, inBlock2, new MatrixBlock());
            }
            ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
            if (this.checkGuardedRepresentationChange(inBlock1, inBlock2, retBlock)) {
                retBlock.examSparsity();
            }
        }
        ec.setMatrixOutput(this.output.getName(), retBlock);
    }
}

