/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.HashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.Nary;
import org.apache.sysds.lops.OutputParameters;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class Data
extends Lop {
    public static final String PREAD_PREFIX = "pREAD";
    private final Types.FileFormat formatType;
    private final Types.OpOpData _op;
    private final boolean literal_var;
    private HashMap<String, Lop> _inputParams;

    public static Data createLiteralLop(Types.ValueType vt, String literalValue) {
        return new Data(Types.OpOpData.PERSISTENTREAD, null, null, null, literalValue, Types.DataType.SCALAR, vt, Types.FileFormat.BINARY);
    }

    public Data(Types.OpOpData op, Lop input, HashMap<String, Lop> inputParametersLops, String name, String literal, Types.DataType dt, Types.ValueType vt, Types.FileFormat fmt) {
        super(Lop.Type.Data, dt, vt);
        this._op = op;
        boolean bl = this.literal_var = literal != null;
        if (this.literal_var) {
            if (this._op.isTransient()) {
                throw new LopsException("Invalid parameter values while setting up a Data LOP -- transient flag is invalid for a literal.");
            }
            this.getOutputParameters().setLabel(literal);
        } else if (name != null) {
            if (this._op.isTransient()) {
                this.getOutputParameters().setLabel(name);
            } else {
                String code = this._op == Types.OpOpData.FUNCTIONOUTPUT ? "" : (this._op.isRead() ? PREAD_PREFIX : "pWRITE");
                this.getOutputParameters().setLabel((String)code + name);
            }
        } else {
            throw new LopsException("Invalid parameter values while setting up a Data LOP -- the lop must have either literal value or a name.");
        }
        if (input != null && op.isWrite()) {
            this.addInput(input);
            input.addOutput(this);
        }
        this._inputParams = inputParametersLops;
        if (this._inputParams != null) {
            for (Lop lop : inputParametersLops.values()) {
                this.addInput(lop);
                lop.addOutput(this);
            }
            if (inputParametersLops.get("iofilename") != null && inputParametersLops.get("iofilename") instanceof Data) {
                OutputParameters outParams = ((Data)inputParametersLops.get("iofilename")).getOutputParameters();
                String fName = outParams.getLabel();
                this.getOutputParameters().setFile_name(fName);
            }
        }
        this.formatType = fmt;
        this.outParams.setFormat(fmt);
        this.setLopProperties();
    }

    private void setLopProperties() {
        this.lps.setProperties(this.inputs, Types.ExecType.INVALID);
    }

    public Types.FileFormat getFileFormatType() {
        return this.formatType;
    }

    @Override
    public String toString() {
        return this.getID() + ":File_Name: " + this.getOutputParameters().getFile_name() + " Label: " + this.getOutputParameters().getLabel() + " Operation: = " + this._op + " Format: " + this.outParams.getFormat() + " Datatype: " + this.getDataType() + " Valuetype: " + this.getValueType() + " num_rows = " + this.getOutputParameters().getNumRows() + " num_cols = " + this.getOutputParameters().getNumCols() + " UpdateInPlace: " + this.getOutputParameters().getUpdateType();
    }

    public Types.OpOpData getOperationType() {
        return this._op;
    }

    public HashMap<String, Lop> getInputParams() {
        return this._inputParams;
    }

    public Lop getNamedInputLop(String name) {
        return this._inputParams.get(name);
    }

    public Lop getNamedInputLop(String name, String defaultVal) {
        if (this._inputParams.containsKey(name)) {
            return this._inputParams.get(name);
        }
        return Data.createLiteralLop(Types.ValueType.STRING, defaultVal);
    }

    public boolean isLiteral() {
        return this.literal_var;
    }

    public boolean getBooleanValue() {
        if (this.literal_var) {
            return Boolean.parseBoolean(this.getOutputParameters().getLabel());
        }
        throw new LopsException("Cannot obtain the value of a non-literal variable at compile time.");
    }

    public double getDoubleValue() {
        if (this.literal_var) {
            return Double.parseDouble(this.getOutputParameters().getLabel());
        }
        throw new LopsException("Cannot obtain the value of a non-literal variable at compile time.");
    }

    public long getLongValue() {
        if (this.literal_var) {
            Types.ValueType vt = this.getValueType();
            switch (vt) {
                case INT64: {
                    return Long.parseLong(this.getOutputParameters().getLabel());
                }
                case FP64: {
                    return (long)Double.parseDouble(this.getOutputParameters().getLabel());
                }
            }
            throw new LopsException("Encountered a non-numeric value " + vt + ", while a numeric value is expected.");
        }
        throw new LopsException("Can not obtain the value of a non-literal variable at compile time.");
    }

    public String getStringValue() {
        if (this.literal_var) {
            return this.getOutputParameters().getLabel();
        }
        throw new LopsException("Cannot obtain the value of a non-literal variable at compile time.");
    }

    public boolean isPersistentWrite() {
        return this._op == Types.OpOpData.PERSISTENTWRITE;
    }

    public boolean isPersistentRead() {
        return this._op == Types.OpOpData.PERSISTENTREAD && !this.literal_var;
    }

    public boolean isTransientWrite() {
        return this._op == Types.OpOpData.TRANSIENTWRITE;
    }

    public boolean isTransientRead() {
        return this._op == Types.OpOpData.TRANSIENTREAD;
    }

    @Override
    public String getInstructions(String input1, String input2) {
        if (this.getOutputParameters().getFile_name() == null && this._op.isRead()) {
            throw new LopsException(this.printErrorLocation() + "Data.getInstructions(): Exepecting a SCALAR data type, encountered " + this.getDataType());
        }
        StringBuilder sb = new StringBuilder();
        if (this.getExecType() == Types.ExecType.SPARK) {
            sb.append("SPARK");
        } else {
            sb.append("CP");
        }
        sb.append("\u00b0");
        if (this._op.isRead()) {
            sb.append("read");
            sb.append("\u00b0");
            sb.append(this.prepInputOperand(input1));
        } else if (this._op.isWrite()) {
            sb.append("write");
            sb.append("\u00b0");
            sb.append(this.getInputs().get(0).prepInputOperand(input1));
        } else {
            throw new LopsException(this.printErrorLocation() + "In Data Lop, Unknown operation: " + this._op);
        }
        sb.append("\u00b0");
        Lop fnameLop = this._inputParams.get("iofilename");
        boolean literal = fnameLop instanceof Data && ((Data)fnameLop).isLiteral();
        sb.append(this.prepOperand(input2, Types.DataType.SCALAR, Types.ValueType.STRING, literal));
        OutputParameters oparams = this.getOutputParameters();
        if (this._op.isWrite()) {
            Data sparseLop;
            sb.append("\u00b0");
            Types.FileFormat fmt = null;
            fmt = this.getDataType() == Types.DataType.MATRIX || this.getDataType() == Types.DataType.FRAME ? oparams.getFormat() : Types.FileFormat.TEXT;
            Lop fmtLop = this._inputParams.get("format");
            String fmtLabel = fmt != Types.FileFormat.UNKNOWN ? fmt.toString() : fmtLop.getOutputParameters().getLabel();
            sb.append(this.prepOperand(fmtLabel, Types.DataType.SCALAR, Types.ValueType.STRING, fmtLop instanceof Data && ((Data)fmtLop).isLiteral()));
            if (oparams.getFormat() == Types.FileFormat.CSV) {
                Data headerLop = (Data)this.getNamedInputLop("header");
                Data delimLop = (Data)this.getNamedInputLop("sep");
                sparseLop = (Data)this.getNamedInputLop("sparse");
                if (headerLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter header must be a literal for a seq operation.");
                }
                if (delimLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter sep must be a literal for a seq operation.");
                }
                if (sparseLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter sparse must be a literal for a seq operation.");
                }
                sb.append("\u00b0");
                sb.append(headerLop.getBooleanValue());
                sb.append("\u00b0");
                sb.append(delimLop.getStringValue());
                sb.append("\u00b0");
                sb.append(sparseLop.getBooleanValue());
                if (this.getExecType() == Types.ExecType.SPARK) {
                    sb.append("\u00b0");
                    sb.append(true);
                }
            }
            if (oparams.getFormat() == Types.FileFormat.LIBSVM) {
                Data delimLop = (Data)this.getNamedInputLop("sep");
                Data indexDelimLop = (Data)this.getNamedInputLop("indSep");
                sparseLop = (Data)this.getNamedInputLop("sparse");
                if (delimLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter sep must be a literal for a seq operation.");
                }
                if (indexDelimLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter indSep must be a literal for a seq operation.");
                }
                if (sparseLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter sparse must be a literal for a seq operation.");
                }
                sb.append("\u00b0");
                sb.append(delimLop.getStringValue());
                sb.append("\u00b0");
                sb.append(indexDelimLop.getStringValue());
                sb.append("\u00b0");
                sb.append(sparseLop.getBooleanValue());
                if (this.getExecType() == Types.ExecType.SPARK) {
                    sb.append("\u00b0");
                    sb.append(true);
                }
            }
            if (oparams.getFormat() == Types.FileFormat.HDF5) {
                Data datasetNameLop = (Data)this.getNamedInputLop("dataset");
                if (datasetNameLop.isVariable()) {
                    throw new LopsException(this.printErrorLocation() + "Parameter dataset must be a literal for a seq operation.");
                }
                sb.append("\u00b0");
                sb.append(datasetNameLop.getStringValue());
                if (this.getExecType() == Types.ExecType.SPARK) {
                    sb.append("\u00b0");
                    sb.append(true);
                }
            }
        }
        if (this._op.isWrite()) {
            sb.append("\u00b0");
            Lop descriptionLop = this.getInputParams().get("description");
            if (descriptionLop != null) {
                boolean descLiteral = descriptionLop instanceof Data && ((Data)descriptionLop).isLiteral();
                sb.append(this.prepOperand(descriptionLop.getOutputParameters().getLabel(), Types.DataType.SCALAR, Types.ValueType.STRING, descLiteral));
            } else {
                sb.append(this.prepOperand("", Types.DataType.SCALAR, Types.ValueType.STRING, true));
            }
            sb.append("\u00b0");
            sb.append(oparams.getBlocksize());
        }
        return sb.toString();
    }

    @Override
    public String getInstructions() {
        return this.getCreateVarInstructions(this.getOutputParameters().getFile_name(), this.getOutputParameters().getLabel());
    }

    @Override
    public String getInstructions(String outputFileName) {
        return this.getCreateVarInstructions(outputFileName, this.getOutputParameters().getLabel());
    }

    public String getCreateVarInstructions(String outputFileName, String outputLabel) {
        if (this.getDataType() == Types.DataType.MATRIX || this.getDataType() == Types.DataType.FRAME || this.getDataType() == Types.DataType.LIST) {
            if (this._op.isTransient()) {
                throw new LopsException("getInstructions() should not be called for transient nodes.");
            }
            OutputParameters oparams = this.getOutputParameters();
            StringBuilder sb = InstructionUtils.getStringBuilder();
            sb.append("CP");
            sb.append("\u00b0");
            sb.append("createvar");
            sb.append("\u00b0");
            sb.append(outputLabel);
            sb.append("\u00b0");
            sb.append(outputFileName);
            sb.append("\u00b0");
            sb.append(false);
            sb.append("\u00b0");
            sb.append((Object)this.getDataType());
            sb.append("\u00b0");
            sb.append(oparams.getFormat().toString());
            sb.append("\u00b0");
            sb.append(oparams.getNumRows());
            sb.append("\u00b0");
            sb.append(oparams.getNumCols());
            sb.append("\u00b0");
            sb.append(oparams.getBlocksize());
            sb.append("\u00b0");
            sb.append(oparams.getNnz());
            sb.append("\u00b0");
            sb.append(oparams.getUpdateType().toString().toLowerCase());
            if (oparams.getFormat() == Types.FileFormat.CSV) {
                sb.append("\u00b0");
                sb.append(this.createVarCSVHelper());
            }
            if (oparams.getFormat() == Types.FileFormat.LIBSVM) {
                sb.append("\u00b0");
                sb.append(this.createVarLIBSVMHelper());
            }
            if (oparams.getFormat() == Types.FileFormat.HDF5) {
                sb.append("\u00b0");
                sb.append(this.createVarHDF5Helper());
            }
            if (this.getDataType() == Types.DataType.FRAME) {
                Data schema = (Data)this.getNamedInputLop("schema");
                sb.append("\u00b0");
                sb.append(schema != null ? schema.prepScalarLabel() : "*");
            }
            return sb.toString();
        }
        throw new LopsException(this.printErrorLocation() + "In Data Lop, Unexpected data type " + this.getDataType());
    }

    private String createVarCSVHelper() {
        StringBuilder sb = new StringBuilder();
        if (this._op.isRead()) {
            Data headerLop = (Data)this.getNamedInputLop("header");
            Data delimLop = (Data)this.getNamedInputLop("sep");
            Data fillLop = (Data)this.getNamedInputLop("fill");
            Data fillValueLop = (Data)this.getNamedInputLop("default");
            Lop naLop = this.getNamedInputLop("naStrings");
            sb.append(headerLop.getBooleanValue());
            sb.append("\u00b0");
            sb.append(delimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(fillLop.getBooleanValue());
            sb.append("\u00b0");
            sb.append(fillValueLop.getDoubleValue());
            if (naLop != null) {
                sb.append("\u00b0");
                if (naLop instanceof Nary) {
                    Nary naLops = (Nary)naLop;
                    for (Lop na : naLops.getInputs()) {
                        sb.append(((Data)na).getStringValue());
                        sb.append("\u00b7");
                    }
                } else if (naLop instanceof Data) {
                    sb.append(((Data)naLop).getStringValue());
                }
            }
        } else {
            Data headerLop = (Data)this.getNamedInputLop("header");
            Data delimLop = (Data)this.getNamedInputLop("sep");
            Data sparseLop = (Data)this.getNamedInputLop("sparse");
            if (headerLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter header must be a literal for a seq operation.");
            }
            if (delimLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter sep must be a literal for a seq operation.");
            }
            if (sparseLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter sparse must be a literal for a seq operation.");
            }
            sb.append(headerLop.getBooleanValue());
            sb.append("\u00b0");
            sb.append(delimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(sparseLop.getBooleanValue());
        }
        return sb.toString();
    }

    private String createVarLIBSVMHelper() {
        StringBuilder sb = new StringBuilder();
        if (this._op.isRead()) {
            Data delimLop = (Data)this.getNamedInputLop("sep");
            Data indexDelimlLop = (Data)this.getNamedInputLop("indSep");
            sb.append(delimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(indexDelimlLop.getStringValue());
            sb.append("\u00b0");
        } else {
            Data delimLop = (Data)this.getNamedInputLop("sep");
            Data indexDelimLop = (Data)this.getNamedInputLop("indSep");
            Data sparseLop = (Data)this.getNamedInputLop("sparse");
            if (delimLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter sep must be a literal for a seq operation.");
            }
            if (indexDelimLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter indSep must be a literal for a seq operation.");
            }
            if (sparseLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter sparse must be a literal for a seq operation.");
            }
            sb.append(delimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(indexDelimLop.getStringValue());
            sb.append("\u00b0");
            sb.append(sparseLop.getBooleanValue());
        }
        return sb.toString();
    }

    private String createVarHDF5Helper() {
        StringBuilder sb = new StringBuilder();
        if (this._op.isRead()) {
            Data dataset = (Data)this.getNamedInputLop("dataset");
            sb.append(dataset != null ? dataset.getStringValue() : "*");
            sb.append("\u00b0");
        } else {
            Data datasetNameLop = (Data)this.getNamedInputLop("dataset");
            if (datasetNameLop.isVariable()) {
                throw new LopsException(this.printErrorLocation() + "Parameter dataset must be a literal for a seq operation.");
            }
            sb.append(datasetNameLop.getStringValue());
            sb.append("\u00b0");
        }
        return sb.toString();
    }
}

