/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.ISliceOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetEmpty;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetSingle;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetTwo;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class AOffset
implements Serializable {
    private static final long serialVersionUID = 6910025321078561338L;
    protected static final Log LOG = LogFactory.getLog((String)AOffset.class.getName());
    protected static final int skipStride = 1000;
    private volatile SoftReference<OffsetCacheV2[]> skipList = null;
    private volatile ThreadLocal<OffsetCache> cacheRow = new ThreadLocal<OffsetCache>(){

        @Override
        protected OffsetCache initialValue() {
            return null;
        }
    };

    public abstract AIterator getIterator();

    public abstract AOffsetIterator getOffsetIterator();

    private AIterator getIteratorFromSkipList(OffsetCacheV2 c) {
        return this.getIteratorFromIndexOff(c.row, c.dataIndex, c.offIndex);
    }

    protected abstract AIterator getIteratorFromIndexOff(int var1, int var2, int var3);

    public AIterator getIterator(int row) {
        OffsetCache c;
        if (row <= this.getOffsetToFirst()) {
            return this.getIterator();
        }
        if (row > this.getOffsetToLast()) {
            return null;
        }
        OffsetCache offsetCache = c = this.getLength() < 1000 ? null : this.cacheRow.get();
        if (c != null && c.row == row) {
            return c.it.clone();
        }
        if (this.getLength() < 1000) {
            return this.getIteratorSmallOffset(row);
        }
        return this.getIteratorLargeOffset(row);
    }

    private AIterator getIteratorSkipCache(int row) {
        if (row <= this.getOffsetToFirst()) {
            return this.getIterator();
        }
        if (row > this.getOffsetToLast()) {
            return null;
        }
        if (this.getLength() < 1000) {
            return this.getIteratorSmallOffset(row);
        }
        return this.getIteratorLargeOffset(row);
    }

    private AIterator getIteratorSmallOffset(int row) {
        AIterator it = this.getIterator();
        it.skipTo(row);
        this.cacheIterator(it.clone(), row);
        return it;
    }

    private final AIterator getIteratorLargeOffset(int row) {
        int idx;
        if (this.skipList == null || this.skipList.get() == null) {
            this.constructSkipList();
        }
        OffsetCacheV2[] skip = this.skipList.get();
        for (idx = 0; idx < skip.length && skip[idx] != null && skip[idx].row <= row; ++idx) {
        }
        AIterator it = idx == 0 ? this.getIterator() : this.getIteratorFromSkipList(skip[idx - 1]);
        it.skipTo(row);
        this.cacheIterator(it.clone(), row);
        return it;
    }

    public synchronized void constructSkipList() {
        if (this.skipList != null && this.skipList.get() != null) {
            return;
        }
        int last = this.getOffsetToLast();
        int skipSize = last / 1000 + 1;
        if (skipSize == 0) {
            return;
        }
        OffsetCacheV2[] skipListTmp = new OffsetCacheV2[skipSize];
        AIterator it = this.getIterator();
        int skipListIdx = 0;
        while (it.value() < last && skipListIdx < skipListTmp.length) {
            int next = skipListIdx * 1000 + 1000;
            while (it.value() < next && it.value() < last) {
                it.next();
            }
            skipListTmp[skipListIdx++] = new OffsetCacheV2(it.value(), it.getDataIndex(), it.getOffsetsIndex());
        }
        this.skipList = new SoftReference<OffsetCacheV2[]>(skipListTmp);
    }

    public AOffsetIterator getOffsetIterator(int row) {
        AOffsetIterator it = this.getOffsetIterator();
        int last = Math.min(row, this.getOffsetToLast());
        while (it.value() < last) {
            it.next();
        }
        return it;
    }

    public void cacheIterator(AIterator it, int row) {
        if (it == null || this.getLength() < 1000) {
            return;
        }
        this.cacheRow.set(new OffsetCache(it, row));
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract int getOffsetToFirst();

    public abstract int getOffsetToLast();

    public abstract long getInMemorySize();

    public abstract long getExactSizeOnDisk();

    public abstract int getSize();

    public final void preAggregateDenseMap(MatrixBlock m, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data) {
        AIterator it = this.getIterator(cl);
        if (it == null) {
            return;
        }
        if (it.offset > cu) {
            this.cacheIterator(it, cu);
        } else if (rl == ru - 1) {
            DenseBlock db = m.getDenseBlock();
            double[] mV = db.values(rl);
            int off = db.pos(rl);
            this.preAggregateDenseMapRow(mV, off, preAV, cu, nVal, data, it);
        } else {
            DenseBlock db = m.getDenseBlock();
            this.preAggregateDenseMapRows(db, preAV, rl, ru, cl, cu, nVal, data, it);
        }
    }

    protected final void preAggregateDenseMapRow(double[] mV, int off, double[] preAV, int cu, int nVal, AMapToData data, AIterator it) {
        int last = this.getOffsetToLast();
        if (cu <= last) {
            this.preAggregateDenseMapRowBellowEnd(mV, off, preAV, cu, nVal, data, it);
        } else {
            this.preAggregateDenseMapRowEnd(mV, off, preAV, last, nVal, data, it);
        }
    }

    protected final void preAggregateDenseMapRowBellowEnd(double[] mV, int off, double[] preAV, int cu, int nVal, AMapToData data, AIterator it) {
        it.offset += off;
        cu += off;
        while (it.offset < cu) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + mV[it.offset];
            it.next();
        }
        it.offset -= off;
        this.cacheIterator(it, cu -= off);
    }

    protected final void preAggregateDenseMapRowEnd(double[] mV, int off, double[] preAV, int last, int nVal, AMapToData data, AIterator it) {
        while (it.offset < last) {
            int dx = it.getDataIndex();
            int n = data.getIndex(dx);
            preAV[n] = preAV[n] + mV[off + it.offset];
            it.next();
        }
        int n = data.getIndex(it.getDataIndex());
        preAV[n] = preAV[n] + mV[off + last];
    }

    protected final void preAggregateDenseMapRows(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        if (!db.isContiguous()) {
            throw new NotImplementedException("Not implemented support for preAggregate non contiguous dense matrix");
        }
        if (cu <= this.getOffsetToLast()) {
            this.preAggregateDenseMapRowsBelowEnd(db, preAV, rl, ru, cl, cu, nVal, data, it);
        } else {
            this.preAggregateDenseMapRowsEnd(db, preAV, rl, ru, cl, cu, nVal, data, it);
        }
    }

    private void preAggregateDenseMapRowsBelowEnd(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        double[] vals = db.values(rl);
        int nCol = db.getCumODims(0);
        while (it.offset < cu) {
            int dataOffset = data.getIndex(it.getDataIndex());
            int start = it.offset + nCol * rl;
            int end = it.offset + nCol * ru;
            int offOut = dataOffset;
            for (int off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + vals[off];
                offOut += nVal;
            }
            it.next();
        }
        this.cacheIterator(it, cu);
    }

    private void preAggregateDenseMapRowsEnd(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        int off;
        double[] vals = db.values(rl);
        int nCol = db.getCumODims(0);
        int last = this.getOffsetToLast();
        int dataOffset = data.getIndex(it.getDataIndex());
        int start = it.offset + nCol * rl;
        int end = it.offset + nCol * ru;
        int offOut = dataOffset;
        for (off = start; off < end; off += nCol) {
            int n = offOut;
            preAV[n] = preAV[n] + vals[off];
            offOut += nVal;
        }
        while (it.offset < last) {
            it.next();
            dataOffset = data.getIndex(it.getDataIndex());
            start = it.offset + nCol * rl;
            end = it.offset + nCol * ru;
            offOut = dataOffset;
            for (off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + vals[off];
                offOut += nVal;
            }
        }
    }

    public final void preAggregateSparseMap(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, AMapToData data) {
        AIterator it = this.getIterator();
        if (rl == ru - 1) {
            this.preAggregateSparseMapRow(sb, preAV, rl, nVal, data, it);
        } else {
            this.preAggregateSparseMapRows(sb, preAV, rl, ru, nVal, data, it);
        }
    }

    private void preAggregateSparseMapRow(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int last;
        if (sb.isEmpty(r)) {
            return;
        }
        int alen = sb.size(r) + sb.pos(r);
        int[] aix = sb.indexes(r);
        if (aix[alen - 1] < (last = this.getOffsetToLast())) {
            this.preAggregateSparseMapRowBellowEnd(sb, preAV, r, nVal, data, it);
        } else {
            this.preAggregateSparseMapRowEnd(sb, preAV, r, nVal, data, it);
        }
    }

    private final void preAggregateSparseMapRowBellowEnd(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        int v = it.value();
        while (apos < alen) {
            if (aix[apos] == v) {
                int n = data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + avals[apos++];
                v = it.next();
                continue;
            }
            if (aix[apos] < v) {
                ++apos;
                continue;
            }
            v = it.next();
        }
    }

    private final void preAggregateSparseMapRowEnd(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        int last = this.getOffsetToLast();
        int v = it.value();
        while (v < last) {
            if (aix[apos] == v) {
                int n = data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + avals[apos++];
                v = it.next();
                continue;
            }
            if (aix[apos] < v) {
                ++apos;
                continue;
            }
            v = it.next();
        }
        while (aix[apos] < last && apos < alen) {
            ++apos;
        }
        if (v == aix[apos]) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + avals[apos];
        }
    }

    private void preAggregateSparseMapRows(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, AMapToData data, AIterator it) {
        int apos;
        int[] aix;
        int alen;
        int off;
        int r;
        int i = it.value();
        int last = this.getOffsetToLast();
        int[] aOffs = new int[ru - rl];
        for (r = rl; r < ru; ++r) {
            aOffs[r - rl] = sb.pos(r);
        }
        while (i < last) {
            for (r = rl; r < ru; ++r) {
                if (sb.isEmpty(r)) continue;
                off = r - rl;
                alen = sb.size(r) + sb.pos(r);
                aix = sb.indexes(r);
                for (apos = aOffs[off]; apos < alen && aix[apos] < i; ++apos) {
                }
                if (apos < alen && aix[apos] == i) {
                    int n = off * nVal + data.getIndex(it.getDataIndex());
                    preAV[n] = preAV[n] + sb.values(r)[apos];
                }
                aOffs[off] = apos;
            }
            i = it.next();
        }
        for (r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            off = r - rl;
            alen = sb.size(r) + sb.pos(r);
            aix = sb.indexes(r);
            for (apos = aOffs[off]; apos < alen && aix[apos] < last; ++apos) {
            }
            if (apos < alen && aix[apos] == last) {
                int n = off * nVal + data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + sb.values(r)[apos];
            }
            aOffs[off] = apos;
        }
    }

    public boolean equals(Object o) {
        return o instanceof AOffset && this.equals((AOffset)o);
    }

    public boolean equals(AOffset b) {
        if (this.getOffsetToLast() == b.getOffsetToLast()) {
            int last = this.getOffsetToLast();
            AOffsetIterator ia = this.getOffsetIterator();
            AOffsetIterator ib = b.getOffsetIterator();
            while (ia.value() < last) {
                if (ia.value() != ib.value()) {
                    return false;
                }
                ia.next();
                ib.next();
                if (ib.value() != last || ia.value() == last) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public abstract AOffset moveIndex(int var1);

    public abstract int getLength();

    public OffsetSliceInfo slice(int l, int u) {
        AIterator it = this.getIteratorSkipCache(l);
        if (it == null || it.value() >= u) {
            return new OffsetSliceInfo(-1, -1, new OffsetEmpty());
        }
        if (l <= this.getOffsetToFirst() && u > this.getOffsetToLast()) {
            if (l == 0) {
                return new OffsetSliceInfo(0, this.getSize(), this);
            }
            return new OffsetSliceInfo(0, this.getSize(), this.moveIndex(l));
        }
        int low = it.getDataIndex();
        int lowOff = it.getOffsetsIndex();
        int lowValue = it.value();
        int high = low;
        int highOff = lowOff;
        int highValue = lowValue;
        if (u >= this.getOffsetToLast()) {
            high = this.getSize() - 1;
            highOff = this.getLength();
            highValue = this.getOffsetToLast();
        } else {
            while (it.value() < u) {
                high = it.getDataIndex();
                highOff = it.getOffsetsIndex();
                highValue = it.value();
                it.next();
            }
        }
        if (low == high) {
            return new OffsetSliceInfo(low, high + 1, new OffsetSingle(lowValue - l));
        }
        if (low + 1 == high) {
            return new OffsetSliceInfo(low, high + 1, new OffsetTwo(lowValue - l, highValue - l));
        }
        return ((ISliceOffset)((Object)this)).slice(lowOff, highOff, lowValue - l, highValue - l, low, high);
    }

    public AOffset append(AOffset t, int s) {
        IntArrayList r = new IntArrayList(this.getLength() + t.getLength());
        AOffsetIterator of = this.getOffsetIterator();
        while (of.value() < this.getOffsetToLast()) {
            r.appendValue(of.value());
            of.next();
        }
        r.appendValue(of.value());
        AOffsetIterator tof = t.getOffsetIterator();
        int last = t.getOffsetToLast();
        while (tof.value() < last) {
            r.appendValue(tof.value() + s);
            tof.next();
        }
        r.appendValue(tof.value() + s);
        return OffsetFactory.createOffset(r);
    }

    public AOffset appendN(AOffsetsGroup[] g, int s) {
        int l = 0;
        for (AOffsetsGroup gs : g) {
            l += gs.getOffsets().getLength();
        }
        IntArrayList r = new IntArrayList(l);
        int ss = 0;
        for (AOffsetsGroup gs : g) {
            AOffset tof = gs.getOffsets();
            if (!(tof instanceof OffsetEmpty)) {
                AOffsetIterator tofit = tof.getOffsetIterator();
                int last = tof.getOffsetToLast() + ss;
                int v = tofit.value() + ss;
                while (v < last) {
                    r.appendValue(v);
                    v = tofit.next() + ss;
                }
                r.appendValue(v);
            }
            ss += s;
        }
        try {
            return OffsetFactory.createOffset(r);
        }
        catch (Exception e) {
            throw new DMLCompressionException("failed to combine" + Arrays.toString(g) + " with S sizes: " + s);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        AIterator it = this.getIterator();
        if (it != null) {
            int i = it.offset;
            int last = this.getOffsetToLast();
            sb.append("[");
            sb.append(it.offset);
            while (it.offset < last) {
                it.next();
                sb.append(", ");
                sb.append(it.offset);
                if (it.offset - i <= 0) {
                    throw new DMLCompressionException("Invalid offset");
                }
                i = it.offset;
            }
            sb.append("]");
            if (it.offset != last) {
                throw new DMLCompressionException("Invalid iteration of offset when making string, the last offset is not equal to a iteration: " + this.getOffsetToLast() + " String: " + sb.toString());
            }
        }
        return sb.toString();
    }

    public static AOffset reverse(int numRows, AOffset offsets) {
        if (numRows < offsets.getOffsetToLast()) {
            throw new DMLRuntimeException("Invalid number of rows for reverse: last: " + offsets.getOffsetToLast() + " numRows: " + numRows);
        }
        int[] newOff = new int[numRows - offsets.getSize()];
        AOffsetIterator it = offsets.getOffsetIterator();
        int last = offsets.getOffsetToLast();
        int i = 0;
        int j = 0;
        while (i < last) {
            if (i == it.value()) {
                ++i;
                it.next();
                continue;
            }
            newOff[j++] = i++;
        }
        ++i;
        while (i < numRows) {
            newOff[j++] = i++;
        }
        if (j != newOff.length) {
            throw new DMLRuntimeException("Not assigned all offsets ... something must be wrong:\n" + offsets + "\n" + Arrays.toString(newOff));
        }
        return OffsetFactory.createOffset(newOff);
    }

    protected static class OffsetCacheV2 {
        protected final int row;
        protected final int offIndex;
        protected final int dataIndex;

        protected OffsetCacheV2(int row, int dataIndex, int offIndex) {
            this.row = row;
            this.dataIndex = dataIndex;
            this.offIndex = offIndex;
        }

        public String toString() {
            return "r" + this.row + " d" + this.dataIndex + " o" + this.offIndex;
        }
    }

    protected static class OffsetCache {
        protected final AIterator it;
        protected final int row;

        protected OffsetCache(AIterator it, int row) {
            this.it = it;
            this.row = row;
        }
    }

    public static final class OffsetSliceInfo {
        public final int lIndex;
        public final int uIndex;
        public final AOffset offsetSlice;

        protected OffsetSliceInfo(int l, int u, AOffset off) {
            this.lIndex = l;
            this.uIndex = u;
            this.offsetSlice = off;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("sliceInfo: ");
            sb.append(this.lIndex);
            sb.append("->");
            sb.append(this.uIndex);
            sb.append("  --  ");
            sb.append(this.offsetSlice);
            return sb.toString();
        }
    }
}

