/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.SparkShutdownHookManager;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ShutdownHookManager$
implements Logging {
    public static ShutdownHookManager$ MODULE$;
    private SparkShutdownHookManager shutdownHooks;
    private final int DEFAULT_SHUTDOWN_PRIORITY;
    private final int SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    private final int TEMP_DIR_SHUTDOWN_PRIORITY;
    private final HashSet<String> shutdownDeletePaths;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ShutdownHookManager$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int DEFAULT_SHUTDOWN_PRIORITY() {
        return this.DEFAULT_SHUTDOWN_PRIORITY;
    }

    public int SPARK_CONTEXT_SHUTDOWN_PRIORITY() {
        return this.SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    }

    public int TEMP_DIR_SHUTDOWN_PRIORITY() {
        return this.TEMP_DIR_SHUTDOWN_PRIORITY;
    }

    /*
     * WARNING - void declaration
     */
    private SparkShutdownHookManager shutdownHooks$lzycompute() {
        ShutdownHookManager$ shutdownHookManager$ = this;
        synchronized (shutdownHookManager$) {
            if (!this.bitmap$0) {
                void var2_2;
                SparkShutdownHookManager manager = new SparkShutdownHookManager();
                manager.install();
                this.shutdownHooks = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.shutdownHooks;
    }

    private SparkShutdownHookManager shutdownHooks() {
        if (!this.bitmap$0) {
            return this.shutdownHooks$lzycompute();
        }
        return this.shutdownHooks;
    }

    private HashSet<String> shutdownDeletePaths() {
        return this.shutdownDeletePaths;
    }

    public void registerShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            this.shutdownDeletePaths().$plus$eq((Object)absolutePath);
        }
    }

    public void removeShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            this.shutdownDeletePaths().remove((Object)absolutePath);
        }
    }

    public boolean hasShutdownDeleteDir(File file) {
        boolean bl;
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            bl = this.shutdownDeletePaths().contains((Object)absolutePath);
        }
        return bl;
    }

    public boolean hasRootAsShutdownDeleteDir(File file) {
        boolean retval;
        block3: {
            boolean bl;
            String absolutePath = file.getAbsolutePath();
            HashSet<String> hashSet = this.shutdownDeletePaths();
            synchronized (hashSet) {
                bl = this.shutdownDeletePaths().exists((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.$anonfun$hasRootAsShutdownDeleteDir$1(absolutePath, path)));
            }
            retval = bl;
            if (!retval) break block3;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("path = ").append(file).append(", already present as root for deletion.").toString());
        }
        return retval;
    }

    public boolean inShutdown() {
        try {
            Thread hook = new Thread(){

                public void run() {
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            Runtime.getRuntime().removeShutdownHook(hook);
        }
        catch (IllegalStateException ise) {
            return true;
        }
        return false;
    }

    public Object addShutdownHook(Function0<BoxedUnit> hook) {
        return this.addShutdownHook(this.DEFAULT_SHUTDOWN_PRIORITY(), hook);
    }

    public Object addShutdownHook(int priority, Function0<BoxedUnit> hook) {
        return this.shutdownHooks().add(priority, hook);
    }

    public boolean removeShutdownHook(Object ref) {
        return this.shutdownHooks().remove(ref);
    }

    public static final /* synthetic */ void $anonfun$new$4(String dirPath) {
        try {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Deleting directory ").append(dirPath).toString());
            Utils$.MODULE$.deleteRecursively(new File(dirPath));
        }
        catch (Exception e) {
            MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Exception while deleting Spark temp dir: ").append(dirPath).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasRootAsShutdownDeleteDir$1(String absolutePath$1, String path) {
        return !absolutePath$1.equals(path) && absolutePath$1.startsWith(path);
    }

    private ShutdownHookManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.DEFAULT_SHUTDOWN_PRIORITY = 100;
        this.SPARK_CONTEXT_SHUTDOWN_PRIORITY = 50;
        this.TEMP_DIR_SHUTDOWN_PRIORITY = 25;
        this.shutdownDeletePaths = new HashSet();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding shutdown hook");
        this.addShutdownHook(this.TEMP_DIR_SHUTDOWN_PRIORITY(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown hook called");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.shutdownDeletePaths().toArray(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1 & Serializable & scala.Serializable)dirPath -> {
                ShutdownHookManager$.$anonfun$new$4(dirPath);
                return BoxedUnit.UNIT;
            });
        });
    }
}

