/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.enumeration;

import java.util.ArrayList;
import org.apache.sysds.resource.enumeration.Enumerator;

public class GridBasedEnumerator
extends Enumerator {
    private final int stepSizeExecutors;
    private final int expBaseExecutors;

    public GridBasedEnumerator(Enumerator.Builder builder, int stepSizeExecutors, int expBaseExecutors) {
        super(builder);
        this.stepSizeExecutors = stepSizeExecutors;
        this.expBaseExecutors = expBaseExecutors;
    }

    @Override
    public void preprocessing() {
        this.driverSpace.initSpace(this.instances);
        this.executorSpace.initSpace(this.instances);
    }

    @Override
    public boolean evaluateSingleNodeExecution(long driverMemory, int cores) {
        if (cores > CPU_QUOTA) {
            return false;
        }
        return this.minExecutors == 0;
    }

    @Override
    public ArrayList<Integer> estimateRangeExecutors(int driverCores, long executorMemory, int executorCores) {
        ArrayList<Integer> result;
        int maxAchievableLevelOfParallelism = CPU_QUOTA - driverCores;
        int currentMax = Math.min(this.maxExecutors, maxAchievableLevelOfParallelism / executorCores);
        if (this.expBaseExecutors > 1) {
            int numExecutors;
            int maxCapacity = (int)Math.floor(Math.log(currentMax) / Math.log(2.0));
            result = new ArrayList<Integer>(maxCapacity);
            int exponent = 0;
            while ((numExecutors = (int)Math.pow(this.expBaseExecutors, exponent)) <= currentMax) {
                if (numExecutors >= this.minExecutors) {
                    result.add(numExecutors);
                }
                ++exponent;
            }
        } else {
            int numExecutors;
            int capacity = (int)Math.floor((double)(currentMax - this.minExecutors + 1) / (double)this.stepSizeExecutors);
            result = new ArrayList(capacity);
            int n = numExecutors = this.minExecutors == 0 ? this.minExecutors + this.stepSizeExecutors : this.minExecutors;
            while (numExecutors <= currentMax) {
                result.add(numExecutors);
                numExecutors += this.stepSizeExecutors;
            }
        }
        return result;
    }

    public int getStepSize() {
        return this.stepSizeExecutors;
    }

    public int getExpBase() {
        return this.expBaseExecutors;
    }
}

