/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.messages;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.messages.PropertiesFileParser;

public class PropertiesFileParserImpl
implements PropertiesFileParser {
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> parsePropertiesFile(Resource resource) throws IOException {
        Map result = CollectionFactory.newCaseInsensitiveMap();
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = PropertiesFileParserImpl.readUTFStreamToEscapedASCII(resource.openStream());
            p.load(is);
            is.close();
            is = null;
        }
        finally {
            InternalUtils.close((Closeable)is);
        }
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = e.getKey().toString();
            String value = p.getProperty(key);
            result.put(key, value);
        }
        return result;
    }

    private static InputStream readUTFStreamToEscapedASCII(InputStream is) throws IOException {
        int length;
        InputStreamReader reader = new InputStreamReader(is, CHARSET);
        StringBuilder builder = new StringBuilder(2000);
        char[] buffer = new char[2000];
        while ((length = reader.read(buffer)) >= 0) {
            for (int i = 0; i < length; ++i) {
                char ch = buffer[i];
                if (ch <= '\u007f') {
                    builder.append(ch);
                    continue;
                }
                builder.append(String.format("\\u%04x", ch));
            }
        }
        ((Reader)reader).close();
        byte[] resourceContent = builder.toString().getBytes();
        return new ByteArrayInputStream(resourceContent);
    }
}

